/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.util.*;

import javax.swing.*;

import de.upb.tools.fca.FEmptyIterator;


/**
 * Layout that gets the preferred position of the component from registerred Constraints-Objects.
 * Everything else is equal to NoLayout UMLClass: 'DecoratorLayout'
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class DecoratorLayout extends NoLayout implements LayoutManager2
{
   /**
    * Constructor for class DecoratorLayout
    */
   public DecoratorLayout()
   {
      this (false);
   }


   /**
    * Constructor for class DecoratorLayout
    *
    * @param repos  No description provided
    */
   public DecoratorLayout (boolean repos)
   {
      super (repos);
   }


   /**
    * Constructor for class DecoratorLayout
    *
    * @param calc   No description provided
    * @param repos  No description provided
    */
   public DecoratorLayout (boolean calc, boolean repos)
   {
      super (calc, repos);
   }


   /**
    * UMLAttribute: 'layoutComponents : HashSet = null'
    */
   private HashMap layoutComponents = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInLayoutComponents (Component value)
   {
      return  ( (this.layoutComponents != null) &&
          (value != null) &&
         this.layoutComponents.containsValue (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? FEmptyIterator.get()
         : this.layoutComponents.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator constraintsOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? FEmptyIterator.get()
         : this.layoutComponents.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? FEmptyIterator.get()
         : this.layoutComponents.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? 0
         : this.layoutComponents.size());
   }


   /**
    * Get the constraintsFromLayoutComponents attribute of the DecoratorLayout object
    *
    * @param comp  No description provided
    * @return      The constraintsFromLayoutComponents value
    */
   public Constraints getConstraintsFromLayoutComponents (Component comp)
   {
      return  ( ( (this.layoutComponents == null) ||  (comp == null))
         ? null
         : (Constraints) this.layoutComponents.get (comp));
   }


   /**
    * Access method for an one to n association.
    *
    * @param value        The object added.
    * @param constraints  The object added.
    */
   public void addToLayoutComponents (Component value, Constraints constraints)
   {
      addLayoutComponent (value, constraints);
   }


   /**
    * Access method for an one to n association.
    *
    * @param entry  The object added.
    */
   public void addToLayoutComponents (Map.Entry entry)
   {
      addToLayoutComponents ((Component) entry.getKey(), (Constraints) entry.getValue());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    */
   public void removeFromLayoutComponents (Component value)
   {
      removeLayoutComponent (value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromLayoutComponents()
   {
      layoutComponents.clear();
   }


   /**
    * @param name   The object added.
    * @param comp   The object added.
    * @deprecated   replaced by <code>addLayoutComponent(Component, Object)</code>.
    */
   public void addLayoutComponent (String name, Component comp)
   {
      addLayoutComponent (comp, null);
   }


   /**
    * UMLMethod: '+ addLayoutComponent (comp : Component;constraints : Object) : Void'
    *
    * @param comp         The object added.
    * @param constraints  The object added.
    */
   public void addLayoutComponent (Component comp, Object constraints)
   {
      if (comp != null)
      {
         if (constraints != null && ! (constraints instanceof Constraints))
         {
            throw new IllegalArgumentException ("Constraints not of type DecoratorLayout.Constraints");
         }

         if (layoutComponents == null)
         {
            layoutComponents = new HashMap();
         }

         layoutComponents.put (comp, constraints);
      }
   }


   /**
    * UMLMethod: '+ removeLayoutComponent (comp : Component) : Void'
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp)
   {
      if (comp != null)
      {
         if (layoutComponents != null)
         {
            layoutComponents.remove (comp);
         }
      }
   }


   /**
    * UMLMethod: '+ preferredLayoutSize (parent : Container) : Dimension'
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container parent)
   {
      return preferredLayoutBounds (parent).getSize();
   }


   /**
    * UMLMethod: '+ preferredLayoutBounds (parent : Container) : Rectangle'
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Rectangle preferredLayoutBounds (Container parent)
   {
      Rectangle bounds = new Rectangle();
      bounds.width = 1;
      bounds.height = 1;

      Component[] components = parent.getComponents();

      Container parentOfParent = parent.getParent();
      LayoutManager layout =  (parentOfParent == null ? null : parentOfParent.getLayout());

      boolean repos =  (isCalcSelfRepositioning() || isSelfRepositioning()) &&  (layout == null || layout instanceof NoLayout);

      Rectangle compBounds = new Rectangle();

      for (int i = 0; i < components.length; i++)
      {
         Component comp = components[i];
         if (!comp.isVisible())
         {
            continue;
         }

         Constraints constraints = getConstraintsFromLayoutComponents (comp);
         Dimension compDim = comp.getPreferredSize();
         Point compLoc =  (constraints != null) ? constraints.getLocation (comp) : comp.getLocation();

         compBounds.setLocation (compLoc);
         compBounds.setSize (compDim);
         if (repos)
         {
            if (compLoc.x < bounds.x)
            {
               bounds.width += -compLoc.x + bounds.x;
               bounds.x = compLoc.x;
            }
            else if (i == 0)
            {
               bounds.x = compLoc.x;
            }

            if (compLoc.y < bounds.y)
            {
               bounds.height += -compLoc.y + bounds.y;
               bounds.y = compLoc.y;
            }
            else if (i == 0)
            {
               bounds.y = compLoc.y;
            }
         }
         bounds.width = Math.max (bounds.width, compLoc.x - bounds.x + compDim.width);
         bounds.height = Math.max (bounds.height, compLoc.y - bounds.y + compDim.height);
      }

      return bounds;
   }


   /**
    * UMLMethod: '+ minimumLayoutSize (parent : Container) : Dimension'
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container parent)
   {
      return preferredLayoutSize (parent);
   }


   /**
    * UMLMethod: '+ maximumLayoutSize (target : Container) : Dimension'
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension maximumLayoutSize (Container target)
   {
      return preferredLayoutSize (target);
   }


   /**
    * UMLMethod: '+ getLayoutAlignmentX (target : Container) : Float'
    *
    * @param target  No description provided
    * @return        The layoutAlignmentX value
    */
   public float getLayoutAlignmentX (Container target)
   {
      return 0.5f;
   }


   /**
    * UMLMethod: '+ getLayoutAlignmentY (target : Container) : Float'
    *
    * @param target  No description provided
    * @return        The layoutAlignmentY value
    */
   public float getLayoutAlignmentY (Container target)
   {
      return 0.5f;
   }


   /**
    * UMLMethod: '+ layoutContainer (parent : Container) : Void'
    *
    * @param parent  No description provided
    */
   public void layoutContainer (Container parent)
   {
      Component[] components = parent.getComponents();
      int offsetX = 0;
      int offsetY = 0;
      Point p = null;

      for (int i = 0; i < components.length; i++)
      {
         Component comp = components[i];

         comp.setSize (comp.getPreferredSize());

         Constraints constraints = getConstraintsFromLayoutComponents (comp);
         if (constraints != null)
         {
            p = constraints.getLocation (comp);
         }
         else
         {
            p = comp.getLocation (p);
         }

         comp.setLocation (p);
         if (-p.x > offsetX)
         {
            offsetX = -p.x;
         }

         if (-p.y > offsetY)
         {
            offsetY = -p.y;
         }
      }

      if (offsetX == 0 && offsetY == 0)
      {
         return;
      }

      Container parentOfParent = parent.getParent();
      LayoutManager layout =  (parentOfParent == null ? null : parentOfParent.getLayout());

      if (isSelfRepositioning() &&  (layout == null || layout instanceof NoLayout))
      {
         for (int i = 0; i < components.length; i++)
         {
            if (!components[i].isVisible())
            {
               continue;
            }

            JComponent jComponent = (JComponent) components[i];
            p = jComponent.getLocation (p);

            jComponent.setLocation (p.x + offsetX, p.y + offsetY);
         }

         p = parent.getLocation (p);
         parent.setLocation (p.x - offsetX, p.y - offsetY);
      }
   }


   /**
    * UMLMethod: '+ invalidateLayout (target : Container) : Void'
    *
    * @param target  No description provided
    */
   public void invalidateLayout (Container target) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.15 $
    */
   public static interface Constraints
   {
      /**
       * UMLMethod: 'Read access method for attribute target : Component'
       *
       * @return   The target value
       */
      public Component getTarget();


      /**
       * UMLMethod: 'Write access method for attribute target : Component'
       *
       * @param target  The new target value
       * @return        No description provided
       */
      public Component setTarget (Component target);


      /**
       * Get the location attribute of the Constraints object
       *
       * @param comp  No description provided
       * @return      The location value
       */
      public Point getLocation (Component comp);
   }
}

/*
 * $Log: DecoratorLayout.java,v $
 * Revision 1.15  2004/11/03 10:17:56  lowende
 * Javadoc warnings removed.
 *
 */
