/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;



/**
 * @author    rotschke This class defines directions for Grabs, ArrowHeads etc.
 * @version   $Revision: 1.2 $ $Date: 2004/10/20 17:49:48 $
 */
public class Direction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int value;


   /**
    * Constructor for class Direction
    *
    * @param value  No description provided
    */
   private Direction (int value)
   {
      this.value = value;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public static Direction fromInt (int value)
   {
      switch (value)
      {
         case 0:
            return TOP;
         case 1:
            return RIGHT;
         case 2:
            return BOTTOM;
         case 3:
            return LEFT;
         default:
            return UNDEFINED;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int asInt()
   {
      return value;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Direction reverse()
   {
      if (value == TOP.asInt())
      {
         return BOTTOM;
      }
      if (value == RIGHT.asInt())
      {
         return LEFT;
      }
      if (value == BOTTOM.asInt())
      {
         return TOP;
      }
      if (value == LEFT.asInt())
      {
         return RIGHT;
      }
      return UNDEFINED;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static Direction TOP = new Direction (0);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static Direction UNDEFINED = new Direction (-1);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static Direction RIGHT = new Direction (1);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static Direction BOTTOM = new Direction (2);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static Direction LEFT = new Direction (3);

}

/*
 * $Log: Direction.java,v $
 * Revision 1.2  2004/10/20 17:49:48  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
