/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;


/**
 * show with JLabel , edit with ...
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.8 $
 */
public abstract class EditableTextComponent extends EditableComponent
{

   /**
    * Default Constructor
    */
   public EditableTextComponent()
   {
      super();
      setComponent (new JText());
      add (getComponent());
   }


   /**
    * Get the label attribute of the EditableTextComponent object
    *
    * @return   The label value
    */
   protected JText getLabel()
   {
      return (JText) getComponent();
   }


   /**
    * Sets the font of the inner label and of the inner combobox to the specified font.
    *
    * @param font  The new font value
    */
   public void setFont (Font font)
   {
      if (getLabel() != null)
      {
         getLabel().setFont (font);
      } // end of if ()
      super.setFont (font);
   }


   /**
    * Get the font attribute of the EditableTextComponent object
    *
    * @return   The font value
    */
   public Font getFont()
   {
      if (getLabel() != null)
      {
         return getLabel().getFont();
      } // end of if ()
      return super.getFont();
   }


   /**
    * Sets the background attribute of the EditableTextComponent object
    *
    * @param newColor  The new background value
    */
   public void setBackground (Color newColor)
   {
      super.setBackground (newColor);
      if (getLabel() != null)
      {
         getLabel().setBackground (newColor);
      } // end of if ()
   }


   /**
    * Sets the foreground attribute of the EditableTextComponent object
    *
    * @param newColor  The new foreground value
    */
   public void setForeground (Color newColor)
   {
      super.setForeground (newColor);
      if (getLabel() != null)
      {
         getLabel().setForeground (newColor);
      } // end of if ()
   }


   /**
    * Sets the horizontalAlignment attribute of the EditableTextComponent object
    *
    * @param align  The new horizontalAlignment value
    */
   public void setHorizontalAlignment (int align)
   {
      getLabel().setHorizontalAlignment (align);
   }


   /**
    * Get the horizontalAlignment attribute of the EditableTextComponent object
    *
    * @return   The horizontalAlignment value
    */
   public int getHorizontalAlignment()
   {
      return getLabel().getHorizontalAlignment();
   }


   /**
    * Get the value of text.
    *
    * @return   Value of text.
    */
   public String getText()
   {
      return getLabel().getText();
   }


   /**
    * Set the value of text.
    *
    * @param text  Value to assign to text.
    */
   public void setText (String text)
   {
      if ( (getText() == null && text != null) ||
          (getText() != null && !getText().equals (text)))
      {
         String oldText = getText();
         getLabel().setText (text);
         firePropertyChange ("text", oldText, getText());
      }
   }

}

/*
 * $Log: EditableTextComponent.java,v $
 * Revision 1.8  2004/11/03 10:17:56  lowende
 * Javadoc warnings removed.
 *
 */
