/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.util.Iterator;


/**
 * Diamond shape for generalization arrow heads etc.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.4 $
 */
public class JDiamondHead extends JArrowHead
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEFAULT_WIDTH = 11;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEFAULT_HEIGHT = 17;


   /**
    * Constructor for class JDiamondHead
    */
   public JDiamondHead()
   {
      this (DEFAULT_HEIGHT);
   }


   /**
    * Constructor for class JDiamondHead
    *
    * @param filled  No description provided
    */
   public JDiamondHead (boolean filled)
   {
      this (DEFAULT_HEIGHT, filled);
   }


   /**
    * Constructor for class JDiamondHead
    *
    * @param size  The size of the arrow head
    */
   public JDiamondHead (int size)
   {
      this (size * DEFAULT_WIDTH / DEFAULT_HEIGHT, size, false);
   }


   /**
    * Constructor for class JDiamondHead
    *
    * @param size    The size of the arrow head
    * @param filled  No description provided
    */
   public JDiamondHead (int size, boolean filled)
   {
      this (size * DEFAULT_WIDTH / DEFAULT_HEIGHT, size, filled);
   }


   /**
    * Constructor for class JDiamondHead
    *
    * @param width   No description provided
    * @param height  No description provided
    * @param filled  No description provided
    */
   public JDiamondHead (int width, int height, boolean filled)
   {
      // Register size, shape may be filled
      setSize (width, height);
      setPreferredSize (new Dimension (height, height));
      setFilled (filled);

      /*
       *  Draw the cap
       */
      getShapeList().add (
         new Polygon (
         new int[]{ (height - width) / 2,  (height - 1) / 2,  (height + width - 2) / 2,  (height - 1) / 2},
         new int[]{ (height - 1) / 2, 0,  (height - 1) / 2, height - 1},
         4
         )
         );
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param g  No description provided
    */
   public void paintArrow (Graphics g)
   {
      Color oldColor = g.getColor();
      g.setColor (getForeground());

      Iterator iter = getShapeList().iterator();
      while (iter.hasNext())
      {
         Polygon shape = (Polygon) iter.next();
         Graphics2D g2d = (Graphics2D) g;
         if (getFilled())
         {
            g2d.fill (at.createTransformedShape (shape));
         }
         else
         {
            g.setColor (getBackground());
            g2d.fill (at.createTransformedShape (shape));
            g.setColor (getForeground());
            g2d.draw (at.createTransformedShape (shape));
         }
      }

      g.setColor (oldColor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object clone()
   {
      return new JDiamondHead (getWidth(), getHeight(), getFilled());
   }

}

/*
 * $Log: JDiamondHead.java,v $
 * Revision 1.4  2004/11/03 10:17:57  lowende
 * Javadoc warnings removed.
 *
 */
