/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * just a small rhomb
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14 $
 */
public class JLifeLineSegment extends JComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CHANGE_NONE = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CHANGE_ABOVE = CHANGE_NONE + 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CHANGE_BELOW = CHANGE_ABOVE + 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CHANGE_BOTH = CHANGE_BELOW + 1;


   /**
    * Constructor for class JLifeLineSegment
    */
   public JLifeLineSegment()
   {
      super();
      setOpaque (false);
      barcode = new int[]
         {
         };
      this.change = CHANGE_NONE;
   }


   /**
    * Constructor for class JLifeLineSegment
    *
    * @param barcode  No description provided
    * @param change   No description provided
    */
   public JLifeLineSegment (int[] barcode, int change)
   {
      super();
      setOpaque (false);
      this.barcode = barcode;
      this.change = change;
   }


   /**
    * Constructor for class JLifeLineSegment
    *
    * @param barcode           No description provided
    * @param change            No description provided
    * @param changeBelowLevel  No description provided
    */
   public JLifeLineSegment (int[] barcode, int change, int changeBelowLevel)
   {
      super();
      setOpaque (false);
      this.barcode = barcode;
      this.change = change;
      this.changeBelowLevel = changeBelowLevel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int change;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int changeBelowLevel = 1; //default

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int[] barcode;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param barcode  No description provided
    */
   public void setbarcode (int[] barcode)
   {
      this.barcode = barcode;
   }


   /**
    * Get the barcode attribute of the JLifeLineSegment object
    *
    * @return   The barcode value
    */
   public int[] getBarcode()
   {
      return this.barcode;
   }


   /**
    * Sets the change attribute of the JLifeLineSegment object
    *
    * @param change  The new change value
    */
   public void setChange (int change)
   {
      this.change = change;
   }


   /**
    * Get the change attribute of the JLifeLineSegment object
    *
    * @return   The change value
    */
   public int getChange()
   {
      return this.change;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static int columnWidth = 16;


   /**
    * Get the preferredSize attribute of the JLifeLineSegment object
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      return new Dimension (columnWidth + 6 * barcode.length, columnWidth * 2);
   }


   /**
    * @param g  Graphics
    */
   public void paintComponent (Graphics g)
   {
      Color oldColor = g.getColor();
      Rectangle bounds = getBounds();
      //log.info("bounds" + bounds);
      int hWidth = columnWidth / 2;
      int center = bounds.width / 2;
      //g.setColor (getBackground ());
      //g.fillRect (center - hWidth, 0, center + hWidth, bounds.height);
      g.setColor (getForeground());
      if (barcode.length == 0)
      {
         g.drawLine (center, 0, center, bounds.height);
      }
      else
      {
         for (int i = 0; i < barcode.length; i++)
         {
            if (barcode[i] == de.uni_paderborn.fujaba.uml.UMLCollabStat.TYPE_LOOP)
            {
               g.setColor (Color.black);
            }
            else if (barcode[i] == de.uni_paderborn.fujaba.uml.UMLCollabStat.TYPE_COND)
            {
               g.setColor (Color.black);
            }
            else
            {
               g.setColor (getBackground());
            }
            g.fillRect (center - hWidth + i * 6, 0, center + +hWidth + i * 6, bounds.height);
            g.setColor (getForeground());
            g.drawLine (center - hWidth + i * 6, 0, center - hWidth + i * 6, bounds.height);
            g.drawLine (center + hWidth + i * 6, 0, center + hWidth + i * 6, bounds.height);
            if (change == CHANGE_BELOW || change == CHANGE_BOTH)
            {
               if ( (barcode.length - i) <= changeBelowLevel)
               {
                  g.drawLine (center - hWidth + i * 6, bounds.height - 1, center + hWidth + i * 6, bounds.height - 1);
               }
            }

         }
         if (change == CHANGE_ABOVE || change == CHANGE_BOTH)
         {
            g.drawLine (center - hWidth +  (barcode.length - 1) * 6, 0, center + hWidth +  (barcode.length - 1) * 6, 0);
         }
      }
      g.setColor (oldColor);
   }
}

/*
 * $Log: JLifeLineSegment.java,v $
 * Revision 1.14  2004/11/03 10:17:57  lowende
 * Javadoc warnings removed.
 *
 */
