/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.10 $
 */
public class JOutlinedCircle extends de.uni_paderborn.fujaba.fsa.swing.JCircle
{
   /**
    * Get the innerRadius attribute of the JOutlinedCircle object
    *
    * @return   The innerRadius value
    */
   public int getInnerRadius()
   {
      return innerRadius;
   }


   /**
    * Sets the innerRadius attribute of the JOutlinedCircle object
    *
    * @param propValue  The new innerRadius value
    */
   public void setInnerRadius (int propValue)
   {
      if (propValue != innerRadius)
      {
         propValue = Math.abs (propValue);
         if (propValue > getRadius())
         {
            setRadius (propValue);
         }

         innerRadius = propValue;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int innerRadius = 0;


   /**
    * Constructor for class JOutlinedCircle
    */
   public JOutlinedCircle()
   {
      super();
   }


   /**
    * Constructor for class JOutlinedCircle
    *
    * @param radius  No description provided
    */
   public JOutlinedCircle (int radius)
   {
      super (radius);
   }


   /**
    * Constructor for class JOutlinedCircle
    *
    * @param outerRad  No description provided
    * @param innerRad  No description provided
    */
   public JOutlinedCircle (int outerRad, int innerRad)
   {
      this();

      int smaller = Math.min (Math.abs (outerRad), Math.abs (innerRad));
      int bigger = Math.max (Math.abs (outerRad), Math.abs (innerRad));
      setInnerRadius (smaller);
      setRadius (bigger);
      revalidate();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param g  No description provided
    */
   public void paintComponent (Graphics g)
   {
      Color oldColor = g.getColor();

      int smaller = Math.min (Math.abs (innerRadius), Math.abs (getRadius()));
      int bigger = Math.max (Math.abs (innerRadius), Math.abs (getRadius()));

      g.setColor (getBackground());
      g.fillArc (0, 0, bigger * 2, bigger * 2, 0, 360);

      g.setColor (getForeground());
      g.fillArc (bigger - smaller, bigger - smaller, smaller * 2, smaller * 2, 0, 360);
      g.drawArc (0, 0, bigger * 2, bigger * 2, 0, 360);

      g.setColor (oldColor);
   }

}

/*
 * $Log: JOutlinedCircle.java,v $
 * Revision 1.10  2004/11/03 10:17:57  lowende
 * Javadoc warnings removed.
 *
 */
