/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.util.Iterator;
import java.util.Map;

import javax.swing.*;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class LayerManager
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ELEMENT_LAYER_NAME = "elementLayer";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String BEND_LAYER_NAME = "bendLayer";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINE_LAYER_NAME = "lineLayer";

   /**
    * Convenience object defining the Default layer. Equivalent to JLayeredPane.DEFAULT_LAYER.
    */
   public final static Integer DEFAULT_ELEMENT_LAYER = JLayeredPane.DEFAULT_LAYER;
   /**
    * Convenience object defining the Bend layer. Equivalent to ELEMENT_LAYER - 10.
    */
   public final static Integer DEFAULT_BEND_LAYER = new Integer (DEFAULT_ELEMENT_LAYER.intValue() - 10);
   /**
    * Convenience object defining the Default layer. Equivalent to BEND_LAYER - 10.
    */
   public final static Integer DEFAULT_LINE_LAYER = new Integer (DEFAULT_BEND_LAYER.intValue() - 10);

   /**
    * Convenience object defining the Default layer. Equivalent to JLayeredPane.DRAG_LAYER.
    */
   public final static Integer DEFAULT_ELEMENT_DRAG_LAYER = JLayeredPane.DRAG_LAYER;
   /**
    * Convenience object defining the Bend layer. Equivalent to DEFAULT_ELEMENT_DRAG_LAYER
    * - 10.
    */
   public final static Integer DEFAULT_BEND_DRAG_LAYER = new Integer (DEFAULT_ELEMENT_DRAG_LAYER.intValue() - 10);
   /**
    * Convenience object defining the Default layer. Equivalent to DEFAULT_BEND_DRAG_LAYER
    * - 10.
    */
   public final static Integer DEFAULT_LINE_DRAG_LAYER = new Integer (DEFAULT_BEND_DRAG_LAYER.intValue() - 10);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String LAYER_NAME_PROPERTY = LayerManager.class.getName() + ".LAYER_NAME_PROPERTY";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DRAG_LAYER_PREFIX = "DRAG_";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static LayerManager singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static LayerManager get()
   {
      if (singleton == null)
      {
         new LayerManager();
      }
      return singleton;
   }


   /**
    * Constructor for class LayerManager
    */
   protected LayerManager()
   {
      if (LayerManager.singleton != null)
      {
         throw new IllegalStateException ("An instance of this singleton class already exists: " +
            LayerManager.singleton.getClass().getName());
      }
      LayerManager.singleton = this;
   }


   /**
    * Sets the defaults attribute of the LayerManager object
    */
   public void setDefaults()
   {
      addToLayerPositions (ELEMENT_LAYER_NAME, DEFAULT_ELEMENT_LAYER);
      addToLayerPositions (DRAG_LAYER_PREFIX + ELEMENT_LAYER_NAME, DEFAULT_ELEMENT_DRAG_LAYER);
      setDefaultLayer (DEFAULT_ELEMENT_LAYER);
      setDefaultLayerType (ELEMENT_LAYER_NAME);

      addToLayerPositions (BEND_LAYER_NAME, DEFAULT_BEND_LAYER);
      addToLayerPositions (DRAG_LAYER_PREFIX + BEND_LAYER_NAME, DEFAULT_BEND_DRAG_LAYER);
      addToLayerTypes (JBend.class, BEND_LAYER_NAME);

      addToLayerPositions (LINE_LAYER_NAME, DEFAULT_LINE_LAYER);
      addToLayerPositions (DRAG_LAYER_PREFIX + LINE_LAYER_NAME, DEFAULT_LINE_DRAG_LAYER);
      addToLayerTypes (JLine.class, LINE_LAYER_NAME);
   }


   /**
    * Get the layer attribute of the LayerManager object
    *
    * @param comp  No description provided
    * @return      The layer value
    */
   public int getLayer (JComponent comp)
   {
      String layerType = getLayerType (comp);
      Integer layer = getLayer (layerType, false);

      return layer.intValue();
   }


   /**
    * Get the dragLayer attribute of the LayerManager object
    *
    * @param comp  No description provided
    * @return      The dragLayer value
    */
   public int getDragLayer (JComponent comp)
   {
      String layerType = DRAG_LAYER_PREFIX + getLayerType (comp);
      Integer layer = getLayer (layerType, true);

      return layer.intValue();
   }


   /**
    * Get the layerType attribute of the LayerManager object
    *
    * @param comp  No description provided
    * @return      The layerType value
    */
   public String getLayerType (JComponent comp)
   {
      String layerType = (String) comp.getClientProperty (LAYER_NAME_PROPERTY);
      if (layerType == null)
      {
         layerType = getFromLayerTypes (comp.getClass());
         if (layerType == null)
         {
            layerType = getDefaultLayerType();
         }
      }
      return layerType;
   }


   /**
    * Sets the layerType attribute of the LayerManager class
    *
    * @param comp  The new layerType value
    * @param name  The new layerType value
    */
   public static void setLayerType (JComponent comp, String name)
   {
      comp.putClientProperty (LAYER_NAME_PROPERTY, name);
   }


   /**
    * Get the layer attribute of the LayerManager object
    *
    * @param layerType  No description provided
    * @param drag       No description provided
    * @return           The layer value
    */
   private Integer getLayer (String layerType, boolean drag)
   {
      Integer layer = null;
      if (layerType != null)
      {
         layer = getFromLayerPositions (layerType);
      }
      if (layer == null)
      {
         if (drag)
         {
            layer = getDefaultDragLayer();
         }
         else
         {
            layer = getDefaultLayer();
         }
      }
      return layer;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String defaultLayerType;


   /**
    * Sets the defaultLayerType attribute of the LayerManager object
    *
    * @param value  The new defaultLayerType value
    * @return       No description provided
    */
   public boolean setDefaultLayerType (String value)
   {
      if (value == null || !value.equals (this.defaultLayerType))
      {
         this.defaultLayerType = value;
         return true;
      }

      return false;
   }


   /**
    * Get the defaultLayerType attribute of the LayerManager object
    *
    * @return   The defaultLayerType value
    */
   public String getDefaultLayerType()
   {
      return this.defaultLayerType;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Integer defaultLayer;


   /**
    * Sets the defaultLayer attribute of the LayerManager object
    *
    * @param value  The new defaultLayer value
    * @return       No description provided
    */
   public boolean setDefaultLayer (Integer value)
   {
      if (value == null || !value.equals (this.defaultLayer))
      {
         this.defaultLayer = value;
         return true;
      }

      return false;
   }


   /**
    * Get the defaultLayer attribute of the LayerManager object
    *
    * @return   The defaultLayer value
    */
   public Integer getDefaultLayer()
   {
      return  (this.defaultLayer == null ? JLayeredPane.DEFAULT_LAYER : this.defaultLayer);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Integer defaultDragLayer;


   /**
    * Sets the defaultDragLayer attribute of the LayerManager object
    *
    * @param value  The new defaultDragLayer value
    * @return       No description provided
    */
   public boolean setDefaultDragLayer (Integer value)
   {
      if (value == null || !value.equals (this.defaultDragLayer))
      {
         this.defaultDragLayer = value;
         return true;
      }

      return false;
   }


   /**
    * Get the defaultDragLayer attribute of the LayerManager object
    *
    * @return   The defaultDragLayer value
    */
   public Integer getDefaultDragLayer()
   {
      return  (this.defaultDragLayer == null ? JLayeredPane.DRAG_LAYER : this.defaultDragLayer);
   }


   /**
    * <pre>
    *              --------- 0..1     layerTypes      0..1
    * LayerManager | clazz |--------------------------> String
    *              --------- layerManager      layerTypes
    * </pre>
    */
   private FHashMap layerTypes;


   /**
    * UMLMethod: '+ hasInLayerTypes (value: String): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInLayerTypes (String value)
   {
      return  ( (this.layerTypes != null) &&
          (value != null) &&
         this.layerTypes.containsValue (value));
   }


   /**
    * UMLMethod: '+ hasInLayerTypes (key: Class, value: String): Boolean'.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInLayerTypes (Class key, String value)
   {
      return  ( (this.layerTypes != null) &&
          (value != null) &&  (key != null) &&
          (this.layerTypes.get (key) == value));
   }


   /**
    * UMLMethod: '+ hasKeyInLayerTypes (key: Class): Boolean'.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean hasKeyInLayerTypes (Class key)
   {
      return  ( (this.layerTypes != null) &&
          (key != null) &&
         this.layerTypes.containsKey (key));
   }


   /**
    * UMLMethod: '+ iteratorOfLayerTypes (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfLayerTypes()
   {
      return  ( (this.layerTypes == null)
         ? FEmptyIterator.get()
         : this.layerTypes.values().iterator());
   }


   /**
    * UMLMethod: '+ keysOfLayerTypes (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator keysOfLayerTypes()
   {
      return  ( (this.layerTypes == null)
         ? FEmptyIterator.get()
         : this.layerTypes.keySet().iterator());
   }


   /**
    * UMLMethod: '+ entriesOfLayerTypes (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator entriesOfLayerTypes()
   {
      return  ( (this.layerTypes == null)
         ? FEmptyIterator.get()
         : this.layerTypes.entrySet().iterator());
   }


   /**
    * UMLMethod: '+ sizeOfLayerTypes ()'.
    *
    * @return   No description provided
    */
   public int sizeOfLayerTypes()
   {
      return  ( (this.layerTypes == null)
         ? 0
         : this.layerTypes.size());
   }


   /**
    * UMLMethod: '+ getFromLayerTypes (key: Class): String'.
    *
    * @param key  No description provided
    * @return     The fromLayerTypes value
    */
   public String getFromLayerTypes (Class key)
   {
      return  ( ( (this.layerTypes == null) ||  (key == null))
         ? null
         : (String) this.layerTypes.get (key));
   }


   /**
    * UMLMethod: '+ addToLayerTypes (key: Class, value: String): Boolean'.
    *
    * @param key    The object added.
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToLayerTypes (Class key, String value)
   {
      boolean changed = false;
      if ( (value != null) &&  (key != null))
      {
         if (this.layerTypes == null)
         {
            this.layerTypes = new FHashMap(); // or FTreeMap
         }
         String oldValue = (String) this.layerTypes.put (key, value);
         if (!value.equals (oldValue))
         {
            changed = true;
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeFromLayerTypes (value: String): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromLayerTypes (String value)
   {
      boolean changed = false;
      if ( (this.layerTypes != null) &&  (value != null))
      {
         Iterator iter = this.entriesOfLayerTypes();
         Map.Entry entry;
         while (iter.hasNext())
         {
            entry = (Map.Entry) iter.next();
            if (entry.getValue() == value)
            {
               changed = changed || this.removeFromLayerTypes ((Class) entry.getKey(), value);
            }
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeFromLayerTypes (key: Class, value: String): Boolean'.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromLayerTypes (Class key, String value)
   {
      boolean changed = false;
      if ( (this.layerTypes != null) &&  (value != null) &&  (key != null))
      {
         String oldValue = (String) this.layerTypes.get (key);
         if (value.equals (oldValue))
         {
            this.layerTypes.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeKeyFromLayerTypes (key: Class): Boolean'.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean removeKeyFromLayerTypes (Class key)
   {
      boolean changed = false;
      if ( (this.layerTypes != null) &&  (key != null))
      {
         String tmpValue = (String) this.layerTypes.get (key);
         if (tmpValue != null)
         {
            this.layerTypes.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeAllFromLayerTypes (): Void'.
    */
   public void removeAllFromLayerTypes()
   {
      Iterator iter = entriesOfLayerTypes();
      Map.Entry entry;
      while (iter.hasNext())
      {
         entry = (Map.Entry) iter.next();
         removeFromLayerTypes ((Class) entry.getKey(), (String) entry.getValue());
      }
   }


   /**
    * <pre>
    *              --------- 0..1     layerPositions      0..1
    * LayerManager | clazz |--------------------------> Integer
    *              --------- layerManager      layerPositions
    * </pre>
    */
   private FHashMap layerPositions;


   /**
    * UMLMethod: '+ hasInLayerPositions (value: Integer): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInLayerPositions (Integer value)
   {
      return  ( (this.layerPositions != null) &&
          (value != null) &&
         this.layerPositions.containsValue (value));
   }


   /**
    * UMLMethod: '+ hasInLayerPositions (key: String, value: Integer): Boolean'.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInLayerPositions (String key, Integer value)
   {
      return  ( (this.layerPositions != null) &&
          (value != null) &&  (key != null) &&
          (this.layerPositions.get (key) == value));
   }


   /**
    * UMLMethod: '+ hasKeyInLayerPositions (key: String): Boolean'.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean hasKeyInLayerPositions (String key)
   {
      return  ( (this.layerPositions != null) &&
          (key != null) &&
         this.layerPositions.containsKey (key));
   }


   /**
    * UMLMethod: '+ iteratorOfLayerPositions (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfLayerPositions()
   {
      return  ( (this.layerPositions == null)
         ? FEmptyIterator.get()
         : this.layerPositions.values().iterator());
   }


   /**
    * UMLMethod: '+ keysOfLayerPositions (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator keysOfLayerPositions()
   {
      return  ( (this.layerPositions == null)
         ? FEmptyIterator.get()
         : this.layerPositions.keySet().iterator());
   }


   /**
    * UMLMethod: '+ entriesOfLayerPositions (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator entriesOfLayerPositions()
   {
      return  ( (this.layerPositions == null)
         ? FEmptyIterator.get()
         : this.layerPositions.entrySet().iterator());
   }


   /**
    * UMLMethod: '+ sizeOfLayerPositions ()'.
    *
    * @return   No description provided
    */
   public int sizeOfLayerPositions()
   {
      return  ( (this.layerPositions == null)
         ? 0
         : this.layerPositions.size());
   }


   /**
    * UMLMethod: '+ getFromLayerPositions (key: String): Integer'.
    *
    * @param key  No description provided
    * @return     The fromLayerPositions value
    */
   public Integer getFromLayerPositions (String key)
   {
      return  ( ( (this.layerPositions == null) ||  (key == null))
         ? null
         : (Integer) this.layerPositions.get (key));
   }


   /**
    * UMLMethod: '+ addToLayerPositions (key: String, value: Integer): Boolean'.
    *
    * @param key    The object added.
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToLayerPositions (String key, Integer value)
   {
      boolean changed = false;
      if ( (value != null) &&  (key != null))
      {
         if (this.layerPositions == null)
         {
            this.layerPositions = new FHashMap(); // or FTreeMap
         }
         Integer oldValue = (Integer) this.layerPositions.put (key, value);
         if (!value.equals (oldValue))
         {
            changed = true;
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeFromLayerPositions (value: Integer): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromLayerPositions (Integer value)
   {
      boolean changed = false;
      if ( (this.layerPositions != null) &&  (value != null))
      {
         Iterator iter = this.entriesOfLayerPositions();
         Map.Entry entry;
         while (iter.hasNext())
         {
            entry = (Map.Entry) iter.next();
            if (entry.getValue() == value)
            {
               changed = changed || this.removeFromLayerPositions ((String) entry.getKey(), value);
            }
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeFromLayerPositions (key: String, value: Integer): Boolean'.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromLayerPositions (String key, Integer value)
   {
      boolean changed = false;
      if ( (this.layerPositions != null) &&  (value != null) &&  (key != null))
      {
         Integer oldValue = (Integer) this.layerPositions.get (key);
         if (value.equals (oldValue))
         {
            this.layerPositions.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeKeyFromLayerPositions (key: String): Boolean'.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean removeKeyFromLayerPositions (String key)
   {
      boolean changed = false;
      if ( (this.layerPositions != null) &&  (key != null))
      {
         Integer tmpValue = (Integer) this.layerPositions.get (key);
         if (tmpValue != null)
         {
            this.layerPositions.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeAllFromLayerPositions (): Void'.
    */
   public void removeAllFromLayerPositions()
   {
      Iterator iter = entriesOfLayerPositions();
      Map.Entry entry;
      while (iter.hasNext())
      {
         entry = (Map.Entry) iter.next();
         removeFromLayerPositions ((String) entry.getKey(), (Integer) entry.getValue());
      }
   }
}

/*
 * $Log: LayerManager.java,v $
 * Revision 1.8  2004/10/20 17:49:47  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
