/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.util.Iterator;


/**
 * THE choice for rectangular shaped targets
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
public class LifeLineGrabLayouter extends GrabLayouter
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static LifeLineGrabLayouter layouter = null;


   /**
    * Constructor for class LifeLineGrabLayouter
    */
   private LifeLineGrabLayouter()
   {
      super();
   }


   /**
    * @return   the singleton instance
    */
   public static GrabLayouter get()
   {
      if (layouter == null)
      {
         layouter = new LifeLineGrabLayouter();
      }

      return layouter;
   }


   /**
    * layout all the grabs of manager<p>
    *
    * currently the grabs are simply set to their preferred location as determined by layoutGrab
    * and getPreferredLayoutInformation.<p>
    *
    * Overlapping is not handled
    *
    * @param manager  No description provided
    * @see            de.uni_paderborn.fujaba.fsa.swing.GrabLayouter#getPreferredLayoutInformation
    */
   public void layout (GrabManager manager)
   {
      if (manager.sizeOfGrabs() != 2)
      {
         return;
      }
      Iterator grabIter = manager.iteratorOfGrabs();
      JLifeLineSegment jllsegment = (JLifeLineSegment) manager.getTarget();
      Container jparent = jllsegment.getParent();
      Point parentPos = jparent.getLocation();
      Rectangle bounds = jllsegment.getBounds();

      if (grabIter.hasNext())
      {
         try
         {
            JGrab jgrab = (JGrab) grabIter.next();

            JPolyLine jpolyline = null;

            JBendLine jbendline = jgrab.getFirstFromLines();
            if (jbendline instanceof JPolyLine.LineSegment)
            {
               JPolyLine.LineSegment lineSegment = (JPolyLine.LineSegment) jbendline;
               jpolyline = lineSegment.getPolyLine();
            }
            else
            {
               jpolyline = (JPolyLine) jbendline;
            }

            grabIter = jpolyline.iteratorOfBends();

            // there should exist exactly four bends to be layouted as
            //
            // | |
            // | |x---x
            // | |    | m1 ()
            // | |x<--x
            //
            JBend jbend = (JBend) grabIter.next();

            // upper left jgrab
            Point oldLocation = jbend.getLocation();
            int newx = parentPos.x + bounds.x + bounds.width;
            int newy = parentPos.y + bounds.y + 5;
            if (newx - oldLocation.x >= 3 || newy - oldLocation.y >= 3 || newx - oldLocation.x <= -3 || newy - oldLocation.y <= -3)
            {
               jbend.setLocation (newx, newy);
            }

            // upper right bend
            jbend = (JBend) grabIter.next();
            newx = parentPos.x + bounds.x + bounds.width + 84;
            newy = parentPos.y + bounds.y + 5;
            oldLocation = jbend.getLocation();
            if (newx - oldLocation.x >= 3 || newy - oldLocation.y >= 3 || newx - oldLocation.x <= -3 || newy - oldLocation.y <= -3)
            {
               jbend.setPoint (newx, newy);
            }

            // lower right bend
            jbend = (JBend) grabIter.next();
            newx = parentPos.x + bounds.x + bounds.width + 84;
            newy = parentPos.y + bounds.y + bounds.height - 5;
            oldLocation = jbend.getLocation();
            if (newx - oldLocation.x >= 3 || newy - oldLocation.y >= 3 || newx - oldLocation.x <= -3 || newy - oldLocation.y <= -3)
            {
               jbend.setPoint (newx, newy);
            }

            // lower left jgrab
            jbend = (JBend) grabIter.next();
            oldLocation = jbend.getLocation();
            newx = parentPos.x + bounds.x + bounds.width;
            newy = parentPos.y + bounds.y + bounds.height - 5;
            if (newx - oldLocation.x >= 3 || newy - oldLocation.y >= 3 || newx - oldLocation.x <= -3 || newy - oldLocation.y <= -3)
            {
               jbend.setLocation (newx, newy);
                ((JGrab) jbend).setOrientation (Direction.RIGHT);
            }
         }
         catch (Exception e)
         {
         }
      }
   }
}

/*
 * $Log: LifeLineGrabLayouter.java,v $
 * Revision 1.9  2004/10/20 17:49:47  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
