/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.20 $
 */
public class NoLayout implements LayoutManager
{
   /**
    * Constructor for class NoLayout
    */
   public NoLayout()
   {
      this (false);
   }


   /**
    * Constructor for class NoLayout
    *
    * @param rePos  No description provided
    */
   public NoLayout (boolean rePos)
   {
      this (false, true);
   }


   /**
    * Constructor for class NoLayout
    *
    * @param calc   No description provided
    * @param rePos  No description provided
    */
   public NoLayout (boolean calc, boolean rePos)
   {
      super();
      setCalcSelfRepositioning (calc);
      setSelfRepositioning (rePos);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean selfRepositioning = false;


   /**
    * Sets the selfRepositioning attribute of the NoLayout object
    *
    * @param replace  The new selfRepositioning value
    */
   public void setSelfRepositioning (boolean replace)
   {
      if (this.selfRepositioning != replace)
      {
         this.selfRepositioning = replace;
      }
   }


   /**
    * Get the selfRepositioning attribute of the NoLayout object
    *
    * @return   The selfRepositioning value
    */
   public boolean isSelfRepositioning()
   {
      return selfRepositioning;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean calcSelfRepositioning = false;


   /**
    * Sets the calcSelfRepositioning attribute of the NoLayout object
    *
    * @param replace  The new calcSelfRepositioning value
    */
   public void setCalcSelfRepositioning (boolean replace)
   {
      if (this.calcSelfRepositioning != replace)
      {
         this.calcSelfRepositioning = replace;
      }
   }


   /**
    * Get the calcSelfRepositioning attribute of the NoLayout object
    *
    * @return   The calcSelfRepositioning value
    */
   public boolean isCalcSelfRepositioning()
   {
      return calcSelfRepositioning;
   }


   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name,
                                   Component comp) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp) { }


   /**
    * UMLMethod: '+ preferredLayoutSize (parent : Container) : Dimension'
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container parent)
   {
      return preferredLayoutBounds (parent).getSize();
   }


   /**
    * UMLMethod: '+ preferredLayoutBounds (parent : Container) : Rectangle'
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Rectangle preferredLayoutBounds (Container parent)
   {
      Rectangle bounds = new Rectangle();
      bounds.width = 1;
      bounds.height = 1;

      int offsetX = 0;
      int offsetY = 0;
      Component[] components = parent.getComponents();

      Container parentOfParent = parent.getParent();
      LayoutManager layout =  (parentOfParent == null ? null : parentOfParent.getLayout());

      boolean repos =  (isSelfRepositioning() || isCalcSelfRepositioning())
         &&  (layout == null || layout instanceof NoLayout);

      for (int i = 0; i < components.length; i++)
      {
         Component comp = components[i];
         if (!comp.isVisible() || comp instanceof JLine)
         {
            continue;
         }

         Dimension compDim = comp.getPreferredSize();
         Point compLoc = comp.getLocation();

         if (repos)
         {
            if (-compLoc.x > offsetX)
            {
               bounds.width += -compLoc.x - offsetX;
               offsetX = -compLoc.x;
            }

            if (-compLoc.y > offsetY)
            {
               bounds.height += -compLoc.y - offsetY;
               offsetY = -compLoc.y;
            }
         }
         bounds.width = Math.max (bounds.width, compLoc.x + offsetX + compDim.width);
         bounds.height = Math.max (bounds.height, compLoc.y + offsetY + compDim.height);
      }

      if (repos &&  (offsetX > 0 || offsetY > 0))
      {
         bounds.x = -offsetX;
         bounds.y = -offsetY;
      }
      return bounds;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container parent)
   {
      return preferredLayoutSize (parent);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    */
   public void layoutContainer (Container parent)
   {
      Component[] components = parent.getComponents();

      int offsetX = 0;
      int offsetY = 0;

      Point location = null;
      for (int i = 0; i < components.length; i++)
      {
         // invisible components and bends should not be layouted by NoLayout
         // mtt: bends and grabs are layouted by specific layouter (eg PanelGrabLayouter)
         // this is a fix for the repositioning of the whole panel due to negative
         // grab locations
         if (!components[i].isVisible() ||  (components[i] instanceof JBend) ||  (components[i] instanceof JLine))
         {
            continue;
         }

         location = components[i].getLocation (location);
         if (-location.x > offsetX)
         {
            offsetX = -location.x;
         }

         if (-location.y > offsetY)
         {
            offsetY = -location.y;
         }
      }

      JComponent jComponent = null;
      for (int i = 0; i < components.length; i++)
      {
         jComponent = (JComponent) components[i];

         // CAUTION: MUNTZING: do not layout JLines, it needs to much time. AZ
         if (!jComponent.isVisible() && ! (jComponent instanceof JBend) || jComponent instanceof JLine)
         {
            continue;
         }

         location = jComponent.getLocation (location);
         //Insets insets = parent.getInsets ();

         //location.translate (insets.top, insets.left);

         jComponent.setSize (jComponent.getPreferredSize());
         jComponent.setLocation (location.x + offsetX, location.y + offsetY);
      }

      Container parentOfParent = parent.getParent();
      LayoutManager layout =  (parentOfParent == null ? null : parentOfParent.getLayout());

      if (isSelfRepositioning() &&  (layout == null || layout instanceof NoLayout))
      {
         location = parent.getLocation (location);
         parent.setLocation (location.x - offsetX, location.y - offsetY);
      }
   }
}

/*
 * $Log: NoLayout.java,v $
 * Revision 1.20  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
