/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class ResizeableLayout extends NoLayout implements LayoutManager
{
   /**
    * Constructor for class ResizeableLayout
    */
   public ResizeableLayout()
   {
      super();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container parent)
   {
      Dimension dim = null;
      Container old = parent;

      while ( (parent != null) && ! (parent instanceof JPanel))
      {
         parent = parent.getParent();
      }

      if ( (parent != null) &&  (parent instanceof JPanel))
      {
         JPanel panel = (JPanel) parent;

         if (panel.isPreferredSizeSet())
         {
            Insets insets = parent.getInsets();
            dim = parent.getSize();
            dim.setSize (dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
         }
         else
         {
            dim = super.preferredLayoutSize (old);
         }
      }

      return dim;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    */
   public void layoutContainer (Container parent)
   {
      // do not layout this container, just redraw components

      Component[] component = parent.getComponents();

      for (int i = 0; i < component.length; i++)
      {
         if (!component[i].isVisible())
         {
            continue;
         }

         JComponent jComponent = (JComponent) component[i];
         Point location = jComponent.getLocation();

         jComponent.setSize (jComponent.getPreferredSize());
         jComponent.setLocation (location.x, location.y);

         jComponent.invalidate();
         jComponent.revalidate();
         jComponent.repaint();
      }

   }
}

/*
 * $Log: ResizeableLayout.java,v $
 * Revision 1.11  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
