/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;
import javax.swing.plaf.ComponentUI;


/**
 * Grab UI in rhomb shape
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class RhombGrabUI extends GrabUI
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static RhombGrabUI filledUI = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static RhombGrabUI hollowUI = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param filled  No description provided
    * @return        No description provided
    */
   public static RhombGrabUI get (boolean filled)
   {
      if (filled)
      {
         if (filledUI == null)
         {
            filledUI = new RhombGrabUI (true);
         }
         return filledUI;
      }
      else
      {
         if (hollowUI == null)
         {
            hollowUI = new RhombGrabUI (false);
         }
         return hollowUI;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @return   No description provided
    */
   public static ComponentUI createUI (JComponent c)
   {
      return get (false);
   }


   /**
    * Constructor for class RhombGrabUI
    */
   private RhombGrabUI()
   {
      this (false);
   }


   /**
    * Constructor for class RhombGrabUI
    *
    * @param filled  No description provided
    */
   private RhombGrabUI (boolean filled)
   {
      setFilled (filled);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean filled = false;


   /**
    * Sets the filled attribute of the RhombGrabUI object
    *
    * @param filled  The new filled value
    */
   public void setFilled (boolean filled)
   {
      if (this.filled != filled)
      {
         this.filled = filled;
      }
   }


   /**
    * Get the filled attribute of the RhombGrabUI object
    *
    * @return   The filled value
    */
   public boolean isFilled()
   {
      return this.filled;
   }


   /**
    * Get the minimumSize attribute of the RhombGrabUI object
    *
    * @param c  No description provided
    * @return   The minimumSize value
    */
   public Dimension getMinimumSize (JComponent c)
   {
      return new Dimension (3, 3);
   }


   /**
    * Get the maximumSize attribute of the RhombGrabUI object
    *
    * @param c  No description provided
    * @return   The maximumSize value
    */
   public Dimension getMaximumSize (JComponent c)
   {
      return new Dimension (Integer.MAX_VALUE, Integer.MAX_VALUE);
   }


   /**
    * Get the preferredSize attribute of the RhombGrabUI object
    *
    * @param c  No description provided
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize (JComponent c)
   {
      return new Dimension (15, 15);
   }


   /**
    * @param g  Graphics
    * @param c  No description provided
    */
   public void paint (Graphics g, JComponent c)
   {
      Color oldColor = g.getColor();
      Rectangle bounds = new Rectangle (c.getSize());
      Insets insets = c.getInsets();
      bounds.x += insets.left;
      bounds.y += insets.top;
      bounds.width -= insets.left + insets.right;
      bounds.height -= insets.top + insets.bottom;

      int newX[] = new int[5];
      int newY[] = new int[5];

      newX[0] = bounds.x;
      newX[1] = bounds.x + bounds.width / 2;
      newX[2] = bounds.x + bounds.width - 1;
      newX[3] = bounds.x + bounds.width / 2 - 1;
      newX[4] = bounds.x;

      newY[0] = bounds.y + bounds.height / 2;
      newY[1] = bounds.y;
      newY[2] = bounds.y + bounds.width / 2 - 1;
      newY[3] = bounds.y + bounds.height - 1;
      newY[4] = bounds.y + bounds.height / 2;

      if (!isFilled())
      {
         g.setColor (c.getBackground());
         g.fillPolygon (newX, newY, 5);
         g.setColor (c.getForeground());
         g.drawPolyline (newX, newY, 5);
      }
      else
      {
         g.setColor (c.getForeground());
         g.fillPolygon (newX, newY, 5);
      }
      g.setColor (oldColor);
   }
}

/*
 * $Log: RhombGrabUI.java,v $
 * Revision 1.9  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
