/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.*;

import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.pcs.CollectionChangeEvent;


/**
 * comboBoxModel for UMLTypeList
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14 $
 */
public class UMLTypeListComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
   PropertyChangeListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static UMLTypeListComboBoxModel singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static UMLTypeListComboBoxModel get()
   {
      if (singleton == null ||
         singleton.theProject == null)
      {
         singleton = new UMLTypeListComboBoxModel();
      }

      return singleton;
   }


   /**
    * Remember the project, this model is used for. If the project will be removed,
    * this attribute is set to null and a new singleton instance is created.
    */
   private UMLProject theProject;


   /**
    * Private default Constructor, use UMLTypeListComboBoxModel.get() to get the singleton instance.
    */
   private UMLTypeListComboBoxModel()
   {
      super();
      this.theProject = UMLProject.get();
      this.theProject.addPropertyChangeListener (UMLProject.PROPERTY_TYPE_LIST, this);
      this.theProject.addPropertyChangeListener ("removeYou", this);

      UMLTypeList umlTypeList = this.theProject.getTypeList();
      umlTypeList.addPropertyChangeListener ("types", this);
      addAll (umlTypeList);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector types = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Object selectedItem = null;


   /**
    * Get the selectedItem attribute of the UMLTypeListComboBoxModel object
    *
    * @return   The selectedItem value
    */
   public Object getSelectedItem()
   {
      return this.selectedItem;
   }


   /**
    * Sets the selectedItem attribute of the UMLTypeListComboBoxModel object
    *
    * @param value  The new selectedItem value
    */
   public void setSelectedItem (Object value)
   {
      if (this.selectedItem != value)
      {
         if (value instanceof String)
         {
            value = UMLProject.get().getTypeList().getFromTypes ((String) value);
         }

         this.selectedItem = (FType) value;

         fireContentsChanged (this, -1, -1);
      }
   }


   /**
    * Get the elementAt attribute of the UMLTypeListComboBoxModel object
    *
    * @param index  No description provided
    * @return       The elementAt value
    */
   public Object getElementAt (int index)
   {
      if (index == -1)
      {
         return getSelectedItem();
      }

      return  (this.types != null ?
         this.types.elementAt (index) :
         null);
   }


   /**
    * Get the size attribute of the UMLTypeListComboBoxModel object
    *
    * @return   The size value
    */
   public int getSize()
   {
      return  (this.types != null ?
         this.types.size() : 0);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLTypeListComboBoxModel";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type  No description provided
    */
   private synchronized void sortIn (UMLType type)
   {
      if (this.types == null)
      {
         this.types = new Vector();
      }
      String name = type.getName();

      int size = this.types.size();
      int upper = size - 1;
      int lower = 0;
      int order = 0;
      UMLType tmpType = null;

      while (lower < upper)
      {
         int center =  (upper + lower) / 2;
         tmpType = (UMLType) this.types.get (center);
         order = name.compareTo (tmpType.getName());
         if (order < 0)
         {
            upper = center - 1;
         }
         else if (order == 0)
         {
            upper = lower = center;
         }
         else
         {
            lower = center + 1;
         }
      }

      if (upper == -1)
      {
         this.types.add (0, type);
         fireIntervalAdded (this, 0, 0);
      }
      else if (order == 0)
      {
         this.types.add (lower, type);
         fireIntervalAdded (this, lower, lower);
      }
      else
      {
         tmpType = (UMLType) this.types.get (lower);
         order = name.compareTo (tmpType.getName());
         if (order <= 0)
         {
            this.types.add (lower, type);
            fireIntervalAdded (this, lower, lower);
         }
         else
         {
            this.types.add (lower + 1, type);
            fireIntervalAdded (this, lower + 1, lower + 1);
         }
      }
   }


   /**
    * Access method for a To N-association.
    *
    * @param umlTypeList  The object added.
    */
   private void addAll (UMLTypeList umlTypeList)
   {
      Iterator iter = umlTypeList.iteratorOfTypes();
      while (iter.hasNext())
      {
         UMLType tmpType = (UMLType) iter.next();
         tmpType.addPropertyChangeListener ("name", this);
         sortIn (tmpType);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type  No description provided
    */
   private synchronized void remove (FType type)
   {
      if (this.types != null)
      {
         int index = this.types.indexOf (type);
         if (index > -1)
         {
            this.types.remove (index);
            fireIntervalRemoved (this, index, index);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private synchronized void removeAll()
   {
      if (this.types != null)
      {
         this.types.clear();
         fireIntervalRemoved (this, 0, 0);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void propertyChange (PropertyChangeEvent event)
   {
      UMLType umlType;

      if ("removeYou".equals (event.getPropertyName()) &&
         event.getSource() instanceof UMLProject)
      {
         // the project changes, create a new singleton object during next get() call
         this.theProject = null;
      }
      else if (UMLProject.PROPERTY_TYPE_LIST.equals (event.getPropertyName()) &&
         event.getSource() instanceof UMLProject)
      {
         UMLTypeList oldTypeList = (UMLTypeList) event.getOldValue();
         if (oldTypeList != null)
         {
            oldTypeList.removePropertyChangeListener (this);
            removeAll();
         }

         UMLTypeList newTypeList = (UMLTypeList) event.getNewValue();
         if (newTypeList != null)
         {
            newTypeList.addPropertyChangeListener ("types", this);
            addAll (newTypeList);
         }
      }
      else if ("types".equals (event.getPropertyName()) && event instanceof CollectionChangeEvent)
      {
         CollectionChangeEvent cce = (CollectionChangeEvent) event;
         switch (cce.getType())
         {
            case CollectionChangeEvent.ADDED:
            case CollectionChangeEvent.ADDED_AFTER:
            case CollectionChangeEvent.ADDED_BEFORE:
               umlType = (UMLType) event.getNewValue();
               umlType.addPropertyChangeListener ("name", this);
               sortIn (umlType);
               break;
            case CollectionChangeEvent.REMOVED:
            case CollectionChangeEvent.REMOVED_AFTER:
               umlType = (UMLType) event.getOldValue();
               umlType.removePropertyChangeListener ("name", this);
               remove (umlType);
               break;
         }
      }
      else if ("name".equals (event.getPropertyName()) && event.getSource() instanceof UMLType)
      {
         umlType = (UMLType) event.getSource();
         if (this.types == null || !this.types.contains (umlType))
         {
            return;
         }

         remove (umlType);
         sortIn (umlType);
         if (umlType == getSelectedItem())
         {
            fireContentsChanged (this, -1, -1);
         }
      }
   }
}

/*
 * $Log: UMLTypeListComboBoxModel.java,v $
 * Revision 1.14  2005/03/20 12:47:12  lowende
 * Memory leak removed.
 *
 */
