/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import javax.swing.*;
import javax.swing.event.*;

import de.uni_paderborn.fujaba.metamodel.FDeclaration;


/**
 * comboBoxModel for UMLVisibility
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class UMLVisibilityComboBoxModel
    implements ComboBoxModel
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private EventListenerList listenerList = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Integer cache[] = new Integer[]
      {
      new Integer (FDeclaration.PRIVATE),
      new Integer (FDeclaration.PUBLIC),
      new Integer (FDeclaration.PROTECTED),
      new Integer (FDeclaration.PACKAGE),
      new Integer (FDeclaration.USERDEFINED)
      };

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Integer selectedItem = null;


   /**
    * Default Constructor
    */
   public UMLVisibilityComboBoxModel()
   {
      super();
      listenerList = new EventListenerList();
   }


   /**
    * Get the selectedItem attribute of the UMLVisibilityComboBoxModel object
    *
    * @return   The selectedItem value
    */
   public Object getSelectedItem()
   {
      return this.selectedItem;
   }


   /**
    * Sets the selectedItem attribute of the UMLVisibilityComboBoxModel object
    *
    * @param value  The new selectedItem value
    */
   public void setSelectedItem (Object value)
   {
      if (this.selectedItem != value)
      {
         this.selectedItem = (Integer) value;

         fireContentsChanged (this, -1, -1);
      }
   }


   /**
    * Get the elementAt attribute of the UMLVisibilityComboBoxModel object
    *
    * @param index  No description provided
    * @return       The elementAt value
    */
   public Object getElementAt (int index)
   {
      return cache[index]; // this.typeCache.elementAt ( index )  ;

   }


   /**
    * Get the size attribute of the UMLVisibilityComboBoxModel object
    *
    * @return   The size value
    */
   public int getSize()
   {
      return cache.length;
   }


   /**
    * Add a listener to the list that's notified each time a change to the data model occurs.
    *
    * @param l  the ListDataListener
    */
   public void addListDataListener (ListDataListener l)
   {
      listenerList.add (ListDataListener.class, l);
   }


   /**
    * Remove a listener from the list that's notified each time a change to the data model
    * occurs.
    *
    * @param l  the ListDataListener
    */
   public void removeListDataListener (ListDataListener l)
   {
      listenerList.remove (ListDataListener.class, l);
   }


   /**
    * Call this method <b>after</b> one or more elements of the list change (uml-assocs are
    * created or deleted). The changed elements are specified by a closed interval index0,
    * index1, i.e. the range that includes both index0 and index1. Note that index0 need not
    * be less than or equal to index1.
    *
    * @param source  The ListModel that changed, typically "this".
    * @param index0  One end of the new interval.
    * @param index1  The other end of the new interval.
    * @see           EventListenerList
    * @see           DefaultListModel
    */
   protected void fireContentsChanged (Object source, int index0, int index1)
   {
      Object[] listeners = listenerList.getListenerList();
      ListDataEvent e = null;

      for (int i = listeners.length - 2; i >= 0; i -= 2)
      {
         if (listeners[i] == ListDataListener.class)
         {
            if (e == null)
            {
               e = new ListDataEvent (this, ListDataEvent.CONTENTS_CHANGED, index0, index1);
            }
             ((ListDataListener) listeners[i + 1]).contentsChanged (e);
         }
      }
   }


   /**
    * Call this method <b>after</b> one or more elements are added to the model (uml-assocs
    * are created). The new elements are specified by a closed interval index0, index1, i.e.
    * the range that includes both index0 and index1. Note that index0 need not be less than
    * or equal to index1.
    *
    * @param source  The ListModel that changed, typically "this".
    * @param index0  One end of the new interval.
    * @param index1  The other end of the new interval.
    * @see           EventListenerList
    * @see           DefaultListModel
    */
   protected void fireIntervalAdded (Object source, int index0, int index1)
   {
      Object[] listeners = listenerList.getListenerList();
      ListDataEvent e = null;

      for (int i = listeners.length - 2; i >= 0; i -= 2)
      {
         if (listeners[i] == ListDataListener.class)
         {
            if (e == null)
            {
               e = new ListDataEvent (this, ListDataEvent.INTERVAL_ADDED, index0, index1);
            }
             ((ListDataListener) listeners[i + 1]).intervalAdded (e);
         }
      }
   }


   /**
    * Call this method <b>after</b> one or more elements are removed from the model (uml-assocs
    * are removed). The new elements are specified by a closed interval index0, index1, i.e.
    * the range that includes both index0 and index1. Note that index0 need not be less than
    * or equal to index1.
    *
    * @param source  The ListModel that changed, typically "this".
    * @param index0  One end of the new interval.
    * @param index1  The other end of the new interval.
    * @see           EventListenerList
    * @see           DefaultListModel
    */
   protected void fireIntervalRemoved (Object source, int index0, int index1)
   {
      Object[] listeners = listenerList.getListenerList();
      ListDataEvent e = null;

      for (int i = listeners.length - 2; i >= 0; i -= 2)
      {
         if (listeners[i] == ListDataListener.class)
         {
            if (e == null)
            {
               e = new ListDataEvent (this, ListDataEvent.INTERVAL_REMOVED, index0, index1);
            }
             ((ListDataListener) listeners[i + 1]).intervalRemoved (e);
         }
      }
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLVisibilityComboBoxModel";
   }
}

/*
 * $Log: UMLVisibilityComboBoxModel.java,v $
 * Revision 1.11  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
