/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mm $
 * @version   $Revision: 1.7 $
 */
public class CrossBorder extends LineBorder
{

   /**
    * Constructor for class CrossBorder
    *
    * @param aColor  No description provided
    */
   public CrossBorder (Color aColor)
   {
      super (aColor);
   }


   /**
    * Get the borderOpaque attribute of the CrossBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return false;
   }


   /**
    * This method draws the Border for Set objects.
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c, Graphics g, int x, int y, int width, int height)
   {
      Color oldColor = g.getColor();
      g.setColor (getBorderColor());

      Graphics2D g2d = (Graphics2D) g;
      Stroke oldStroke = g2d.getStroke();
      g2d.setStroke (getStroke());

      g.drawLine (x, y, x + width, y + height);
      g.drawLine (x + width, y, x, y + height);

      g.setColor (oldColor);
      g2d.setStroke (oldStroke);
   }
}

/*
 * $Log: CrossBorder.java,v $
 * Revision 1.7  2004/11/12 09:32:07  mm
 * line, cross and set borders can be dashed and have thickness > 1
 *
 */
