/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.6 $
 */
public class StateBorder extends AbstractColorBorder
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Insets borderInsets = new Insets (1, 0, 1, 0);


   /**
    * Get the borderInsets attribute of the StateBorder object
    *
    * @param c  No description provided
    * @return   The borderInsets value
    */
   public Insets getBorderInsets (Component c)
   {
      return borderInsets;
   }


   /**
    * Sets the borderInsets attribute of the StateBorder object
    *
    * @param x1  The new borderInsets value
    * @param y1  The new borderInsets value
    * @param x2  The new borderInsets value
    * @param y2  The new borderInsets value
    */
   public void setBorderInsets (int x1, int y1, int x2, int y2)
   {
      borderInsets = new Insets (x1, y1, x2, y2);
   }


   /**
    * Get the borderInsets attribute of the StateBorder object
    *
    * @param c       No description provided
    * @param insets  No description provided
    * @return        The borderInsets value
    */
   public Insets getBorderInsets (Component c, Insets insets)
   {
      return borderInsets;
   }


   /**
    * Get the borderOpaque attribute of the StateBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return false;
   }


   /**
    * This method draws the Border for Activities. It consists of a two lines at top and bottom
    * and the half of an ellipsoid at left and right. <pre>
    *  ----
    * (    )
    *  ----
    * </pre>
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
   {
      Color oldColor = g.getColor();
      g.setColor (getBorderColor());
      g.drawRoundRect (x, y, width - 1, height - 1, 15, 15);
      g.setColor (oldColor);
   }


   /**
    * The main program for the StateBorder class
    *
    * @param args  The command line arguments
    */
   public static void main (String[] args)
   {

      de.uni_paderborn.fujaba.fsa.FSACollapsable complexStatePanel = new de.uni_paderborn.fujaba.fsa.FSACollapsable (null, "MainNaem", null);
      complexStatePanel.setBorder (new StateBorder());

      de.uni_paderborn.fujaba.fsa.swing.JCollapsable jPanel = (de.uni_paderborn.fujaba.fsa.swing.JCollapsable) complexStatePanel.getJComponent();
      jPanel.setInsetWidth (11);
      jPanel.setPreferredSize (new Dimension (200, 200));

      java.awt.Frame f = new java.awt.Frame();
      f.add (jPanel);
      f.setVisible (true);
   }
}

/*
 * $Log: StateBorder.java,v $
 * Revision 1.6  2004/10/20 17:49:49  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
