/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.unparse;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.NoSuchElementException;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.upb.tools.fca.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.18 $
 */
public class FSAInterface implements PropertyChangeListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean unparse = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private LogicUnparseInterface logic = null;


   /**
    * Constructor for class FSAInterface
    *
    * @param logic  No description provided
    */
   public FSAInterface (LogicUnparseInterface logic)
   {
      this.logic = logic;
      if (logic == null)
      {
         throw new IllegalArgumentException ("Argument must not be null!");
      }
   }


   /**
    * Get the logic attribute of the FSAInterface object
    *
    * @return   The logic value
    */
   public LogicUnparseInterface getLogic()
   {
      return this.logic;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllFromFsaObjects();
      this.logic = null;
   }


   /**
    * Sets the unparse attribute of the FSAInterface object
    *
    * @param unparse  The new unparse value
    */
   public void setUnparse (boolean unparse)
   {
      this.unparse = unparse;
   }


   /**
    * Get the unparse attribute of the FSAInterface object
    *
    * @return   The unparse value
    */
   public boolean isUnparse()
   {
      return this.unparse;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void propertyChange (PropertyChangeEvent e)
   {
      UnparseManager.get().propertyChange (this, e);
   }


   /**
    * <pre>
    *              ----------------- 0..1   swingAdapter   0..1
    * FSAInterface | qualifiedName |---------------------------- FSAObject
    *              ----------------- interface       fsaObjects
    * </pre> Where qualifiedName is DiagramName.PropertyName
    */
   private transient FTreeMap fsaObjects = null;


   /**
    * Access method for an one to n association.
    *
    * @param elem  The object added.
    */
   public void addToFsaObjects (FSAObject elem)
   {
      if (elem != null)
      {
         String qualifiedName = elem.getQualifiedName();
         if ( (qualifiedName != null) &&  ( (this.fsaObjects == null) || this.fsaObjects.isEmpty() || !this.fsaObjects.containsValue (elem)))
         {
            if (this.fsaObjects == null)
            {
               // Create a new container for the fsaObjects association.
               this.fsaObjects = new FTreeMap();
            } // if

            if (this.fsaObjects.containsKey (qualifiedName))
            {
               // There is already another value with the same key, so remove the old key/value pair.
               removeKeyFromFsaObjects (qualifiedName);
            } // if

            // Add the new key/value pair to the assoc.
            this.fsaObjects.put (qualifiedName, elem);
            elem.setFSAInterface (this);
         }
      } // if

   }


   /**
    * UMLMethod: '+ getKeyFromFsaObjects (elem : FSAObject) : String'
    *
    * @param elem  No description provided
    * @return      The keyFromFsaObjects value
    */
   public String getKeyFromFsaObjects (FSAObject elem)
   {
      String qualifiedName = null;

      if (elem != null && sizeOfFsaObjects() > 0)
      {
         qualifiedName = elem.getQualifiedName();
         FSAObject tmpObj = getFromFsaObjects (qualifiedName);

         if (tmpObj == null || tmpObj != elem)
         {
            qualifiedName = null;
         }
      } // if

      return qualifiedName;
   }


   /**
    * Get the fromFsaObjects attribute of the FSAInterface object
    *
    * @param qualifiedName  No description provided
    * @return               The fromFsaObjects value
    */
   public FSAObject getFromFsaObjects (String qualifiedName)
   {
      FSAObject tmpFSAObject = null;
      if (this.fsaObjects != null)
      {
         tmpFSAObject = (FSAObject) this.fsaObjects.get (qualifiedName);
      } // if

      return tmpFSAObject;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfFsaObjects()
   {
      return  (fsaObjects != null) ? fsaObjects.size() : 0;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public boolean hasInFsaObjects (FSAObject elem)
   {
      return  ( (this.fsaObjects != null) &&  (elem != null) && !this.fsaObjects.isEmpty() && this.fsaObjects.containsValue (elem));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param qualifiedName  No description provided
    * @return               No description provided
    */
   public boolean hasKeyInFsaObjects (String qualifiedName)
   {
      return  ( (this.fsaObjects != null) &&  (qualifiedName != null) && this.fsaObjects.containsKey (qualifiedName));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfFsaObjects()
   {
      return  ( (this.fsaObjects == null)
         ? FEmptyIterator.get()
         : this.fsaObjects.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator keysOfFsaObjects()
   {
      return  ( (this.fsaObjects == null)
         ? FEmptyIterator.get()
         : this.fsaObjects.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfFsaObjects()
   {
      return  ( (this.fsaObjects == null)
         ? FEmptyIterator.get()
         : this.fsaObjects.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    */
   public void removeFromFsaObjects (FSAObject elem)
   {
      if ( (elem != null) &&  (this.fsaObjects != null) &&  (!this.fsaObjects.isEmpty()) && this.fsaObjects.containsValue (elem))
      {
         this.fsaObjects.removeValue (elem);
         elem.removeYou();
      } // if
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param qualifiedName  No description provided
    */
   public void removeKeyFromFsaObjects (String qualifiedName)
   {
      if ( (qualifiedName != null) &&  (this.fsaObjects != null) &&  (!this.fsaObjects.isEmpty()) && this.fsaObjects.containsKey (qualifiedName))
      {
         FSAObject removedFSAObject = (FSAObject) this.fsaObjects.remove (qualifiedName);
         removedFSAObject.removeYou();
      } // if

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromFsaObjects()
   {
      if ( (this.fsaObjects != null) && !this.fsaObjects.isEmpty())
      {
         Iterator iter = iteratorOfFsaObjects();
         while (iter.hasNext())
         {
            FSAObject tmpFSAObject = (FSAObject) iter.next();
            String key = tmpFSAObject.getQualifiedName();
            removeKeyFromFsaObjects (key);
         } // while

      } // if
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param oldKey  No description provided
    * @param object  No description provided
    */
   public void updateKeyInFsaObjects (String oldKey, FSAObject object)
   {
      if (oldKey != null && object != null && object.getFSAInterface() == this && this.fsaObjects != null)
      {
         FSAObject oldObject = (FSAObject) this.fsaObjects.get (oldKey);

         if (oldObject == object)
         {
            this.fsaObjects.remove (oldKey);
            this.fsaObjects.put (object.getQualifiedName(), object);
         }
      }
   }

   // ------------------------ some convenience methods for fsas --------------------
   /**
    * UMLMethod: '+ hasEntryInFsaObjects (qualifiedName : String;elem : FSAObject) : Boolean'
    *
    * @param qualifiedName  No description provided
    * @param elem           No description provided
    * @return               No description provided
    */
   public boolean hasEntryInFsaObjects (String qualifiedName, FSAObject elem)
   {
      return  ( (qualifiedName != null && elem != null) &&
          (getFromFsaObjects (qualifiedName) == elem));
   }


   /**
    * UMLMethod: '+ isFsaObjectsEmpty () : Boolean'
    *
    * @return   The fsaObjectsEmpty value
    */
   public boolean isFsaObjectsEmpty()
   {
      return  (sizeOfFsaObjects() == 0);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param property  No description provided
    * @return          No description provided
    */
   public Iterator iteratorOfFsaObjects (String property)
   {
      return  (isFsaObjectsEmpty() ?
         FEmptyIterator.get() :
         new FsaPropertyIterator (iteratorOfFsaObjects(), property));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Iterator iteratorOfFsaObjects (FSAObject parent)
   {
      return  (isFsaObjectsEmpty() ?
         FEmptyIterator.get() :
         new FsaParentIterator (iteratorOfFsaObjects(), parent));
   }


   /**
    * UMLMethod: '+ removePropertyFromFsaObjects (propertyName : String) : Void'
    *
    * @param propertyName  No description provided
    */
   public void removePropertyFromFsaObjects (String propertyName)
   {
      Iterator propIter = iteratorOfFsaObjects (propertyName);

      while (propIter.hasNext())
      {
         String qualifiedName =  ((FSAObject) propIter.next()).getQualifiedName();
         removeKeyFromFsaObjects (qualifiedName);
      }
   }


   /**
    * Get the unparseModule attribute of the FSAInterface object
    *
    * @return   The unparseModule value
    */
   public UnparseInterface getUnparseModule()
   {
      return UnparseManager.get().getUnparseModule (getLogic());
   }


   /**
    * Get the mainFsaName attribute of the FSAInterface object
    *
    * @return   The mainFsaName value
    */
   public String getMainFsaName()
   {
      return getUnparseModule().getMainFsaName();
   }


   /**
    * Get the mainFsaFromFsaObjects attribute of the FSAInterface object
    *
    * @param parent  No description provided
    * @return        The mainFsaFromFsaObjects value
    */
   public FSAObject getMainFsaFromFsaObjects (FSAObject parent)
   {
      UnparseInterface unparseModule = UnparseManager.get().getUnparseModule (getLogic());
      if (unparseModule != null)
      {
         return getFromFsaObjects (parent, unparseModule.getMainFsaName());
      }
      else
      {
         return null;
      }
   }



   /**
    * Get the fromFsaObjects attribute of the FSAInterface object
    *
    * @param parent    No description provided
    * @param property  No description provided
    * @return          The fromFsaObjects value
    */
   public FSAObject getFromFsaObjects (FSAObject parent, String property)
   {
      return getFromFsaObjects (FSAObject.getQualifiedName (parent, property));
   }


   /**
    * Get the firstFromFsaObjects attribute of the FSAInterface object
    *
    * @return   The firstFromFsaObjects value
    */
   public FSAObject getFirstFromFsaObjects()
   {
      FSAObject temp = null;
      if (fsaObjects != null)
      {
         Iterator iter = iteratorOfFsaObjects();

         if (iter.hasNext())
         {
            temp = (FSAObject) iter.next();
         }
      }
      return temp;
   }


   /**
    * Get the firstFromFsaObjects attribute of the FSAInterface object
    *
    * @param property  No description provided
    * @return          The firstFromFsaObjects value
    */
   public FSAObject getFirstFromFsaObjects (String property)
   {
      FSAObject temp = null;
      if (fsaObjects != null)
      {
         Iterator iter = iteratorOfFsaObjects (property);

         if (iter.hasNext())
         {
            temp = (FSAObject) iter.next();
         }
      }
      return temp;
   }


   /**
    * Get the jComponent attribute of the FSAInterface class
    *
    * @param object  No description provided
    * @return        The jComponent value
    */
   public static JComponent getJComponent (FSAObject object)
   {
      JComponent comp = null;
      if (object != null)
      {
         comp = object.getJComponent();
      }
      return comp;
   }

   // ######################################################################
   // ----- consistency checking stuff
   // ######################################################################

   /**
    * UMLAttr: 'consistent : Boolean'.
    */
   private boolean consistent = true;


   /**
    * UMLMethod: '# isConsistent (): Boolean'.
    *
    * @return   The consistent value
    */
   public boolean isConsistent()
   {
      if (consistent)
      {
         UnparseManager.get().isConsistent (getLogic());
      }
      return this.consistent;
   }


   /**
    * UMLMethod: '# setConsistent (newConsistent: Boolean): Void'.
    *
    * @param newConsistent  The new consistent value
    */
   protected void setConsistent (boolean newConsistent)
   {
      if (this.consistent != newConsistent)
      {
         this.consistent = newConsistent;
      } // if
   }


   /**
    * <pre>
    *               n      dependsOn       n
    * FSAInterface -------------------------- FSAInterface
    *               dependent      dependsOn
    * </pre>
    */
   private FHashSet dependent;


   /**
    * UMLMethod: '+ hasInDependent (value: FSAInterface): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInDependent (FSAInterface value)
   {
      return  ( (this.dependent != null) &&
          (value != null) &&
         this.dependent.contains (value));
   }


   /**
    * UMLMethod: '+ iteratorOfDependent (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfDependent()
   {
      return  ( (this.dependent == null)
         ? FEmptyIterator.get()
         : new ReadOnlyIterator (this.dependent.iterator()));
   }


   /**
    * UMLMethod: '+ sizeOfDependent (): Integer'.
    *
    * @return   No description provided
    */
   public int sizeOfDependent()
   {
      return  ( (this.dependent == null)
         ? 0
         : this.dependent.size());
   }


   /**
    * UMLMethod: '+ addToDependent (value: FSAInterface): Boolean'.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   protected boolean addToDependent (FSAInterface value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.dependent == null)
         {
            this.dependent = new FHashSet(); // or FTreeSet () or FLinkedList ()
         }
         changed = this.dependent.add (value);
         if (changed)
         {
            value.addToDependsOn (this);
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeFromDependent (value: FSAInterface): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   protected boolean removeFromDependent (FSAInterface value)
   {
      boolean changed = false;
      if ( (this.dependent != null) &&  (value != null))
      {
         changed = this.dependent.remove (value);
         if (changed)
         {
            value.removeFromDependsOn (this);
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeAllFromDependent (): Void'.
    */
   protected void removeAllFromDependent()
   {
      FSAInterface tmpValue;
      Iterator iter = this.iteratorOfDependent();
      while (iter.hasNext())
      {
         tmpValue = (FSAInterface) iter.next();
         this.removeFromDependent (tmpValue);
      }
   }


   /**
    * <pre>
    *               n      dependsOn       n
    * FSAInterface -------------------------- FSAInterface
    *               dependsOn      dependent
    * </pre>
    */
   private FHashSet dependsOn;


   /**
    * UMLMethod: '+ hasInDependsOn (value: FSAInterface): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInDependsOn (FSAInterface value)
   {
      return  ( (this.dependsOn != null) &&
          (value != null) &&
         this.dependsOn.contains (value));
   }


   /**
    * UMLMethod: '+ iteratorOfDependsOn (): Iterator'.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfDependsOn()
   {
      return  ( (this.dependsOn == null)
         ? FEmptyIterator.get()
         : new ReadOnlyIterator (this.dependsOn.iterator()));
   }


   /**
    * UMLMethod: '+ sizeOfDependsOn (): Integer'.
    *
    * @return   No description provided
    */
   public int sizeOfDependsOn()
   {
      return  ( (this.dependsOn == null)
         ? 0
         : this.dependsOn.size());
   }


   /**
    * UMLMethod: '+ addToDependsOn (value: FSAInterface): Boolean'.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   protected boolean addToDependsOn (FSAInterface value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.dependsOn == null)
         {
            this.dependsOn = new FHashSet(); // or FTreeSet () or FLinkedList ()
         }
         changed = this.dependsOn.add (value);
         if (changed)
         {
            value.addToDependent (this);
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeFromDependsOn (value: FSAInterface): Boolean'.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   protected boolean removeFromDependsOn (FSAInterface value)
   {
      boolean changed = false;
      if ( (this.dependsOn != null) &&  (value != null))
      {
         changed = this.dependsOn.remove (value);
         if (changed)
         {
            value.removeFromDependent (this);
         }
      }
      return changed;
   }


   /**
    * UMLMethod: '+ removeAllFromDependsOn (): Void'.
    */
   protected void removeAllFromDependsOn()
   {
      FSAInterface tmpValue;
      Iterator iter = this.iteratorOfDependsOn();
      while (iter.hasNext())
      {
         tmpValue = (FSAInterface) iter.next();
         this.removeFromDependsOn (tmpValue);
      }
   }


   // ######################################################################
   // ----- some special Iterators for FSAs
   // ######################################################################
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.18 $
    */
   private static class FsaPropertyIterator implements Iterator
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private String property = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Iterator iterator = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Object element = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private byte moreElements = -1;


      /**
       * Constructor for class FsaPropertyIterator
       *
       * @param iterator  No description provided
       * @param property  No description provided
       */
      FsaPropertyIterator (Iterator iterator, String property)
      {
         this.iterator = iterator;
         this.property = property;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public boolean hasNext()
      {
         if (moreElements == -1)
         {
            fetch();
         }

         return moreElements == 1;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public Object next()
      {
         if (moreElements == -1)
         {
            fetch();
         }

         if (moreElements == 1)
         {
            moreElements = -1;
            return element;
         }
         else
         {
            throw new NoSuchElementException();
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      public void remove()
      {
         if (moreElements == 1)
         {
            iterator.remove();
         }
         else
         {
            throw new IllegalStateException();
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private void fetch()
      {
         while (iterator.hasNext())
         {
            Object object = iterator.next();
            if (object instanceof FSAObject)
            {
               FSAObject fsa = (FSAObject) object;
               String fsaProp = fsa.getPropertyName();

               if ( (this.property == null && fsaProp == null) ||  (this.property != null && this.property.equals (fsaProp)))
               {
                  element = fsa;
                  moreElements = 1;
                  return;
               }
            }
         }
         moreElements = 0;
         element = null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.18 $
    */
   private static class FsaParentIterator implements Iterator
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private FSAObject parent = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Iterator iterator = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Object element = null;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private byte moreElements = -1;


      /**
       * Constructor for class FsaParentIterator
       *
       * @param iterator  No description provided
       * @param parent    No description provided
       */
      FsaParentIterator (Iterator iterator, FSAObject parent)
      {
         this.iterator = iterator;
         this.parent = parent;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public boolean hasNext()
      {
         if (moreElements == -1)
         {
            fetch();
         }

         return moreElements == 1;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public Object next()
      {
         if (moreElements == -1)
         {
            fetch();
         }

         if (moreElements == 1)
         {
            moreElements = -1;
            return element;
         }
         else
         {
            throw new NoSuchElementException();
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      public void remove()
      {
         if (moreElements == 1)
         {
            iterator.remove();
         }
         else
         {
            throw new IllegalStateException();
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private void fetch()
      {
         while (iterator.hasNext())
         {
            Object object = iterator.next();
            if (object instanceof FSAObject)
            {
               FSAObject fsa = (FSAObject) object;
               FSAObject parent = fsa.getParent();
               if (this.parent == parent)
               {
                  element = fsa;
                  moreElements = 1;
                  return;
               }
            }
         }
         moreElements = 0;
         element = null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.18 $
    */
   private static class ReadOnlyIterator implements Iterator
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private final Iterator iterator;


      /**
       * Constructor for class ReadOnlyIterator
       *
       * @param iter  No description provided
       */
      public ReadOnlyIterator (Iterator iter)
      {
         this.iterator = iter;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public boolean hasNext()
      {
         return iterator.hasNext();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public Object next()
      {
         return iterator.next();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      public void remove()
      {
         throw new UnsupportedOperationException ("Only Read-Operations allowed!");
      }
   }
}

/*
 * $Log: FSAInterface.java,v $
 * Revision 1.18  2004/11/03 10:18:01  lowende
 * Javadoc warnings removed.
 *
 */
