/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;
import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * set fsaComponent.attrName if UMLUnparseInterface has changed
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14 $
 */
public class LogicToFsaUpdatePCL
    implements PropertyChangeListener
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LogicToFsaUpdatePCL.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private AbstractUpdater updater;


   /**
    * Get the value of updater.
    *
    * @return   Value of updater.
    */
   public AbstractUpdater getUpdater()
   {
      return this.updater;
   }


   /**
    * Set the value of updater.
    *
    * @param updater  Value to assign to updater.
    */
   public synchronized void setUpdater (AbstractUpdater updater)
   {
      if (this.updater != updater)
      {
         this.updater = updater;
      }
   }


   /**
    * UMLAttribute : 'fsaObject : FSAObject '
    */
   private FSAObject fsaObject;


   /**
    * Get the value of fsaObject.
    *
    * @return   Value of fsaObject.
    */
   public FSAObject getFsaObject()
   {
      return this.fsaObject;
   }


   /**
    * Set the value of fsaObject.
    *
    * @param fsaObject  Value to assign to fsaObject.
    */
   public synchronized void setFsaObject (FSAObject fsaObject)
   {
      if (this.fsaObject != fsaObject)
      {
         this.fsaObject = fsaObject;
         fsaObjectClass = null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Class fsaObjectClass = null;


   /**
    * Get the fsaObjectClass attribute of the LogicToFsaUpdatePCL object
    *
    * @return   The fsaObjectClass value
    */
   private Class getFsaObjectClass()
   {
      if (fsaObjectClass == null)
      {
         fsaObjectClass = getFsaObject().getClass();
      }

      return fsaObjectClass;
   }


   /**
    * UMLAttribute : 'attrName : String '
    */
   private String attrName;


   /**
    * Get the value of attrName.
    *
    * @return   Value of attrName.
    */
   public String getAttrName()
   {
      return this.attrName;
   }


   /**
    * Set the value of attrName.
    *
    * @param attrName  Value to assign to attrName.
    */
   public synchronized void setAttrName (String attrName)
   {
      if ( (this.attrName == null && attrName != null) ||
          (this.attrName != null && !this.attrName.equals (attrName)))
      {
         this.attrName = attrName;
      }
   }


   /**
    * Default Constructor
    *
    * @param updater    No description provided
    * @param attrName   No description provided
    * @param component  No description provided
    */
   public LogicToFsaUpdatePCL (AbstractUpdater updater, String attrName, FSAObject component)
   {
      setUpdater (updater);
      setFsaObject (component);
      setAttrName (attrName);
   }


   /**
    * Constructor for class LogicToFsaUpdatePCL
    *
    * @param attrName   No description provided
    * @param component  No description provided
    */
   public LogicToFsaUpdatePCL (String attrName, FSAObject component)
   {
      this (null, attrName, component);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void propertyChange (PropertyChangeEvent event)
   {
      FSAObject fsaObject;
      Class clazz;
      String attrName;
      Object[] args;
      synchronized (this)
      {
         args = new Object[]
            {
             (updater != null ?
            updater.getTranslator().translateLogicToFsa (event.getNewValue()) :
            event.getNewValue())
            };
         fsaObject = getFsaObject();
         clazz = getFsaObjectClass();
         attrName = getAttrName();
      }

      Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (attrName,
         clazz);
      Method setMethod = methods[1];
      try
      {
         if (setMethod == null)
         {
            JComponent comp = fsaObject.getJComponent();
            methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (attrName,
               comp.getClass());

            setMethod = methods[1];
            setMethod.invoke (comp, args);
         }
         else
         {
            setMethod.invoke (fsaObject, args);
         }
      }
      catch (Exception exception)
      {
         if (exception instanceof InvocationTargetException)
         {
            InvocationTargetException ite = (InvocationTargetException) exception;
            log.error (ite.getTargetException().getMessage());
            ite.getTargetException().printStackTrace();
         }
         else
         {
            throw new RuntimeException (this + ".propertyChange : " + exception);
         }
      }
   }
}

/*
 * $Log: LogicToFsaUpdatePCL.java,v $
 * Revision 1.14  2004/11/03 10:18:02  lowende
 * Javadoc warnings removed.
 *
 */
