/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.metamodel.FIncrement;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLType;


/**
 * Listen for Changes to properties of type UMLType and to the name of the
 * current UMLType
 *
 *
 * @author    $Author: joerg $
 * @version   $Revision: 1.11.2.1 $
 */
public class TypeUpdater extends LogicToFsaUpdater implements PropertyChangeListener
{
   /**
    * Default Constructor
    *
    *
    * @param incr                No description provided
    * @param umlAttr             No description provided
    * @param fsaAttr             No description provided
    */
   public TypeUpdater (LogicUnparseInterface incr, String umlAttr, String fsaAttr)
   {
      super();
      setLogicObject (incr);
      setLogicAttrName (umlAttr);
      setFsaAttrName (fsaAttr);
   }


   /**
    * Sets the logicObject attribute of the TypeUpdater object
    *
    *
    * @param object             The new logicObject value
    * @return        No description provided
    */
   public boolean setLogicObject (Object object)
   {
      if (object == null || object instanceof FIncrement)
      {
         return super.setLogicObject (object);
      }
      throw new IllegalArgumentException ("Object must be of instance UMLIncrement");
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null || getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (this);
         }
          ((UMLIncrement) getLogicObject()).addPropertyChangeListener (getLogicAttrName(),
            (PropertyChangeListener) getLogicListener());

         Object type = getLogicValue();
         if (type != null && type instanceof UMLType)
         {
             ((UMLType) type).addPropertyChangeListener ("name",
               (PropertyChangeListener) getLogicListener());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null || getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
             ((UMLIncrement) getLogicObject()).removePropertyChangeListener (getLogicAttrName(),
               (PropertyChangeListener) getLogicListener());

            // HACK: the following line created a ClassCastException:
            // java.lang.String
            // UMLType type = (UMLType) getLogicValue ();
            Object type = getLogicValue();
            if (type != null && type instanceof UMLType)
            {
                ((UMLType) type).removePropertyChangeListener ("name",
                  (PropertyChangeListener) getLogicListener());
            }
         }
      }
   }


   /**
    * Get the logicValue attribute of the TypeUpdater object
    *
    *
    * @return   The logicValue value
    */
   public Object getLogicValue()
   {
      Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (getLogicAttrName(),
         getLogicObject());

      Method getMethod = methods[0];

      Object result;
      try
      {
         result = getMethod.invoke (getLogicObject(), null);
      }
      catch (Exception e)
      {
         throw new RuntimeException ("Exception in " + this + ".getLogicValue: " + e.getMessage());
      }
      return result;
   }


   /**
    * Sets the fsaValue attribute of the TypeUpdater object
    *
    *
    * @param value             The new fsaValue value
    */
   public void setFsaValue (Object value)
   {
      FSAObject fsaObject = getFsaObject();
      String attrName = getFsaAttrName();

      Method[] methods = FSADerivePropertyMethodsCache.get()
         .getPropertyMethods (attrName, fsaObject);

      Method setMethod = methods[1];
      if (setMethod != null)
      {
         try
         {
            setMethod.invoke (fsaObject, new Object[]
               {value});
         }
         catch (Exception e)
         {
            throw new RuntimeException ("Exception in " + this + ".setFsaValue: " + e.getMessage());
         }
      }
      else
      {
         JComponent comp = fsaObject.getJComponent();
         methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (attrName, comp);

         setMethod = methods[1];

         try
         {
            setMethod.invoke (comp, new Object[]
               {value});
         }
         catch (Exception e)
         {
            throw new RuntimeException ("Exception in " + this + ".setFsaValue: " + e.getMessage());
         }
      }
   }

   // ----------------------------- Listener Implementation
   // ------------------------

   /**
    * Listens for changes to the Document and updates the contentsChanged
    * property
    *
    *
    * @param e             No description provided
    */
   public void propertyChange (PropertyChangeEvent e)
   {
      if ("name".equals (e.getPropertyName()) && e.getSource() instanceof UMLType)
      {
         setFsaValue (null);
         setFsaValue (e.getSource());
      }
      else if (e.getSource() == getLogicObject())
      {
         UMLType oldType = (UMLType) e.getOldValue();
         UMLType newType = (UMLType) e.getNewValue();

         if (oldType != null)
         {
            oldType.removePropertyChangeListener ("name", this);
         }
         if (newType != null)
         {
            newType.addPropertyChangeListener ("name", this);
         }
      }
   }
}

/*
 * $Log: TypeUpdater.java,v $
 * Revision 1.11.2.1  2006/05/09 15:09:52  joerg
 * improved handling of free qualified and bound qualified assocs, just highlight problem still occures, which is a problem of the arrowhead in general
 *
 */
