/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.*;

import de.upb.tools.pcs.CollectionChangeEvent;


/**
 * Toggle visibility of FSAObject depending on logic property value
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class VisibilityUpdater extends LogicToFsaUpdater
{
   /**
    * Default Constructor
    */
   public VisibilityUpdater()
   {
      super();
      super.setFsaAttrName ("visible");
   }


   /**
    * Constructor for class VisibilityUpdater
    *
    * @param incr  No description provided
    * @param attr  No description provided
    */
   public VisibilityUpdater (Object incr, String attr)
   {
      this();
      setLogicObject (incr);
      setLogicAttrName (attr);
   }


   /**
    * Sets the fsaAttrName attribute of the VisibilityUpdater object
    *
    * @param name  The new fsaAttrName value
    * @return      No description provided
    */
   public boolean setFsaAttrName (String name)
   {
      if ("visible".equals (name))
      {
         return false;
      }
      throw new UnsupportedOperationException ("Cannot change VisibilityUpdater.fsaAttrName from \"visible\"");
   }


   /**
    * translate to Boolean values:</p> Boolean -> Boolean</p> String -> !equals("")? Number
    * -> >0? others -> toString() ...
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateLogicToFsa (Object data)
   {
      if (data == null)
      {
         return Boolean.FALSE;
      }
      if (data instanceof Boolean)
      {
         return data;
      }
      else if (data instanceof Long)
      {
         return  (
             ((Long) data).longValue() > 0 ? Boolean.TRUE : Boolean.FALSE);
      }
      else if (data instanceof Integer)
      {
         return  (
             ((Integer) data).intValue() > 0 ? Boolean.TRUE : Boolean.FALSE);
      }
      else if (data instanceof Short)
      {
         return  (
             ((Short) data).shortValue() > 0 ? Boolean.TRUE : Boolean.FALSE);
      }
      else if (data instanceof Number)
      {
         return  (
             ((Number) data).byteValue() > 0 ? Boolean.TRUE : Boolean.FALSE);
      }
      else if (data instanceof Collection)
      {
         return  (
             ((Collection) data).size() > 0 ? Boolean.TRUE : Boolean.FALSE);
      }
      else if (data instanceof Map)
      {
         return  ( ((Map) data).size() > 0 ? Boolean.TRUE : Boolean.FALSE);
      }
      else if (data instanceof Iterator)
      {
         return  ( ((Iterator) data).hasNext() ? Boolean.TRUE : Boolean.FALSE);
      }
      String str = data.toString();
      if (str == null || str.trim().length() == 0)
      {
         return Boolean.FALSE;
      }
      return Boolean.TRUE;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null
         || getLogicAttrName() == null
         || getFsaObject() == null
         || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (
               new LogicToFsaUpdatePCL (this, getFsaAttrName(), getFsaObject())
               {
                  public void propertyChange (PropertyChangeEvent event)
                  {
                     if ( (event.getNewValue() == null) &&  (event instanceof CollectionChangeEvent))
                     {
                        CollectionChangeEvent cevent = (CollectionChangeEvent) event;
                        Object col = cevent.getCollection();
                        if ( (col instanceof Collection) &&  ( ((Collection) col).size() > 0))
                        {
                           return;
                        }
                     }
                     super.propertyChange (event);
                  }
               });
         }
         ListenerHelper.get().addPropertyChangeListener (
            getLogicObject(),
            getLogicAttrName(),
            (PropertyChangeListener) getLogicListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null
         || getLogicAttrName() == null
         || getFsaObject() == null
         || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
            ListenerHelper.get().removePropertyChangeListener (
               getLogicObject(),
               getLogicAttrName(),
               (PropertyChangeListener) getLogicListener());
         }
      }
   }
}

/*
 * $Log: VisibilityUpdater.java,v $
 * Revision 1.16  2004/11/03 10:18:03  lowende
 * Javadoc warnings removed.
 *
 */
