/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * This class provides the generic architecture of the activity panels. <h2>Associations</h2>
 * <pre>
 *                     0..1           panels            n
 * EditActivityDialog ------------------------------------ ActivityPanel
 *                     activityDialog      activityPanels
 * </pre>
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.14 $
 */
public abstract class ActivityPanel extends JPanel
{
   /**
    * Returns the name of this panel.
    *
    * @return   The name value
    */
   public abstract String getName();


   /**
    * Returns true, if panel is responsible for the umlIncrement.
    *
    * @return   The responsible value
    */
   public abstract boolean isResponsible();


   /**
    * Catch all info from panel and change an existing or add a new ASGElement.
    *
    * @return   No description provided
    */
   public abstract UMLActivity parse();


   /**
    * Catch all info from existing ASGElement and fill all elements from panel.
    */
   public abstract void unparse();


   /**
    * Add a new or change the existing ASGElement.
    *
    * @return   No description provided
    */
   public UMLActivity okPressed()
   {
      final UMLActivity umlActivity = parse();
      UMLProject.get().refreshDisplay();
      return umlActivity;
   } // okPressed


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      return getName();
   } // toString


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement asgElement;


   /**
    * Sets the umlIncrement attribute of the ActivityPanel object
    *
    * @param asgElement  The new asgElement value
    */
   public void setAsgElement (ASGElement asgElement)
   {
      this.asgElement = asgElement;
   } // setAsgElement


   /**
    * Get the asgElement attribute of the ActivityPanel object
    *
    * @return   The asgElement value
    */
   public ASGElement getAsgElement()
   {
      return asgElement;
   } // getUmlIncrement


   /**
    * <pre>
    *                     0..1           panels            n
    * EditActivityDialog ------------------------------------ ActivityPanel
    *                     activityDialog      activityPanels
    * </pre>
    */
   public EditActivityDialog activityDialog;


   /**
    * Sets the activityDialog attribute of the ActivityPanel object
    *
    * @param elem  The new activityDialog value
    */
   public void setActivityDialog (EditActivityDialog elem)
   {
      if (this.activityDialog != elem)
      {
         // newPartner
         if (this.activityDialog != null)
         {
            // inform old partner
            EditActivityDialog oldActivityDialog = this.activityDialog;
            this.activityDialog = null;

            oldActivityDialog.removeFromActivityPanels (this);
         }

         this.activityDialog = elem;
         if (elem != null)
         {
            // inform new partner
            elem.addToActivityPanels (this);
         }
      }
   } // setActivityDialog


   /**
    * Get the activityDialog attribute of the ActivityPanel object
    *
    * @return   The activityDialog value
    */
   public EditActivityDialog getActivityDialog()
   {
      return this.activityDialog;
   } // getActivityDialog

}

/*
 * $Log: ActivityPanel.java,v $
 * Revision 1.14  2005/01/27 15:44:46  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
