/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;


/**
 * This FocusListener is to focus the TextField with the name of the class, the method or the
 * attribute in the respective class; implemented for the users convinience.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.7 $
 */
public class CMAFocusListener implements FocusListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField text;


   /**
    * Creates a new CMAFocusListener object. The parameter is the TextField you want to focus.
    *
    * @param text  The TextField to be focused.
    */
   public CMAFocusListener (PETextField text)
   {
      this.text = text;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void focusGained (FocusEvent e)
   {
      text.requestFocus();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void focusLost (FocusEvent e)
   {

   }
}

/*
 * $Log: CMAFocusListener.java,v $
 * Revision 1.7  2004/10/20 17:49:52  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
