/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.1.2.2 $
 */
public class ComboDialog extends JDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int NO_OTHER = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int USR_DEF = 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static String defLabel = "Please choose an item:";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static String defTitle = "Chooser";

   /**
    * ok-button was pressed
    */
   public static int OK_PRESSED = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static int CANCEL_PRESSED = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static int OTHER_PRESSED = 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Object selItem = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox itemBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton okButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton cancelButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton otherButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JLabel textLabel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int pressed = 0;

   /**
    * center panel
    */
   private JPanel center;

   /**
    * error label (when no filelist is given)
    */
   private JLabel errorLabel;


   /**
    * Constructor for class FileComboDialog
    *
    * @param f         No description provided
    * @param itemlist  No description provided
    */
   public ComboDialog (JFrame f, Object[] itemlist)
   {
      super (f);
      init (defLabel, defTitle, itemlist, NO_OTHER);
   }


   /**
    * Constructor for class FileComboDialog
    *
    * @param f         No description provided
    * @param label     No description provided
    * @param title     No description provided
    * @param itemlist  No description provided
    */
   public ComboDialog (JFrame f, String label, String title, Object[] itemlist)
   {
      super (f);
      init (label, title, itemlist, NO_OTHER);
   }


   /**
    * Constructor for class FileComboDialog
    *
    * @param f         No description provided
    * @param label     No description provided
    * @param title     No description provided
    * @param other     No description provided
    * @param itemlist  No description provided
    */
   public ComboDialog (JFrame f, String label, String title, Object[] itemlist,
                       int other)
   {
      super (f);
      init (label, title, itemlist, other);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param label     No description provided
    * @param title     No description provided
    * @param other     No description provided
    * @param itemlist  No description provided
    */
   private void init (String label, String title, Object[] itemlist, int other)
   {
      getContentPane().setLayout (new BorderLayout());
      setTitle (title);
      setSize (600, 125);
      Dimension mydim = Toolkit.getDefaultToolkit().getScreenSize();
      setLocation ((int)  ( (mydim.getWidth() - this.getWidth()) / 2), (int)  ( (mydim.getHeight() -
         this.getHeight())) / 2);
      setModal (true);
      setResizable (false);

      JPanel north = new JPanel (new BorderLayout());
      textLabel = new JLabel (label);
      north.add (new JLabel (" "), BorderLayout.NORTH);
      north.add (new JLabel ("  "), BorderLayout.WEST);
      north.add (textLabel, BorderLayout.CENTER);

      center = new JPanel (new BorderLayout());
      center.setBackground (Color.white);

      JPanel south = new JPanel (new FlowLayout (FlowLayout.RIGHT));

      okButton = new JButton ("OK");
      okButton.addActionListener (new okListener());
      south.add (okButton);

      itemBox = new JComboBox (itemlist);
      itemBox.setEditable (false);
      itemBox.setBackground (Color.white);
      itemBox.setRenderer (new MyCellRenderer (itemBox));

      setItemList (itemlist);

      if (other > 0)
      {
         otherButton = new JButton ("Other...");
         otherButton.addActionListener (new otherListener());
         south.add (otherButton);
      }

      cancelButton = new JButton ("Cancel");
      cancelButton.addActionListener (new cancelListener());
      south.add (cancelButton);

      this.getContentPane().add (north, BorderLayout.NORTH);
      this.getContentPane().add (center, BorderLayout.CENTER);
      this.getContentPane().add (south, BorderLayout.SOUTH);
   }


   /**
    * Sets the fileList attribute of the FileComboDialog object
    *
    * @param itemlist  The new itemList value
    */
   public void setItemList (Object[] itemlist)
   {
      Object selectedFile = null;
      if (itemBox != null)
      {
         selectedFile = itemBox.getSelectedItem();
         center.remove (itemBox);
      }
      if (errorLabel != null)
      {
         center.remove (errorLabel);
      }

      itemBox.removeAllItems();
      if (itemlist != null && itemlist.length > 0)
      {
         for (int i = 0; i < itemlist.length; i++)
         {
            itemBox.addItem (itemlist[i]);
         }

         if (itemBox.getItemCount() != 0)
         {
            itemBox.setSelectedIndex (0);
         }

         if (selectedFile != null)
         {
            itemBox.setSelectedItem (selectedFile);
         }
         center.add (itemBox, BorderLayout.CENTER);

         okButton.setVisible (true);
      }
      else
      {
         errorLabel = new JLabel ("  ERROR: No matching item found!");
         center.add (errorLabel, BorderLayout.CENTER);

         okButton.setVisible (false);
      }
   }


   /**
    * Get the selectedFile attribute of the FileComboDialog object
    *
    * @return   The selectedFile value
    */
   public Object getSelectedItem()
   {
      return selItem;
   }


   /**
    * Get the renderer attribute of the ComboDialog object
    *
    * @return   The renderer value
    */
   public ListCellRenderer getRenderer()
   {
      return itemBox.getRenderer();
   }


   /**
    * Sets the renderer attribute of the ComboDialog object
    *
    * @param renderer  The new renderer value
    */
   public void setRenderer (ListCellRenderer renderer)
   {
      itemBox.setRenderer (renderer);
   }


   /**
    * Get the pressed attribute of the FileComboDialog object
    *
    * @return   The pressed value
    */
   public int getPressed()
   {
      return pressed;
   }


   /**
    * Sets the pressed attribute of the FileComboDialog object
    *
    * @param value  The new pressed value
    */
   void setPressed (int value)
   {
      pressed = value;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.1.2.2 $
    */
   private class okListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         setPressed (OK_PRESSED);
         selItem = itemBox.getSelectedItem();
         hide();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.1.2.2 $
    */
   private class cancelListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         selItem = null;
         setPressed (CANCEL_PRESSED);
         hide();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.1.2.2 $
    */
   private class otherListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         setPressed (OTHER_PRESSED);
         hide();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.1.2.2 $
    */
   private class MyCellRenderer extends DefaultListCellRenderer
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private JComboBox parent;

      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private final static int maxTextLength = 70;


      /**
       * Constructor for class MyCellRenderer
       *
       * @param parent  No description provided
       */
      public MyCellRenderer (JComboBox parent)
      {
         this.parent = parent;
      }


      /**
       * Get the listCellRendererComponent attribute of the MyCellRenderer object
       *
       * @param list          No description provided
       * @param value         No description provided
       * @param index         No description provided
       * @param isSelected    No description provided
       * @param cellHasFocus  No description provided
       * @return              The listCellRendererComponent value
       */
      public Component getListCellRendererComponent (JList list, Object value, int index, boolean isSelected,
                                                     boolean cellHasFocus)
      {
         JLabel label = (JLabel) super.getListCellRendererComponent (list, value, index, isSelected, cellHasFocus);
         String itemText = label.getText();

         if (itemText.length() > maxTextLength)
         {
            if (parent != null && cellHasFocus || isSelected)
            {
               parent.setToolTipText (itemText);
            }
            else
            {
               parent.setToolTipText ("");
            }

            itemText = "..." + itemText.substring (itemText.length() - maxTextLength);
            label.setText (itemText);
         }

         return label;
      }

   }

}

/*
 * $Log: ComboDialog.java,v $
 * Revision 1.1.2.2  2005/07/28 12:12:34  creckord
 * Replaced hardcoded Xerces reference with proper JAXP factory call
 *
 */
