/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.sdm.FComplexState;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.58.2.2 $
 */
public class PEActTransition extends PropertyEditor
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GuardNone = "None";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GuardSuccess = "Success";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GuardFailure = "Failure";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GuardEachTime = "Each Time";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GuardTermination = "End (for all)";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GuardElse = "Else";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GuardBooleanExpression = "Boolean Expression";

   public final static String GuardException = "Exception";
   // don't change the order
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String[] Guards =
      {GuardNone, GuardSuccess, GuardFailure, GuardEachTime, GuardTermination, GuardElse, GuardBooleanExpression, GuardException};

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement second;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PERolePanel rolePanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PECombo guardType;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField expression;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField eventTrigger;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField action;


   /**
    * Constructor for class PEActTransition
    *
    * @param frame  No description provided
    */
   public PEActTransition (JFrame frame)
   {
      super (frame);
      setTitle ("Transition Editor");
      initPE();
   } // constructor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      rolePanel = new PERolePanel();
      guardType = new PECombo (this, "Guard Type");
      guardType.addItemListener (new PEGuardListener (this));
      guardType.setStatus ("Select the type of this guard");
      expression = new PETextField (this, "Boolean Expression / Exception");
      expression.setStatus ("Enter a boolean expression or exception");
      eventTrigger = new PETextField (this, "Event trigger");
      eventTrigger.setStatus ("Enter event trigger");
      action = new PETextField (this, "Action");
      action.setStatus ("Enter the action");

      PEColumn column = new PEColumn (this);
      column.add (rolePanel);
      column.add (guardType);
      column.add (expression);
      UMLActivityDiagram curActDiag = (UMLActivityDiagram) UMLProject.get().getCurrentDiagram();

      if (curActDiag.getStartActivity() != null && curActDiag.getStartActivity().getRevStartOfStateChart() != null)
      {
         column.add (eventTrigger);
         column.add (action);
      }

      panel.add (column);
   } // additionalProperties


   /**
    * Sets the increment attribute of the PEActTransition object
    *
    * @param asgElement  The new increment value
    * @param addIncr     The new increment value
    */
   public void setIncrement (ASGElement asgElement, ASGElement addIncr)
   {
      second = addIncr;
      super.setIncrement (asgElement);
   } // setAsgElement


   /**
    * Get the propertyName attribute of the PEActTransition object
    *
    * @return   The propertyName value
    */
   public String getPropertyName()
   {
      return "ActivityTransition";
   } // getPropertyName


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param sourceActivity  No description provided
    * @param targetActivity  No description provided
    * @param diag            No description provided
    */
   private void fillRolePanel (UMLActivity sourceActivity, UMLActivity targetActivity, UMLDiagram diag)
   {
      boolean sourceActivityAdded = false;
      boolean targetActivityAdded = false;
      PEActListEntry newEntry;

      Iterator itemsIter = diag.iteratorOfElements();
      while (itemsIter.hasNext())
      {
         ASGElement tmpItem = (ASGElement) itemsIter.next();
         if (tmpItem instanceof UMLActivity)
         {
            UMLActivity tmpActivity = (UMLActivity) tmpItem;
            newEntry = new PEActListEntry (tmpActivity);

            if (! (tmpActivity instanceof UMLStartActivity))
            {
               rolePanel.addItemToRightComboBox (newEntry);
            }
            if (! (tmpActivity instanceof UMLStopActivity))
            {
               rolePanel.addItemToLeftComboBox (newEntry);
            }
            if (tmpActivity == sourceActivity)
            {
               rolePanel.setLeftComboSelectedItem (newEntry);
               sourceActivityAdded = true;
            }
            if (tmpActivity == targetActivity)
            {
               rolePanel.setRightComboSelectedItem (newEntry);
               targetActivityAdded = true;
            }
         }
      }

      if (!sourceActivityAdded && ! (sourceActivity instanceof UMLStopActivity))
      {
         newEntry = new PEActListEntry (sourceActivity);
         rolePanel.addItemToLeftComboBox (newEntry);
         rolePanel.setLeftComboSelectedItem (newEntry);
      }
      if (!targetActivityAdded &&
         ! ( (targetActivity instanceof UMLStartActivity) &&
          ( ((UMLStartActivity) targetActivity).getHistoryKind() == FComplexState.HISTORY_NONE)))
      {
         newEntry = new PEActListEntry (targetActivity);
         rolePanel.addItemToRightComboBox (newEntry);
         rolePanel.setRightComboSelectedItem (newEntry);
      }

   } // fillRolePanel


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void unparse()
   {
      if (getIncrement() != null)
      {
         // fill guard list
         for (int i = 0; i < Guards.length; i++)
         {
            guardType.add (Guards[i]);
         }
         guardType.setSelectedIndex (0);

         expression.setReadOnly (true);

         ASGElement asgElement = getIncrement();
         if (asgElement instanceof UMLTransition)
         {
            UMLTransition transition = (UMLTransition) asgElement;

            // fill the combo boxes of the role panel
            fillRolePanel (transition.getRevExit(), transition.getRevEntry(), transition.getCurrentActiveDiagram());

            // init the rest
            UMLTransitionGuard guard = transition.getGuard();
            if (guard != null)
            {
               guardType.setSelectedIndex (guard.getType());
               if (guard.getType() == UMLTransitionGuard.BOOL || guard.getType() == UMLTransitionGuard.EXCEPTION)
               {
                  expression.setText (guard.getBoolExpr());
               }
               // transition.doCatchUp ();
            }
            eventTrigger.setText (transition.getEvent());
            action.setText (transition.getAction());
         }
         else if ( (asgElement instanceof UMLActivity) &&  (second != null) &&  (second instanceof UMLActivity))
         {
            //fill the combo boxes of the role panel
            UMLActivity srcAct = (UMLActivity) asgElement;
            UMLActivity tgtAct = (UMLActivity) second;

            fillRolePanel (srcAct, tgtAct, srcAct.getCurrentActiveDiagram());
         }
      }
   } // unparse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      if (getIncrement() != null)
      {
         ASGElement asgElement = getIncrement();
         final int guardTypeValue = guardType.getSelectedIndex();
         if (asgElement instanceof UMLTransition)
         {
            UMLActivity sourceAct = (UMLActivity)  (rolePanel.getLeftComboSelectedItem()).getItem();
            UMLActivity targetAct = (UMLActivity)  (rolePanel.getRightComboSelectedItem()).getItem();

            UMLTransition transition = (UMLTransition) asgElement;
            UMLActivity oldSourceAct = transition.getRevExit();
            UMLActivity oldTargetAct = transition.getRevEntry();

            // update the connected activities
            if (oldSourceAct != sourceAct)
            {
               transition.setRevExit (sourceAct);
            }

            if (oldTargetAct != targetAct)
            {
               transition.setRevEntry (targetAct);
            }

            UMLTransitionGuard guard = transition.getGuard();
            if (guardTypeValue == UMLTransitionGuard.NONE)
            {
               if (guard != null)
               {
                  guard.removeYou();
                  guard = null;
               }
            }
            else
            {
               if (guard == null)
               {
                  guard = new UMLTransitionGuard();
                  transition.setGuard (guard);
               }
               guard.setType (guardTypeValue);
               if (guard.getType() == UMLTransitionGuard.BOOL || guard.getType() == UMLTransitionGuard.EXCEPTION)
               {
                  guard.setBoolExpr (expression.getText());
               }
            }
            transition.setEvent (eventTrigger.getText());
            transition.setAction (action.getText());
         }
         else if ( (asgElement instanceof UMLActivity) &&
             (second != null) &&  (second instanceof UMLActivity))
         {
            // create new Transition
            UMLTransitionGuard guard = new UMLTransitionGuard (guardTypeValue,
               null, null);

            if (guardTypeValue == UMLTransitionGuard.BOOL)
            {
               guard.setBoolExpr (expression.getText());
            }

            UMLActivity sourceAct = (UMLActivity)  (rolePanel.getLeftComboSelectedItem()).getItem();
            UMLActivity targetAct = (UMLActivity)  (rolePanel.getRightComboSelectedItem()).getItem();
            UMLTransition transition = new UMLTransition (sourceAct, targetAct, guard);

            UMLDiagram diag = (UMLDiagram) upperCommonDiagram (sourceAct, targetAct);
            transition.setEvent (eventTrigger.getText());
            transition.setAction (action.getText());
            diag.addToElements (transition);
         }
      }
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param object  No description provided
    * @return        No description provided
    */
   private Object climbUp (Object object)
   {
      if (object == null)
      {
         // if your question doesn't make sense ...
         return null;
      }

      if (object instanceof UMLStoryActivity)
      {
         // get UMLActivityDiagram
         object =  ((UMLStoryActivity) object).getFirstFromDiagrams();
      }
      else if (object instanceof UMLStartActivity)
      {
         // get UMLActivityDiagram
         object =  ((UMLStartActivity) object).getFirstFromDiagrams();
      }
      else if (object instanceof UMLStopActivity)
      {
         // get UMLActivityDiagram
         object =  ((UMLStopActivity) object).getFirstFromDiagrams();
      }
      else if (object instanceof UMLNopActivity)
      {
         // get UMLActivityDiagram
         object =  ((UMLNopActivity) object).getFirstFromDiagrams();
      }
      else if (object instanceof UMLStatementActivity)
      {
         // get UMLActivityDiagram
         object =  ((UMLStatementActivity) object).getFirstFromDiagrams();
      }
      else if (object instanceof UMLComplexState)
      {
         // get UMLActivityDiagram
         object =  ((UMLComplexState) object).getFirstFromDiagrams();
      }
      else if (object instanceof UMLActivityDiagram)
      {
         // get UMLComplexState
         object =  ((UMLActivityDiagram) object).getRevContains();
      }
      else
      {
         object = null;
      }

      return object;
   } // climbUp


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param activity  No description provided
    * @return          No description provided
    */
   private int countActivityDepth (UMLActivity activity)
   {
      int depth = 0;
      Object object = activity;
      while (object != null)
      {
         object = climbUp (object);
         depth++;
      }

      return depth;
   } // countActivityDepth


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param activity1  No description provided
    * @param activity2  No description provided
    * @return           No description provided
    */
   private Object upperCommonDiagram (UMLActivity activity1,
                                      UMLActivity activity2)
   {
      if (activity1.equals (activity2))
      {
         return climbUp (activity1);
      }
      int depth1 = countActivityDepth (activity1);

      int depth2 = countActivityDepth (activity2);

      // let activity1 be at higher level than activity2 -> swap if necessary
      if (depth1 > depth2)
      {
         UMLActivity tmpActivity = activity1;
         activity1 = activity2;
         activity2 = tmpActivity;
         int tmpDepth = depth1;
         depth1 = depth2;
         depth2 = tmpDepth;
      }

      // let activity2 climb to the same level as activity1
      Object object2 = activity2;
      while (depth1 < depth2)
      {
         object2 = climbUp (object2);
         depth2--;
      }

      // now we are at the same level, try to find a common activity
      Object object1 = activity1;
      while ( (object1 != object2))
      {
         if (object1 == null && object2 == null)
         {
            // This should not happen
            return activity1;
         }
         object1 = climbUp (object1);
         object2 = climbUp (object2);
      }

      if (object1 instanceof UMLComplexState)
      {
         // if it is a transition from/to parent
         object1 =  ((UMLComplexState) object1).getFirstFromDiagrams();
      }

      return object1;
   } // upperCommonDiagram


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void selectionChanged()
   {
      expression.setReadOnly (!guardType.getSelectedItem().equals (GuardBooleanExpression) && !guardType.getSelectedItem().equals (GuardException));
   } // selectionChanged


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.58.2.2 $
    */
   private class PEGuardListener implements ItemListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEActTransition adaptor;


      /**
       * Constructor for class PEGuardListener
       *
       * @param adapter  No description provided
       */
      PEGuardListener (PEActTransition adapter)
      {
         adaptor = adapter;
      } // constructor


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void itemStateChanged (ItemEvent e)
      {
         adaptor.selectionChanged();
      } // itemStateChanged

   } // PEGuardListener


   /**
    * Encapsulates UMLActivities only.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.58.2.2 $
    */
   private class PEActListEntry extends PEListEntry
   {
      /**
       * Constructor for class PEActListEntry
       *
       * @param activity  No description provided
       */
      public PEActListEntry (UMLActivity activity)
      {
         super (activity);
      } // constructor


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public String toString()
      {
         return  ( ((UMLActivity) this.getItem()).getText());
      } // toString

   } // PEActListEntry

}

/*
 * $Log: PEActTransition.java,v $
 * Revision 1.58.2.2  2006/06/07 09:13:30  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
