/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.30 $
 */
public class PEActivityDiagram extends PropertyEditor
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PETextField diagramName;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEComboIncr classesCombo;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEListIncr methodsList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck storyboard;


   /**
    * Constructor for class PEActivityDiagram
    *
    * @param frame  No description provided
    * @param title  No description provided
    * @param modal  No description provided
    */
   public PEActivityDiagram (JFrame frame, String title, boolean modal)
   {
      super (frame);
      try
      {
         pack();
         this.setTitle ("Activity Diagram Editor");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      initPE();
   }


   /**
    * Constructor for class PEActivityDiagram
    *
    * @param frame  No description provided
    */
   public PEActivityDiagram (JFrame frame)
   {
      this (frame, "", false);
   }


   /**
    * Constructor for class PEActivityDiagram
    *
    * @param frame  No description provided
    * @param modal  No description provided
    */
   public PEActivityDiagram (JFrame frame, boolean modal)
   {
      this (frame, "", modal);
   }


   /**
    * Constructor for class PEActivityDiagram
    *
    * @param frame  No description provided
    * @param title  No description provided
    */
   public PEActivityDiagram (JFrame frame, String title)
   {
      this (frame, title, false);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      diagramName = new PETextField (this, "Diagram Name");
      classesCombo = new PEComboIncr (this, "Class List");
      methodsList = new PEListIncr (this, "Method List");
      storyboard = new PECheck (this, null, "Storyboard");
      diagramName.setText (getPropertyName());
      classesCombo.setStatus ("Select the class");
      classesCombo.addItemListener (new PEActivityDiagramSelectionListener (this));
      methodsList.setStatus ("Select the associated method");

      PEColumn column = new PEColumn (this);
      column.add (diagramName);
      column.add (storyboard);
      column.add (classesCombo);
      column.add (methodsList);

      panel.add (column);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean result = true;


   /**
    * Get the result attribute of the PEActivityDiagram object
    *
    * @return   The result value
    */
   public boolean isResult()
   {
      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void unparse()
   {
      ASGElement asgElement = getIncrement();
      if (asgElement instanceof ViewDiagram)
      {
         asgElement =  ((ViewDiagram) asgElement).getOriginalDiagram();
      }

      if (asgElement instanceof UMLActivityDiagram)
      {
         // fill the type list
         UMLProject proj = UMLProject.get();
         if (proj != null)
         {
            Enumeration classes = proj.elementsOfClasses();
            if (classes != null)
            {
               ASGElement classIncr = null;
               while (classes.hasMoreElements())
               {
                  classIncr = (ASGElement) classes.nextElement();
                  classesCombo.add (classIncr);
               }
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      ASGElement asgElement = getIncrement();
      if (asgElement instanceof UMLActivityDiagram ||
          (asgElement instanceof ViewDiagram &&  ((ViewDiagram) asgElement).getOriginalDiagram() instanceof UMLActivityDiagram))
      {
         UMLDiagram activityDiagram = (UMLDiagram) asgElement;
         activityDiagram.setName (diagramName.getText());
          ((UMLActivityDiagram) activityDiagram).setIsStoryBoard (storyboard.isSelected());
         if (storyboard.isSelected())
         {
            UMLStartActivity activity = new UMLStartActivity (null);
            activity.setStoryName ("Storyboard::" + diagramName.getText());
            activityDiagram.addToElements (activity);
         }
         else if (methodsList.getSelectedIncrement() != null)
         {
            UMLMethod selectedMethod = (UMLMethod) methodsList.getSelectedIncrement();
            if (selectedMethod.getRevSpec() != null)
            {
               int result = JOptionPane.showConfirmDialog (getFrame(), "The selected method is associated to a start activity.",
                  "Confirm method",
                  JOptionPane.YES_NO_OPTION);
               if (result == JOptionPane.YES_OPTION)
               {
                  UMLStartActivity start = new UMLStartActivity (selectedMethod);
                  activityDiagram.addToElements (start);
                  this.result = true;
               }
               else
               {
                  activityDiagram.removeYou();
                  this.result = false;
               }
            }
            else
            {
               activityDiagram.addToElements (new UMLStartActivity (selectedMethod));
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel()
   {
      this.result = false;
   }


   /**
    * Get the propertyName attribute of the PEActivityDiagram object
    *
    * @return   The propertyName value
    */
   protected String getPropertyName()
   {
      return "Activity Diagram";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void selectionChanged()
   {
      UMLClass selectedClass = (UMLClass) classesCombo.getSelectedIncrement();
      if (selectedClass != null)
      {
         methodsList.removeAll();
         Iterator methodIter = selectedClass.iteratorOfMethods();
         UMLMethod method = null;
         while (methodIter.hasNext())
         {
            method = (UMLMethod) methodIter.next();
            methodsList.add (method);
         }
      }
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.30 $
 */
class PEActivityDiagramSelectionListener implements ItemListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEActivityDiagram adaptor;


   /**
    * Constructor for class PEActivityDiagramSelectionListener
    *
    * @param adapter  No description provided
    */
   PEActivityDiagramSelectionListener (PEActivityDiagram adapter)
   {
      adaptor = adapter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void itemStateChanged (ItemEvent e)
   {
      adaptor.selectionChanged();
   }
}

/*
 * $Log: PEActivityDiagram.java,v $
 * Revision 1.30  2004/11/03 10:18:03  lowende
 * Javadoc warnings removed.
 *
 */
