/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.*;


/**
 * Basetype for all property components Supports a label for a component like JTextField or
 * JTextArea
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.30.2.1 $
 */
public abstract class PEBaseComponent extends JPanel implements PEResizable
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String componentName = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String status = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Insets inset = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected BasicPropertyEditor parent = null;


   /**
    * Constructor for class PEBaseComponent
    *
    * @param editor  No description provided
    */
   public PEBaseComponent (BasicPropertyEditor editor)
   {
      super();
      setParent (editor);
      setLayout (getLayoutManager());
      addComponents();
   }


   /**
    * Constructor for class PEBaseComponent
    *
    * @param editor  No description provided
    * @param name    No description provided
    */
   public PEBaseComponent (BasicPropertyEditor editor, String name)
   {
      this (editor);
      setComponentName (name);
   }


   /**
    * Overridden method to provide a write access method for insets.
    *
    * @return   The insets value
    */
   public Insets getInsets()
   {
      if (this.inset == null)
      {
         return super.getInsets();
      }
      else
      {
         return inset;
      }
   }


   /**
    * Missing write access method in JComponent
    *
    * @param newInset  The new insets value
    */
   public void setInsets (Insets newInset)
   {
      this.inset = newInset;
   }


   /**
    * Sets the componentName attribute of the PEBaseComponent object
    *
    * @param name  The new componentName value
    */
   public void setComponentName (String name)
   {
      componentName = name;
   }


   /**
    * Get the componentName attribute of the PEBaseComponent object
    *
    * @return   The componentName value
    */
   public String getComponentName()
   {
      return componentName;
   }


   /**
    * Get the componentByName attribute of the PEBaseComponent object
    *
    * @param searchName  No description provided
    * @return            The componentByName value
    */
   public PEBaseComponent getComponentByName (String searchName)
   {
      int nmembers = getComponentCount();
      Component comp = null;
      PEBaseComponent basecomp = null;
      for (int i = 0; i < nmembers; i++)
      {
         comp = getComponent (i);
         if (comp instanceof PEBaseComponent)
         {
            basecomp = (PEBaseComponent) comp;
            if ( (basecomp.getComponentName() != null) &&  (basecomp.getComponentName().equals (searchName)))
            {
               return basecomp;
            }
            if (basecomp instanceof PEComponentGroup)
            {
               PEBaseComponent c = basecomp.getComponentByName (searchName);
               if (c != null)
               {
                  return c;
               }
            }
         }
      }
      return null;
   }


   /**
    * Constructor for class PEBaseComponent
    */
   public PEBaseComponent()
   {
      super();
   }


   /**
    * Sets the parent attribute of the PEBaseComponent object
    *
    * @param parent  The new parent value
    */
   protected void setParent (BasicPropertyEditor parent)
   {
      this.parent = parent;
   }


   /**
    * Get the layoutManager attribute of the PEBaseComponent object
    *
    * @return   The layoutManager value
    */
   protected LayoutManager getLayoutManager()
   {
      return new PEComponentLayout();
   }


   /**
    * Access method for an one to n association.
    */
   protected abstract void addComponents();


   /**
    * Sets the readOnly attribute of the PEBaseComponent object
    *
    * @param b  The new readOnly value
    */
   public abstract void setReadOnly (boolean b);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void focusGained()
   {
      parent.setStatus (getStatus());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void focusLost()
   {
      parent.setStatus ("");
   }


   /**
    * Sets the status attribute of the PEBaseComponent object
    *
    * @param status  The new status value
    */
   public void setStatus (String status)
   {
      this.status = status;
   }


   /**
    * Get the status attribute of the PEBaseComponent object
    *
    * @return   The status value
    */
   protected String getStatus()
   {
      if (status == null)
      {
         return "";
      }
      return status;
   }

   //////////////////////////////////////////////////////////////////////////
   // thsa : added some function to handle button events for
   // in subclasses introduced buttons
   // --> to be overwritten by each subclass which
   // introduces any new button

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param buttonIdentifier  No description provided
    * @param e                 No description provided
    * @return                  No description provided
    */
   public boolean buttonActionPerformed (String buttonIdentifier, ActionEvent e)
   {
      return PEButton.remainedUnbound;
   }

}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.30.2.1 $
 */
class PEComponentLayout implements LayoutManager,
   java.io.Serializable
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int height = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int listCount = 0;
   // these methods are not used for this layout

   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp)
   {
   }

   // methods to layout the DisplayClass
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container target)
   {
      Dimension dim = new Dimension (0, 0);
      Insets inset = new Insets (1, 1, 1, 1);
      Component item = null;
      listCount = 0;
      height = 0;
      int nmembers = target.getComponentCount();
      for (int i = 0; i < nmembers; i++)
      {
         item = target.getComponent (i);
         if (item instanceof JScrollPane)
         {
            listCount++;
         }
         dim.height += item.getPreferredSize().height;
         dim.width = Math.max (dim.width, item.getPreferredSize().width);
      }
      // no insets between the components
      dim.height += inset.top + inset.bottom;
      height = dim.height;
      dim.width += inset.left + inset.right;
      return dim;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container target)
   {
      return preferredLayoutSize (target);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    */
   public void layoutContainer (Container target)
   {
      Insets inset = target.getInsets();
      // determines the current size
      Dimension size = target.getSize();
      // rezize all components to the current width and
      int nmembers = target.getComponentCount();
      int y = 0;
      Component item = null;
      for (int i = 0; i < nmembers; i++)
      {
         item = target.getComponent (i);
         if (item instanceof JLabel)
         {
            item.setLocation (inset.left + 3, inset.top);
            item.setSize (size.width - inset.left - inset.right,
               item.getPreferredSize().height);
            y = inset.top + item.getPreferredSize().height;
         }
         else if (item instanceof JScrollPane)
         {

            item.setSize (size.width - inset.left - inset.right,
               item.getPreferredSize().height +  (size.height - height) / listCount);
            item.setLocation (inset.left, y);
            y += item.getSize().height;
         }
         else
         {
            item.setSize (size.width - inset.left - inset.right,
               item.getPreferredSize().height);
            item.setLocation (inset.left, y);
            y += item.getSize().height;
         }
      }
   }
}

/*
 * $Log: PEBaseComponent.java,v $
 * Revision 1.30.2.1  2005/08/23 08:24:40  lowende
 * Removed compile warnings.
 *
 */
