/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ItemListener;

import de.uni_paderborn.fujaba.basic.FontContainer;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.26 $
 */
public class PECombo extends PEHeaderComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEComboBox combo;


   /**
    * Constructor for class PECombo
    *
    * @param parent  No description provided
    * @param title   No description provided
    */
   public PECombo (BasicPropertyEditor parent, String title)
   {
      super (parent, title);
   }


   /**
    * Get the comboBox attribute of the PECombo object
    *
    * @return   The comboBox value
    */
   public PEComboBox getComboBox()
   {
      return combo;
   }


   /**
    * Sets the readOnly attribute of the PECombo object
    *
    * @param b  The new readOnly value
    */
   public void setReadOnly (boolean b)
   {
      combo.setEnabled (!b);
   }


   /**
    * Access method for an one to n association.
    */
   public void addComponents()
   {
      combo = new PEComboBox();
      add (combo);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item  No description provided
    */
   public void add (String item)
   {
      combo.add (item);
   }


   /**
    * Get the selectedIndex attribute of the PECombo object
    *
    * @return   The selectedIndex value
    */
   public int getSelectedIndex()
   {
      return combo.getSelectedIndex();
   }


   /**
    * Sets the selectedIndex attribute of the PECombo object
    *
    * @param index  The new selectedIndex value
    */
   public void setSelectedIndex (int index)
   {
      combo.setSelectedIndex (index);
   }


   /**
    * Sets the selectedString attribute of the PECombo object
    *
    * @param s  The new selectedString value
    */
   public void setSelectedString (String s)
   {
      combo.setSelectedItem (s);
   }


   /**
    * Get the selectedString attribute of the PECombo object
    *
    * @return   The selectedString value
    */
   public String getSelectedString()
   {
      return getSelectedItem();
   }


   /**
    * Get the itemCount attribute of the PECombo object
    *
    * @return   The itemCount value
    */
   public int getItemCount()
   {
      return combo.getItemCount();
   }


   /**
    * Access method for an one to n association.
    *
    * @param aListener  The object added.
    */
   public void addItemListener (ItemListener aListener)
   {
      combo.addItemListener (aListener);
   }


   /**
    * Get the selectedItem attribute of the PECombo object
    *
    * @return   The selectedItem value
    */
   public String getSelectedItem()
   {
      return (String) combo.getSelectedItem();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final int prefWidth = getFontMetrics (FontContainer.getFont (FontContainer.DEFAULT_FONT)).stringWidth ("12345678901234567890");


   /**
    * Get the preferredSize attribute of the PECombo object
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      Dimension dim = super.getPreferredSize();
      // set the default width to 20 characters
      dim.width = prefWidth;

      return dim;
   }


   /**
    * Get the horzResizable attribute of the PECombo object
    *
    * @return   The horzResizable value
    */
   public boolean isHorzResizable()
   {
      return false;
   }


   /**
    * Get the vertResizable attribute of the PECombo object
    *
    * @return   The vertResizable value
    */
   public boolean isVertResizable()
   {
      return true;
   }


   /**
    * Removes all Items from the item list
    */
   public void removeAllItems()
   {
      combo.removeAllItems();
   } // removeAllItems

}

/*
 * $Log: PECombo.java,v $
 * Revision 1.26  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
