/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.asg.ASGElement;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.25 $
 */
public class PEListIncr extends PEList
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (PEListIncr.class);


   /**
    * Constructor for class PEListIncr
    *
    * @param parent  No description provided
    * @param title   No description provided
    */
   public PEListIncr (BasicPropertyEditor parent, String title)
   { // public constructor needed temporarily, JW.

      super (parent, title);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    */
   public void add (ASGElement incr)
   {
      getList().add (incr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item  No description provided
    */
   public void add (PEItem item)
   {
      getList().add (item);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    * @param s     No description provided
    */
   public void add (ASGElement incr, String s)
   {
      PEItem item = new PEItem (incr, s);
      add (item);
   }


   /**
    * Get the itemByIndex attribute of the PEListIncr object
    *
    * @param index  No description provided
    * @return       The itemByIndex value
    */
   public PEItem getItemByIndex (int index)
   {
      return getList().getItemByIndex (index);
   }


   /**
    * Get the selectedIncrement attribute of the PEListIncr object
    *
    * @return   The selectedIncrement value
    */
   public ASGElement getSelectedIncrement()
   {
      return getList().getSelectedIncrement();
   }


   /**
    * Get the incrementIndex attribute of the PEListIncr object
    *
    * @param incr  No description provided
    * @return      The incrementIndex value
    */
   public int getIncrementIndex (ASGElement incr)
   {
      return getList().getIncrementIndex (incr);
   }


   /**
    * Get the incrementByName attribute of the PEListIncr object
    *
    * @param name  No description provided
    * @return      The incrementByName value
    */
   public ASGElement getIncrementByName (String name)
   {
      return getList().getIncrementByName (name);
   }


   /**
    * Get the incrementSelected attribute of the PEListIncr object
    *
    * @param incr  No description provided
    * @return      The incrementSelected value
    */
   public boolean isIncrementSelected (ASGElement incr)
   {
      return getList().isIncrementSelected (incr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    */
   public void remove (ASGElement incr)
   {
      getList().remove (incr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    */
   public void selectIncrement (ASGElement incr)
   {
      getList().selectIncrement (incr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incrs  No description provided
    */
   public void selectIncrements (ASGElement[] incrs)
   {
      int[] indices = new int[incrs.length];
      for (int i = 0; i < incrs.length; i++)
      {
         indices[i] = getList().getIncrementIndex (incrs[i]);
         if (log.isDebugEnabled())
         {
            log.debug ("index: " +  (new Integer (indices[i])).toString());
         }
      }
      getList().setSelectedIndices (indices);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void clearSelection()
   {
      getList().clearSelection();
   }
}

/*
 * $Log: PEListIncr.java,v $
 * Revision 1.25  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
