/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.uml.utility.MultiLinkGenerator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class PEMultiLink extends BasicPropertyEditor
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement secondIncrement;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField sourceLabel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField targetLabel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEButton swapButton;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox containerComboBox;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField indexTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton firstRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton lastRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton directRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton indirectRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JRadioButton indexRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox negativeCheckBox;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static String IDSwap = "Swap";


   /**
    * Constructor for class PEMultiLink
    *
    * @param frame  No description provided
    */
   public PEMultiLink (JFrame frame)
   {
      super (frame);
      setTitle ("MultiLink Editor");
      initPE();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      PEColumn column = new PEColumn (this);

      PERow linknTypeRow = new PERow (this);

      PEColumn linkColumn = new PEColumn (this);
      linkColumn.setBorder (new TitledBorder ("MultiLink"));
      linkColumn.setLayout (new BorderLayout());

      PERow linkRow = new PERow (this);
      JLabel fromLabel = new JLabel ("From ");
      sourceLabel = new JTextField (15);
      sourceLabel.setEditable (false);
      JLabel toLabel = new JLabel (" to ");
      targetLabel = new JTextField (15);
      targetLabel.setEditable (false);

      JPanel swapButtonPanel = new JPanel();
      swapButtonPanel.setLayout (new FlowLayout (FlowLayout.CENTER));
      swapButton = new PEButton (this, IDSwap);
      swapButton.setEnabled (false);
      swapButtonPanel.add (swapButton);

      linkRow.add (fromLabel);
      linkRow.add (sourceLabel);
      linkRow.add (toLabel);
      linkRow.add (targetLabel);
      linkColumn.add (linkRow, BorderLayout.CENTER);
      linkColumn.add (swapButtonPanel, BorderLayout.SOUTH);
      linknTypeRow.add (linkColumn);

      PERow containerGollum = new PERow (this);
      containerGollum.setBorder (new TitledBorder ("Container Object"));
      containerComboBox = new JComboBox();
      containerComboBox.setRenderer (new MyCellRenderer());
      containerGollum.add (containerComboBox);
      linknTypeRow.add (containerGollum);

      column.add (linknTypeRow);

      PERow typeConstraintRow = new PERow (this);

      PERow typeColumn = new PERow (this);
      typeColumn.setBorder (new TitledBorder ("Type"));

      ButtonGroup typeButtonGroup = new ButtonGroup();
      ActionListener radioButtonListener = new RadioButtonListener();

      firstRadioButton = new JRadioButton ("First");
      firstRadioButton.addActionListener (radioButtonListener);
      typeButtonGroup.add (firstRadioButton);
      typeColumn.add (firstRadioButton);

      lastRadioButton = new JRadioButton ("Last");
      lastRadioButton.addActionListener (radioButtonListener);
      typeButtonGroup.add (lastRadioButton);
      typeColumn.add (lastRadioButton);

      directRadioButton = new JRadioButton ("Direct");
      directRadioButton.addActionListener (radioButtonListener);
      typeButtonGroup.add (directRadioButton);
      typeColumn.add (directRadioButton);

      indirectRadioButton = new JRadioButton ("Indirect");
      indirectRadioButton.addActionListener (radioButtonListener);
      typeButtonGroup.add (indirectRadioButton);
      typeColumn.add (indirectRadioButton);

      PERow indexRow = new PERow (this);
      indexRadioButton = new JRadioButton ("Index");
      indexRadioButton.addActionListener (radioButtonListener);
      typeButtonGroup.add (indexRadioButton);
      indexRow.add (indexRadioButton);

      indexTextField = new JTextField (5);
      indexRow.add (indexTextField);

      typeColumn.add (indexRow);
      typeConstraintRow.add (typeColumn);

      PERow constraintRow = new PERow (this);
      constraintRow.setBorder (new TitledBorder ("Constraint"));

      negativeCheckBox = new JCheckBox ("Negative");
      constraintRow.add (negativeCheckBox);
      typeConstraintRow.add (constraintRow);

      column.add (typeConstraintRow);

      panel.add (column);
   }


   /**
    * Sets the increment attribute of the PEMultiLink object
    *
    * @param asgElement        The new increment value
    * @param secondAsgElement  The new increment value
    */
   public void setIncrement (ASGElement asgElement, ASGElement secondAsgElement)
   {
      this.secondIncrement = secondAsgElement;
      super.setIncrement (asgElement);
   }


   /**
    * Get all information from the user interface and put them back to the parameters that
    * can be modified by this dialog. Called by okPressed ().
    *
    * @see   de.uni_paderborn.fujaba.gui.AbstractDialog#okPressed
    */
   protected void parse()
   {
      ASGElement umlIncrement = getIncrement();
      MultiLinkGenerator multiLinkGen = new MultiLinkGenerator();

      // type
      int type = -1;
      if (firstRadioButton.isSelected())
      {
         type = UMLMultiLink.FIRST;
      }
      else if (lastRadioButton.isSelected())
      {
         type = UMLMultiLink.LAST;
      }
      else if (directRadioButton.isSelected())
      {
         type = UMLMultiLink.DIRECT;
      }
      else if (indirectRadioButton.isSelected())
      {
         type = UMLMultiLink.INDIRECT;
      }
      else if (indexRadioButton.isSelected())
      {
         type = UMLMultiLink.INDEX;
      }
      else
      {
         JOptionPane.showMessageDialog (getFrame(), "No MultiLink type selected.", "Edit MultiLink", JOptionPane.ERROR_MESSAGE);
         return;
      }

      int index = 0;
      if (indexTextField.isEnabled() && indexTextField.isEditable())
      {
         try
         {
            index = Integer.parseInt (indexTextField.getText());
         }
         catch (NumberFormatException e)
         {
            JOptionPane.showMessageDialog (getFrame(), "Invalid index. Index must be an integer value", "Edit MultiLink", JOptionPane.ERROR_MESSAGE);
            return;
         }
      }

      UMLObject containerObject = (UMLObject) containerComboBox.getSelectedItem();
      if (containerObject == null)
      {
         JOptionPane.showMessageDialog (getFrame(), "Container Object is null!", "Edit MultiLink", JOptionPane.ERROR_MESSAGE);
      }

      multiLinkGen.generateMultiLink (type, index, negativeCheckBox.isSelected(), containerObject, umlIncrement, secondIncrement);

      UMLProject.get().refreshDisplay();
   }


   /**
    * Read the parameters which can be modified and put all information into the dialogs user
    * interface. Called by initialize ().
    *
    * @see   de.uni_paderborn.fujaba.gui.AbstractDialog#initialize
    */
   protected void unparse()
   {
      ASGElement umlIncrement = getIncrement();

      if (umlIncrement instanceof UMLMultiLink)
      {
         UMLMultiLink multiLink = (UMLMultiLink) umlIncrement;

         UMLObject sourceObj = multiLink.getSourceObject();
         UMLObject targetObj = multiLink.getTargetObject();
         if (sourceObj != null)
         {
            sourceLabel.setText (sourceObj.getObjectName());
         }
         else
         {
            sourceLabel.setText ("undefined_value");
         }

         if (targetObj != null)
         {
            targetLabel.setText (targetObj.getObjectName());
         }
         else
         {
            targetLabel.setText ("undefined_value");
         }

         // type
         int type = multiLink.getType();
         if (type == UMLMultiLink.FIRST)
         {
            firstRadioButton.setSelected (true);
            indexTextField.setEditable (false);

            firstRadioButton.setEnabled (true);
            lastRadioButton.setEnabled (true);
            indexRadioButton.setEnabled (false);
            directRadioButton.setEnabled (false);
            indirectRadioButton.setEnabled (false);
         }
         else if (type == UMLMultiLink.LAST)
         {
            lastRadioButton.setSelected (true);
            indexTextField.setEditable (false);

            firstRadioButton.setEnabled (true);
            lastRadioButton.setEnabled (true);
            indexRadioButton.setEnabled (false);
            directRadioButton.setEnabled (false);
            indirectRadioButton.setEnabled (false);
         }
         else if (type == UMLMultiLink.DIRECT)
         {
            directRadioButton.setSelected (true);
            indexTextField.setEditable (false);

            firstRadioButton.setEnabled (false);
            lastRadioButton.setEnabled (false);
            indexRadioButton.setEnabled (true);
            directRadioButton.setEnabled (true);
            indirectRadioButton.setEnabled (true);
         }
         else if (type == UMLMultiLink.INDIRECT)
         {
            indirectRadioButton.setSelected (true);
            indexTextField.setEditable (false);

            firstRadioButton.setEnabled (false);
            lastRadioButton.setEnabled (false);
            indexRadioButton.setEnabled (true);
            directRadioButton.setEnabled (true);
            indirectRadioButton.setEnabled (true);
         }
         else if (type == UMLMultiLink.INDEX)
         {
            indexRadioButton.setSelected (true);
            indexTextField.setEditable (true);
            indexTextField.setText (String.valueOf (multiLink.getIndex()));

            firstRadioButton.setEnabled (false);
            lastRadioButton.setEnabled (false);
            indexRadioButton.setEnabled (true);
            directRadioButton.setEnabled (true);
            indirectRadioButton.setEnabled (true);
         }

         // initialize container combo box
         UMLLink link;

         if (multiLink.getSourceLink() != null)
         {
            link = multiLink.getSourceLink();
         }
         else
         {
            link = multiLink.getTargetLink();
         }

         int leftCard = link.getInstanceOf().getLeftRole().getCard().getUpperBound();
         int rightCard = link.getInstanceOf().getRightRole().getCard().getUpperBound();

         if (rightCard > 1)
         {
            containerComboBox.addItem (link.getSource());
         }
         if (leftCard > 1)
         {
            containerComboBox.addItem (link.getTarget());
         }
         containerComboBox.setSelectedItem (multiLink.getContainerObject());

         // negative
         if (multiLink.isNegative())
         {
            negativeCheckBox.setSelected (true);
         }

         setTitle ("Edit MultiLink");
      }
      else if ( (umlIncrement instanceof UMLLink) &&  (secondIncrement != null)
         &&  (secondIncrement instanceof UMLLink) &&  (umlIncrement != secondIncrement))
      {
         // initialize container combo box
         UMLLink sourceLink = (UMLLink) umlIncrement;
         UMLLink targetLink = (UMLLink) secondIncrement;

         UMLObject sourceObjTarget = sourceLink.getTarget();
         UMLObject targetObjTarget = targetLink.getTarget();
         if (sourceObjTarget != null)
         {
            sourceLabel.setText (sourceObjTarget.getObjectName());
         }
         else
         {
            sourceLabel.setText ("undefined_value");
         }

         if (targetObjTarget != null)
         {
            targetLabel.setText (targetObjTarget.getObjectName());
         }
         else
         {
            targetLabel.setText ("undefined_value");
         }

         if (sourceObjTarget != null && targetObjTarget != null)
         {
            swapButton.setEnabled (true);
         }

         UMLObject sourceObject = sourceLink.getSource();
         UMLObject targetObject = targetLink.getSource();
         if (sourceObject == targetObject)
         {
            containerComboBox.addItem (sourceObject);
         }
         else
         {
            sourceObject = sourceLink.getTarget();
            if (sourceObject == targetObject)
            {
               containerComboBox.addItem (sourceObject);
            }
            else
            {
               containerComboBox.addItem (targetLink.getTarget());
            }
         }
         containerComboBox.setSelectedIndex (0);

         // type
         firstRadioButton.setEnabled (false);
         lastRadioButton.setEnabled (false);
         indexRadioButton.setEnabled (true);
         directRadioButton.setEnabled (true);
         indirectRadioButton.setEnabled (true);

         // index field
         indexTextField.setEditable (false);

         setTitle ("New MultiLink");
      }
      else if (umlIncrement instanceof UMLLink)
      {
         // initialize container combo box
         UMLLink link = (UMLLink) umlIncrement;

         sourceLabel.setText ("");
         UMLObject linkTarget = link.getTarget();
         if (linkTarget != null)
         {
            targetLabel.setText (linkTarget.getObjectName());
         }

         int leftCard = link.getInstanceOf().getLeftRole().getCard().getUpperBound();
         int rightCard = link.getInstanceOf().getRightRole().getCard().getUpperBound();

         if (rightCard > 1)
         {
            containerComboBox.addItem (link.getSource());
            containerComboBox.setSelectedIndex (0);
         }

         if (leftCard > 1)
         {
            containerComboBox.addItem (link.getTarget());
            containerComboBox.setSelectedIndex (0);
         }

         // type
         firstRadioButton.setEnabled (true);
         lastRadioButton.setEnabled (true);
         indexRadioButton.setEnabled (false);
         directRadioButton.setEnabled (false);
         indirectRadioButton.setEnabled (false);

         // index field
         indexTextField.setEditable (false);

         if (link.getRevTargetLink() != null)
         {
            UMLMultiLink multiLink = link.getRevTargetLink();

            if (multiLink.getType() == UMLMultiLink.FIRST)
            {
               //This link points to the FIRST element
               firstRadioButton.setSelected (true);
            }
         }
         else if (link.getRevSourceLink() != null)
         {
            UMLMultiLink multiLink = link.getRevSourceLink();

            if (multiLink.getType() == UMLMultiLink.LAST)
            {
               //This link points to the LAST element
               lastRadioButton.setSelected (true);
            }
         }

         setTitle ("New MultiLink");
      }
   }


   /**
    * Put all constraint checks that have to be verified before leaving the dialog into this
    * method.
    *
    * @return   true, if all constraints are fulfilled.
    */
   protected boolean checkConstraints()
   {
      int index = -1;
      int type = -1;
      boolean result = true;

      ASGElement umlIncrement = getIncrement();

      if (firstRadioButton.isSelected())
      {
         type = UMLMultiLink.FIRST;
      }
      else if (lastRadioButton.isSelected())
      {
         type = UMLMultiLink.LAST;
      }
      else if (directRadioButton.isSelected())
      {
         type = UMLMultiLink.DIRECT;
      }
      else if (indirectRadioButton.isSelected())
      {
         type = UMLMultiLink.INDIRECT;
      }
      else if (indexRadioButton.isSelected())
      {
         type = UMLMultiLink.INDEX;
      }
      else
      {
         JOptionPane.showMessageDialog (this, "Please specify the type of the multilink.",
            "No multilink type", JOptionPane.ERROR_MESSAGE);
         result = false;

         return result;
      }

      if ( (umlIncrement instanceof UMLLink) &&  (secondIncrement != null) &&  (secondIncrement instanceof UMLLink))
      {
         UMLLink sourceLink = (UMLLink) umlIncrement;
         UMLLink targetLink = (UMLLink) secondIncrement;

         // source- and target-Link must have the same instance of association
         if (!sourceLink.getInstanceOf().equals (targetLink.getInstanceOf()))
         {
            JOptionPane.showMessageDialog (this, "Please select two links of the same association, press cancel to leave the dialog!",
               "Link mismatch", JOptionPane.ERROR_MESSAGE);
            result = false;
         }
      }
      else if (type == UMLMultiLink.FIRST)
      {
         UMLLink link = (UMLLink) umlIncrement;

         UMLObject object;
         if (!link.getTarget().equals (containerComboBox.getSelectedItem()))
         {
            object = link.getTarget();
         }
         else
         {
            object = link.getSource();
         }

         if (object.getType() == UMLObject.SET)
         {
            result = false;
            JOptionPane.showMessageDialog (this, "First-MultiLink can only points to a normal object, press cancel to leave the dialog!",
               "Object is set", JOptionPane.ERROR_MESSAGE);
         }
      }
      else if (type == UMLMultiLink.LAST)
      {
         UMLLink link = (UMLLink) umlIncrement;

         UMLObject object;
         if (!link.getTarget().equals (containerComboBox.getSelectedItem()))
         {
            object = link.getTarget();
         }
         else
         {
            object = link.getSource();
         }

         if (object.getType() == UMLObject.SET)
         {
            result = false;
            JOptionPane.showMessageDialog (this, "Last-MultiLink can only points to a normal object, press cancel to leave the dialog!",
               "Object is set", JOptionPane.ERROR_MESSAGE);
         }
      }
      else if (type == UMLMultiLink.INDEX)
      {
         try
         {
            index = Integer.parseInt (indexTextField.getText());
         }
         catch (Exception e)
         {
            result = false;
            JOptionPane.showMessageDialog (this, "Please enter only integer values in the index field.",
               "Index is not integer", JOptionPane.ERROR_MESSAGE);
         }

         if (result == true)
         {
            if (index >= 1)
            {
               result = true;
            }
            else
            {
               result = false;
               JOptionPane.showMessageDialog (this, "Please enter an index >= 1",
                  "Invalid index", JOptionPane.ERROR_MESSAGE);
            }
         }
      }

      return result;
   } // checkConstraints


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel()
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void buttonOK_actionPerformed (ActionEvent e)
   { // public needed temporarily, JW.

      if (checkConstraints())
      {
         super.buttonOK_actionPerformed (e);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param buttonIdentifier  No description provided
    * @param e                 No description provided
    * @return                  No description provided
    */
   public boolean buttonActionPerformed (String buttonIdentifier, ActionEvent e)
   {
      if (buttonIdentifier.equals (IDSwap))
      {
         if (secondIncrement != null)
         {
            setIncrement (secondIncrement, getIncrement());
            containerComboBox.removeAllItems();
            unparse();
         }
      } // if

      return PEButton.remainedUnbound;
   } // buttonActionPerformed



   // ================================= inner classes ========================================

   /**
    * This class renders the content of containerComboBox in human readable format
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.12 $
    */
   class MyCellRenderer extends JLabel implements ListCellRenderer
   {
      /**
       * Constructor for class MyCellRenderer
       */
      public MyCellRenderer()
      {
         setOpaque (true);
      }


      /**
       * Get the listCellRendererComponent attribute of the MyCellRenderer object
       *
       * @param list          No description provided
       * @param value         No description provided
       * @param index         No description provided
       * @param isSelected    No description provided
       * @param cellHasFocus  No description provided
       * @return              The listCellRendererComponent value
       */
      public Component getListCellRendererComponent (JList list, Object value,
                                                     int index, boolean isSelected, boolean cellHasFocus)
      {
         if (isSelected)
         {
            setBackground (list.getSelectionBackground());
            setForeground (list.getSelectionForeground());
         }
         else
         {
            setBackground (list.getBackground());
            setForeground (list.getForeground());
         }

         if (value instanceof UMLObject)
         {
            UMLObject obj = (UMLObject) value;
            setText (" " + obj.getObjectName() + ": " + obj.getInstanceOf() + " ");
         }
         else
         {
            setText ("unknown_value");
         }

         return this;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.12 $
    */
   private class RadioButtonListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         if (indexRadioButton.isSelected())
         {
            indexTextField.setEditable (true);
         }
         else
         {
            indexTextField.setEditable (false);
         }
      } // actionPerformed

   } // RadioButtonListener

}

/*
 * $Log: PEMultiLink.java,v $
 * Revision 1.12  2004/10/20 17:49:54  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
