/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Enumeration;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.uni_paderborn.fujaba.asg.ASGElement;


/**
 * Class to implements a selection component. A selection component contains two list called
 * source and destination and at least a add and a remove button to select and deselect from
 * the source to the destination list.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.33 $
 */
public class PESelection extends PEHeaderComponent implements PEResizable
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEListIncr source;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEListIncr destination;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEColumn buttonCol = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEButton addButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEButton removeButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEButton modifyButton = null;


   /**
    * Constructor for class PESelection
    *
    * @param parent  No description provided
    */
   public PESelection (BasicPropertyEditor parent)
   {
      super();
      setParent (parent);
      source = new PEListIncr (this.parent, "Source");
      destination = new PEListIncr (this.parent, "Destination");
      source.addSelectionListener (new PESourceSelectionListener (this));
      destination.addSelectionListener (new PEDestSelectionListener (this));
      setLayout (getLayoutManager());
      addComponents();
   }


   /**
    * Sets the readOnly attribute of the PESelection object
    *
    * @param b  The new readOnly value
    */
   public void setReadOnly (boolean b)
   {
   }


   /**
    * Get the buttonColumn attribute of the PESelection object
    *
    * @return   The buttonColumn value
    */
   protected PEColumn getButtonColumn()
   {
      return buttonCol;
   }


   /**
    * Get the parentPE attribute of the PESelection object
    *
    * @return   The parentPE value
    */
   protected BasicPropertyEditor getParentPE()
   {
      return parent;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addComponents()
   {
      PEColumn column = new PEColumn (getParentPE());
      PERow row = new PERow (getParentPE());
      row.add (source);

      buttonCol = new PEColumn (getParentPE());
      buttonCol.setComponentName ("buttons");

      // thsa : changed creation of buttons
      addButton = new PEButton (this, "add");
      removeButton = new PEButton (this, "remove");
      modifyButton = new PEButton (this, "apply");
      buttonCol.add (addButton);
      buttonCol.add (removeButton);
      buttonCol.add (modifyButton);

      row.add (buttonCol);

      row.add (destination);
      column.add (row);
      add (column);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement umlIncr = null;


   /**
    * The function setIncrement () sets the corresponding object of the AST
    *
    * @param incr  The new increment value
    */
   public void setIncrement (ASGElement incr)
   {
      umlIncr = incr;
      source.removeAll();
      destination.removeAll();
      fillSourceList();
      fillDestList();
   }


   /**
    * The function getIncrement () returns a valid reference of the corresponding AST object.
    *
    * @return   a valid reference of a AST object
    */
   public ASGElement getIncrement()
   {
      return umlIncr;
   }


   /**
    * The function clearSource () removes all entries of the source list.
    */
   public void clearSource()
   {
      source.removeAll();
   }


   /**
    * The function clearDest () removes all entries of the destination list
    */
   public void clearDest()
   {
      destination.removeAll();
   }


   /**
    * The function getSourceSelectedIncr () returns a valid reference of an object of the AST.
    * The function returns the first entry, if more than one selected.
    *
    * @return   a valid reference to an object of the AST
    */
   public ASGElement getSourceSelectedIncr()
   {
      return source.getSelectedIncrement();
   }


   /**
    * The function getDestinationIncr () returns a valid reference of an object of the AST.
    * The function returns the first entry, if more than one selected.
    *
    * @return   a valid reference to an object of the AST
    */
   public ASGElement getDestSelectedIncr()
   {
      return destination.getSelectedIncrement();
   }


   /**
    * Sets the sourceSelectedIncr attribute of the PESelection object
    *
    * @param incr  The new sourceSelectedIncr value
    */
   public void setSourceSelectedIncr (ASGElement incr)
   {
      getSource().selectIncrement (incr);
   }


   /**
    * Sets the destSelectedIncr attribute of the PESelection object
    *
    * @param incr  The new destSelectedIncr value
    */
   public void setDestSelectedIncr (ASGElement incr)
   {
      getDest().selectIncrement (incr);
   }


   /**
    * The function setAddListener sets a listener for the add button
    *
    * @param listener  a valid reference of an action adapter
    */
   public void setAddListener (ActionListener listener)
   {
      addButton.setListener (listener);
   }


   /**
    * The function setAddListener sets a listener for the remove button
    *
    * @param listener  a valid reference of an action adapter
    */
   public void setRemoveListener (ActionListener listener)
   {
      removeButton.setListener (listener);
   }


   /**
    * The function setModifyListener sets a listener for the modify button
    *
    * @param listener  a valid reference of an action adapter
    */
   public void setModifyListener (ActionListener listener)
   {
      modifyButton.setListener (listener);
   }


   /**
    * The function setSourceMouseListener sets a listener for the source list
    *
    * @param listener  a valid reference of an action adapter
    */
   public void setSourceMouseListener (MouseListener listener)
   {
      source.addMouseListener (listener);
   }


   /**
    * The function setDestMouseListener sets a listener for the destination list
    *
    * @param listener  a valid reference of an action adapter
    */
   public void setDestMouseListener (MouseListener listener)
   {
      destination.addMouseListener (listener);
   }


   /**
    * The function addToSource () adds a new entry represented by a valid reference to an object
    * of the AST to the source list.
    *
    * @param incr  a valid reference to an object of the AST
    */
   public void addToSource (ASGElement incr)
   {
      PEItem item = new PEItem (incr);
      source.add (item);
   }


   /**
    * The function addToSource () adds a new entry represented by a valid reference to an object
    * of the AST and a string to the source list.
    *
    * @param incr  a valid reference to an object of the AST
    * @param s     a valid string represented the entry in the list
    */
   public void addToSource (ASGElement incr, String s)
   {
      PEItem item = new PEItem (incr, s);
      source.add (item);
   }


   /**
    * The function addToDest () adds a new entry represented by a valid reference to an object
    * of the AST to the destination list.
    *
    * @param incr  a valid reference to an object of the AST
    */
   public void addToDest (ASGElement incr)
   {
      PEItem item = new PEItem (incr);
      destination.add (item);
   }


   /**
    * The function addToDest () adds a new entry represented by a valid reference to an object
    * of the AST and a string to the source list.
    *
    * @param incr  a valid reference to an object of the AST
    * @param s     a valid string represented the entry in the list
    */

   public void addToDest (ASGElement incr, String s)
   {
      PEItem item = new PEItem (incr, s);
      destination.add (item);
   }


   /**
    * The function removeFromSource () removes a existing entry from the source list. The entry
    * will be identified by the reference of the represented object.
    *
    * @param incr  a valid reference of an object
    */
   public void removeFromSource (ASGElement incr)
   {
      source.remove (incr);
   }


   /**
    * The function removeFromSource () removes a existing entry from the destination list.
    * The entry will be identified by the reference of the represented object.
    *
    * @param incr  a valid reference of an object
    */
   public void removeFromDest (ASGElement incr)
   {
      destination.remove (incr);
   }


   /**
    * The function getSourceLsit returns a enumeration of the objects represented by the source
    * list.
    *
    * @return   a valid enumeration of the entries.
    */
   public Enumeration getSourceList()
   {
      return source.elements();
   }


   /**
    * Get the source attribute of the PESelection object
    *
    * @return   The source value
    */
   public PEListIncr getSource()
   {
      return source;
   }


   /**
    * Get the dest attribute of the PESelection object
    *
    * @return   The dest value
    */
   public PEListIncr getDest()
   {
      return destination;
   }


   /**
    * Override the function fillSourceList () to initialize the source list. This function
    * will be called if a increment will be set.
    */
   protected void fillSourceList()
   {
   }


   /**
    * Override the function fillDestList () to initialize the destination list. This function
    * will be called if a increment will be set.
    */
   protected void fillDestList()
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void sourceSelectionChanged()
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void destSelectionChanged()
   {
   }


   /**
    * Get the sourceIncrementByName attribute of the PESelection object
    *
    * @param name  No description provided
    * @return      The sourceIncrementByName value
    */
   public ASGElement getSourceIncrementByName (String name)
   {
      return source.getIncrementByName (name);
   }


   /**
    * Get the destIncrementByName attribute of the PESelection object
    *
    * @param name  No description provided
    * @return      The destIncrementByName value
    */
   public ASGElement getDestIncrementByName (String name)
   {
      return destination.getIncrementByName (name);
   }


   /**
    * Get the horzResizable attribute of the PESelection object
    *
    * @return   The horzResizable value
    */
   public boolean isHorzResizable()
   {
      return true;
   }


   /**
    * Get the vertResizable attribute of the PESelection object
    *
    * @return   The vertResizable value
    */
   public boolean isVertResizable()
   {
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param g  No description provided
    */
   public void paint (Graphics g)
   {
      super.paint (g);
      g.drawString ("test", 0, 0);
   }


   //////////////////////////////////////////////////////////////////////////
   // thsa : added some function to handle button events for
   // introduced buttons
   // --> to be overwritten by each subclass which
   // takes use of buttons add/remove/modify

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param buttonIdentifier  No description provided
    * @param e                 No description provided
    * @return                  No description provided
    */
   public boolean buttonActionPerformed (String buttonIdentifier, ActionEvent e)
   {
      return PEButton.remainedUnbound;
   }

   // added return functions for buttons
   /**
    * Get the addButton attribute of the PESelection object
    *
    * @return   The addButton value
    */
   protected PEButton getAddButton()
   {
      return addButton;
   }


   /**
    * Get the removeButton attribute of the PESelection object
    *
    * @return   The removeButton value
    */
   protected PEButton getRemoveButton()
   {
      return removeButton;
   }


   /**
    * Get the modifyButton attribute of the PESelection object
    *
    * @return   The modifyButton value
    */
   protected PEButton getModifyButton()
   {
      return modifyButton;
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.33 $
 */
class PESourceSelectionListener implements ListSelectionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PESelection adaptor;


   /**
    * Constructor for class PESourceSelectionListener
    *
    * @param adapter  No description provided
    */
   PESourceSelectionListener (PESelection adapter)
   {
      adaptor = adapter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void valueChanged (ListSelectionEvent e)
   {
      adaptor.sourceSelectionChanged();
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.33 $
 */
class PEDestSelectionListener implements ListSelectionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PESelection adaptor;


   /**
    * Constructor for class PEDestSelectionListener
    *
    * @param adapter  No description provided
    */
   PEDestSelectionListener (PESelection adapter)
   {
      adaptor = adapter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void valueChanged (ListSelectionEvent e)
   {
      adaptor.destSelectionChanged();
   }
}

/*
 * $Log: PESelection.java,v $
 * Revision 1.33  2004/11/03 10:18:05  lowende
 * Javadoc warnings removed.
 *
 */
