/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.*;
import java.util.Iterator;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.fca.FLinkedList;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.118.2.1 $
 */
public class PEVariable extends PropertyEditor
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (PEVariable.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PETextField propertyName;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PETextField initialValue;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECombo umlVisibilityChoice;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEVariableSelection selection;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck finalModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck staticModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck transientModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PERadioGroup createAccessMethods;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck pointer = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FLinkedList addAttrs = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FLinkedList delAttrs = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FLinkedList refClasses = new FLinkedList();


   /**
    * Constructor for class PEVariable
    *
    * @param frame  No description provided
    * @param title  No description provided
    * @param modal  No description provided
    */
   public PEVariable (JFrame frame, String title, boolean modal)
   {
      super (frame);
      setModal (modal);
      setTitle (title);
      try
      {
         pack();
         this.setTitle ("Attribute Editor");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      initPE();

      addFocusListener (new CMAFocusListener (propertyName));

      propertyName.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               addButton_actionPerformed (e);
            }
         }
         );
   }


   /**
    * Constructor for class PEVariable
    *
    * @param frame  No description provided
    */
   public PEVariable (JFrame frame)
   {
      this (frame, "", false);
   }


   /**
    * Constructor for class PEVariable
    *
    * @param frame  No description provided
    * @param modal  No description provided
    */
   public PEVariable (JFrame frame, boolean modal)
   {
      this (frame, "", modal);
   }


   /**
    * Constructor for class PEVariable
    *
    * @param frame  No description provided
    * @param title  No description provided
    */
   public PEVariable (JFrame frame, String title)
   {
      this (frame, title, false);
   }


   /**
    * Sets the propertyName attribute of the PEVariable object
    *
    * @param name  The new propertyName value
    */
   public void setPropertyName (String name)
   {
      propertyName.setText (name);
   }


   /**
    * Sets the initialValue attribute of the PEVariable object
    *
    * @param value  The new initialValue value
    */
   public void setInitialValue (String value)
   {
      initialValue.setText (value);
   }


   /**
    * Sets the umlVisibilityChoice attribute of the PEVariable object
    *
    * @param index  The new umlVisibilityChoice value
    */
   public void setUmlVisibilityChoice (int index)
   {
      umlVisibilityChoice.setSelectedIndex (index);
   }


   /**
    * Sets the finalModifier attribute of the PEVariable object
    *
    * @param b  The new finalModifier value
    */
   public void setFinalModifier (boolean b)
   {
      finalModifier.setSelected (b);
   }


   /**
    * Sets the staticModifier attribute of the PEVariable object
    *
    * @param b  The new staticModifier value
    */
   public void setStaticModifier (boolean b)
   {
      staticModifier.setSelected (b);
   }


   /**
    * Sets the createAccessMethods attribute of the PEVariable object
    *
    * @param create  The new createAccessMethods value
    */
   public void setCreateAccessMethods (int create)
   {
      createAccessMethods.setSelectedButtonIndex (create);
   }


   /**
    * Sets the createAccessMethods attribute of the PEVariable object
    *
    * @param create  The new createAccessMethods value
    */
   public void setCreateAccessMethods (boolean create)
   {
      setCreateAccessMethods ( (create ? UMLAttr.CREATE_ACCESS_METHODS_DEFAULT : UMLAttr.CREATE_ACCESS_METHODS_NO));
   }


   /**
    * Sets the pointer attribute of the PEVariable object
    *
    * @param b  The new pointer value
    */
   public void setPointer (boolean b)
   {
      pointer.setSelected (b);
   }


   /**
    * Sets the transientModifier attribute of the PEVariable object
    *
    * @param b  The new transientModifier value
    */
   public void setTransientModifier (boolean b)
   {
      transientModifier.setSelected (b);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      propertyName = new PETextField (this, "Attribute Name");
      initialValue = new PETextField (this, "Initial Value");
      umlVisibilityChoice = new PECombo (this, "UML Visibility");
      selection = new PEVariableSelection (this);
      finalModifier = new PECheck (this, "Final Modifier", "Attribut is final");
      staticModifier = new PECheck (this, "Static Modifier", "Attribut is static");
      transientModifier = new PECheck (this, "Transient Modifier", "Attribut is transient");
      createAccessMethods =  //new PECheck (this, "Access methods", "Create access methods");
      new PERadioGroup (this, "Access methods", new String[]{"Yes", "No", "Yes, except for constants"});
      pointer = new PECheck (this, "Pointer", "Attribut type is pointer");

      propertyName.setText (getPropertyName());
      propertyName.setStatus ("Enter the name of the attribute");

      initialValue.setText ("");
      initialValue.setStatus ("Enter the initial value of the attribute");

      setCreateAccessMethods (UMLAttr.CREATE_ACCESS_METHODS_DEFAULT);

      umlVisibilityChoice.add ("- private");
      umlVisibilityChoice.add ("+ public");
      umlVisibilityChoice.add ("# protected");
      umlVisibilityChoice.add ("~ package");
      umlVisibilityChoice.setSelectedIndex (1);
      umlVisibilityChoice.setStatus ("Select the visibility of the attribute");

      selection.setSourceMouseListener (new SourceMouseListener (selection.getSource().getList()));
      selection.setDestMouseListener (new DestMouseListener (selection.getSource().getList()));
      selection.setAddListener (new PEVariable_addButton_actionAdapter (this));
      selection.setRemoveListener (new PEVariable_removeButton_actionAdapter (this));
      selection.setModifyListener (new PEVariable_modifyButton_actionAdapter (this));

      PEColumn column = new PEColumn (this);
      column.add (propertyName);
      column.add (finalModifier);
      column.add (staticModifier);
      column.add (transientModifier);
      column.add (umlVisibilityChoice);
      column.add (createAccessMethods);
      column.add (pointer);

      column.add (initialValue);
      column.add (selection);

      panel.add (column);
   }


   /**
    * Sets the increment attribute of the PEVariable object
    *
    * @param incr  The new increment value
    */
   public void setIncrement (UMLIncrement incr)
   {
      setReadOnly (isReadOnly());

      if (incr instanceof UMLAttr)
      {
         super.setIncrement ( ((UMLAttr) incr).getParent());
         selection.getDest().selectIncrement (incr);
      }
      else
      {
         super.setIncrement (incr);
      }
      if (getClassIncrement() != null)
      {
         propertyName.setReadOnly (isReadOnly());
         initialValue.setReadOnly (isReadOnly());
         setTitle ("Attribute Editor: " + getClassIncrement().getName());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      if (getIncrement() instanceof UMLClass)
      {
         UMLClass selectedClass = (UMLClass) getIncrement();
         propertyName.setText (getPropertyName());
         selection.setIncrement (selectedClass);
         propertyName.selectAll();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      if (!isReadOnly())
      {
         ASGElement incr = getIncrement();

         if (incr instanceof UMLClass)
         {
            UMLAttr attr = null;

            Iterator iter = addAttrs.iterator();
            while (iter.hasNext())
            {
               attr = (UMLAttr) iter.next();
               attr.setParent ((UMLClass) incr);

               // add access methods to class
               Iterator it = attr.iteratorOfAccessMethods();
               while (it.hasNext())
               {
                  UMLMethod method = (UMLMethod) it.next();
                  method.setParent ((UMLClass) incr);
               }
            }
            addAttrs.clear();

            iter = delAttrs.iterator();
            while (iter.hasNext())
            {
               attr = (UMLAttr) iter.next();

               attr.removeYou();
            }
            delAttrs.clear();

            iter = refClasses.iterator();
            while (iter.hasNext())
            {
               UMLClass refClass = (UMLClass) iter.next();

               Iterator diags =  ((UMLClass) incr).iteratorOfDiagrams();
               if (diags != null)
               {
                  UMLDiagram diag = null;
                  while (diags.hasNext())
                  {
                     diag = (UMLDiagram) diags.next();
                     diag.addToElements (refClass);
                  }
               }
            }
            refClasses.clear();

         }
      }
      else
      {
         if (log.isDebugEnabled())
         {
            log.debug ("Editor in ReadOnly mode.");
         }
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel()
   {
      refClasses.clear();
      addAttrs.clear();
      delAttrs.clear();
      setVisible (false);
      dispose();
   }


   /**
    * Access method for an one to n association.
    *
    * @param e  The object added.
    */
   void addButton_actionPerformed (ActionEvent e)
   {
      if ( (selection.getTypeName().length() > 0) &&  (propertyName.getText().length() > 0))
      {
         UMLAttr newAttr = new UMLAttr();
         newAttr.setName (propertyName.getText());
         newAttr.setFinal (finalModifier.isSelected());
         newAttr.setUmlStatic (staticModifier.isSelected());
         newAttr.setTransient (transientModifier.isSelected());
         newAttr.setInitialValue (initialValue.getText());
         ASGElement incr = selection.getSourceIncrementByName (selection.getTypeName());
         // the type is null if a stereotype must be created for the class
         if (incr == null)
         {
            UMLTypeList typelist = null;
            if (getIncrement() instanceof UMLClass)
            {
               typelist =  ((UMLClass) getIncrement()).getRevTypes();
            }
            UMLClass refClass = new UMLClass (selection.getTypeName(),
               UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.REFERENCE), typelist, null);
            newAttr.setAttrType (refClass);
            refClasses.add (refClass);
         }
         else
         {
            newAttr.setAttrType ((UMLType) incr);
         }

         newAttr.setVisibility (umlVisibilityChoice.getSelectedIndex());
         newAttr.setPointer (pointer.isSelected());

         //to let the access methods generator know to which class the attr belongs:
         newAttr.setParent ((UMLClass) getIncrement());
         newAttr.setCreateAccessMethods (createAccessMethods.getSelectedButtonIndex());
         handleAccessMethods (selection, false, umlVisibilityChoice.getSelectedIndex(), newAttr);
         //but we want the newAttr to be added only on OK - so remove it from the class again
         newAttr.setParent (null);

         addAttrs.add (newAttr);
         selection.addToDest (newAttr);
         propertyName.setText ("");
         propertyName.requestFocus();

         pointer.setSelected (false);
      }
   }


   /**
    * Create or delete access methods for the attribute depending on the user selection.
    *
    * @param newAttr              The attribute to handle.
    * @param selection            No description provided
    * @param createAccessMethods  No description provided
    * @param umlVisibilityChoice  No description provided
    */
   public static void handleAccessMethods (PESelection selection,
                                           boolean createAccessMethods,
                                           int umlVisibilityChoice,
                                           UMLAttr newAttr)
   {
      if (selection != null)
      {
         selection.setDestSelectedIncr (newAttr);
      }

      // delete old access methods
      Iterator iter = newAttr.iteratorOfAccessMethods();
      while (iter.hasNext())
      {
         UMLMethod method = (UMLMethod) iter.next();
         method.removeYou();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   protected void removeButton_actionPerformed (ActionEvent e)
   {
      ASGElement incr = selection.getDestSelectedIncr();
      if (incr != null)
      {
         delAttrs.add (incr);
         selection.removeFromDest (incr);
         addAttrs.remove (incr);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void modifyButton_actionPerformed (ActionEvent e)
   {
      ASGElement oldIncr = selection.getDestSelectedIncr();
      if (oldIncr != null && oldIncr instanceof UMLAttr)
      {
         // Fix me: The new editor should make it better handling modified items.
         UMLAttr curAttr = (UMLAttr) oldIncr;

         //FujabaLog: Clone UMLAttr to check for differences
         UMLAttr oldAttr = new UMLAttr();
         oldAttr.setName (curAttr.getName());
         oldAttr.setFinal (curAttr.isFinal());
         oldAttr.setUmlStatic (curAttr.isUmlStatic());
         oldAttr.setTransient (curAttr.isTransient());
         oldAttr.setInitialValue (curAttr.getInitialValue());
         oldAttr.setVisibility (curAttr.getVisibility());
         oldAttr.setAttrType (curAttr.getAttrType());
         oldAttr.setCreateAccessMethods (curAttr.getCreateAccessMethods());
         oldAttr.setPointer (curAttr.isPointer());
         //FujabaLog end

         curAttr.setName (propertyName.getText());
         curAttr.setFinal (finalModifier.isSelected());
         curAttr.setUmlStatic (staticModifier.isSelected());
         curAttr.setTransient (transientModifier.isSelected());
         curAttr.setInitialValue (initialValue.getText());
         curAttr.setVisibility (umlVisibilityChoice.getSelectedIndex());
         curAttr.setCreateAccessMethods (createAccessMethods.getSelectedButtonIndex());
         curAttr.setPointer (pointer.isSelected());

         ASGElement incr = selection.getSourceIncrementByName (selection.getTypeName());
         // the type is null if a stereotype must be created for the class
         if (incr == null)
         {
            UMLTypeList typelist = null;
            if (getIncrement() instanceof UMLClass)
            {
               typelist =  ((UMLClass) getIncrement()).getRevTypes();
            }
            UMLClass refClass = new UMLClass (selection.getTypeName(),
               UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.REFERENCE), typelist, null);
            curAttr.setAttrType (refClass);
            refClasses.add (refClass);
         }
         else
         {
            curAttr.setAttrType ((UMLType) incr);
         }

         handleAccessMethods (selection, createAccessMethods.getSelectedButtonIndex() != UMLAttr.CREATE_ACCESS_METHODS_NO,
            umlVisibilityChoice.getSelectedIndex(), curAttr);

         selection.removeFromDest (curAttr);
         selection.addToDest (curAttr);
      }
   }


   /**
    * Get the propertyName attribute of the PEVariable object
    *
    * @return   The propertyName value
    */
   protected String getPropertyName()
   {
      if (getClassIncrement() != null)
      {
         int count = 1;
         Iterator iter = getClassIncrement().iteratorOfAttrs();
         while (iter.hasNext())
         {
            count++;
            iter.next();
         }

         return "var" + count;
      }

      return "New Variable";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.118.2.1 $
    */
   private class SourceMouseListener implements MouseListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEListbox liste;


      /**
       * Constructor for class SourceMouseListener
       *
       * @param list  No description provided
       */
      SourceMouseListener (PEListbox list)
      {
         liste = list;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e)
      {
         if (e.getClickCount() == 2)
         {
            ASGElement oldIncr = selection.getDestSelectedIncr();
            if (oldIncr != null && oldIncr instanceof UMLAttr)
            {
               UMLAttr curAttr = (UMLAttr) oldIncr;

               if (propertyName.getText().equals (curAttr.getName()))
               {
                  modifyButton_actionPerformed (null);
               }
               else
               {
                  addButton_actionPerformed (null);
               }
            }
            else
            {
               addButton_actionPerformed (null);
            }
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseEntered (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseExited (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e) { }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.118.2.1 $
    */
   private class DestMouseListener implements MouseListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEListbox liste;


      /**
       * Constructor for class DestMouseListener
       *
       * @param list  No description provided
       */
      DestMouseListener (PEListbox list)
      {
         liste = list;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseEntered (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseExited (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e)
      {
         if ( (e.getClickCount() == 2) &&  (SwingUtilities.isRightMouseButton (e)))
         {
            removeButton_actionPerformed (null);
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e) { }
   }

}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.118.2.1 $
 */
class PEVariable_addButton_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEVariable adaptee;


   /**
    * Constructor for class PEVariable_addButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEVariable_addButton_actionAdapter (PEVariable adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.addButton_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.118.2.1 $
 */
class PEVariable_removeButton_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEVariable adaptee;


   /**
    * Constructor for class PEVariable_removeButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEVariable_removeButton_actionAdapter (PEVariable adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.removeButton_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.118.2.1 $
 */
class PEVariable_modifyButton_actionAdapter implements java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEVariable adaptee;


   /**
    * Constructor for class PEVariable_modifyButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEVariable_modifyButton_actionAdapter (PEVariable adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.modifyButton_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.118.2.1 $
 */
class PEVariableSelection extends PETypeSelection
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEVariable variableEditor;


   /**
    * Constructor for class PEVariableSelection
    *
    * @param parent  No description provided
    */
   PEVariableSelection (PropertyEditor parent)
   {
      super (parent, "String");
      getDest().setHeader ("Attributes");
      variableEditor = (PEVariable) parent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type  No description provided
    * @return      No description provided
    */
   protected boolean filter (UMLType type)
   {
      if (type instanceof UMLBaseTypes)
      {
         return true;
      }
      else
      {
         return true;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void destSelectionChanged()
   {
      ASGElement umlIncr = destination.getSelectedIncrement();
      if (umlIncr instanceof UMLAttr)
      {
         UMLAttr umlAttr = (UMLAttr) umlIncr;

         variableEditor.setPropertyName (umlAttr.getName());
         variableEditor.setFinalModifier (umlAttr.isFinal());
         variableEditor.setStaticModifier (umlAttr.isUmlStatic());
         variableEditor.setTransientModifier (umlAttr.isTransient());
         variableEditor.setInitialValue (umlAttr.getInitialValue());
         variableEditor.setUmlVisibilityChoice (umlAttr.getVisibility());
         variableEditor.setCreateAccessMethods (umlAttr.getCreateAccessMethods());
         variableEditor.setPointer (umlAttr.isPointer());

         source.selectIncrement ((UMLIncrement) umlAttr.getAttrType());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void fillDestList()
   {
      clearDest();
      ASGElement incr = getIncrement();
      if (incr instanceof UMLClass)
      {
         Iterator iter =  ((UMLClass) incr).iteratorOfAttrs();
         UMLAttr umlAttr;
         while (iter.hasNext())
         {
            umlAttr = (UMLAttr) iter.next();
            if (umlAttr != null)
            {
               addToDest (umlAttr);
            }
         }
      }
   }

}

/*
 * $Log: PEVariable.java,v $
 * Revision 1.118.2.1  2006/08/14 11:02:41  cschneid
 * initial selection in Attribute and Parameter Editor is "String" now
 *
 */
