/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.33 $
 */
public class StateActivityPanel extends ActivityPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static int stateCount = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   SetListModel setListModel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField stateNameTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField entryEventTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField doEventTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField exitEventTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox deferredEventsComboBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JList deferredEventsList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton addButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JButton removeButton;


   /**
    * Constructor for class StateActivityPanel
    *
    * @param asgElement  No description provided
    */
   public StateActivityPanel (ASGElement asgElement)
   {
      setAsgElement (asgElement);

      if (isResponsible())
      {
         GridBagLayout gridBag = new GridBagLayout();
         GridBagConstraints constraints = new GridBagConstraints();
         setLayout (gridBag);

         constraints.gridwidth = GridBagConstraints.REMAINDER;
         constraints.fill = GridBagConstraints.BOTH;
         constraints.weightx = 1.0;

         JLabel nameLabel = new JLabel ("State name");
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (nameLabel, constraints);
         add (nameLabel);

         stateNameTextField = new JTextField();
         gridBag.setConstraints (stateNameTextField, constraints);
         add (stateNameTextField);

         JLabel entryLabel = new JLabel ("Entry event");
         constraints.insets = new Insets (8, 3, 0, 3);
         gridBag.setConstraints (entryLabel, constraints);
         add (entryLabel);

         entryEventTextField = new JTextField();
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (entryEventTextField, constraints);
         add (entryEventTextField);

         JLabel doLabel = new JLabel ("Do event");
         constraints.insets = new Insets (8, 3, 0, 3);
         gridBag.setConstraints (doLabel, constraints);
         add (doLabel);

         doEventTextField = new JTextField();
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (doEventTextField, constraints);
         add (doEventTextField);

         JLabel exitLabel = new JLabel ("Exit event");
         constraints.insets = new Insets (8, 3, 0, 3);
         gridBag.setConstraints (exitLabel, constraints);
         add (exitLabel);

         exitEventTextField = new JTextField();
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (exitEventTextField, constraints);
         add (exitEventTextField);

         JLabel deferredLabel = new JLabel ("Deferred events");
         constraints.insets = new Insets (8, 3, 0, 3);
         gridBag.setConstraints (deferredLabel, constraints);
         add (deferredLabel);

         deferredEventsComboBox = new JComboBox();
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (deferredEventsComboBox, constraints);
         add (deferredEventsComboBox);

         if (getAsgElement() instanceof UMLActivityDiagram ||
             (getAsgElement() instanceof ViewDiagram &&  ((ViewDiagram) getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram))
         {
            setListModel = new SetListModel();
         }
         else if (getAsgElement() instanceof UMLComplexState)
         {
            UMLComplexState complexState = (UMLComplexState) getAsgElement();
            setListModel = new SetListModel (complexState.getDeferredEvents());
         }
         deferredEventsList = new JList (setListModel);
         deferredEventsList.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
         // *INDENT-OFF*
         deferredEventsList.addListSelectionListener (
            new ListSelectionListener()
            {
               public void valueChanged (ListSelectionEvent e)
               {
                  if (deferredEventsList.isSelectionEmpty())
                  {
                     removeButton.setEnabled (false);
                  }
                  else
                  {
                     removeButton.setEnabled (true);
                  }
               }
            });
         // *INDENT-ON*

         JScrollPane scrollPane = new JScrollPane (deferredEventsList);
         constraints.weighty = 1.0;
         gridBag.setConstraints (scrollPane, constraints);
         add (scrollPane);

         JPanel buttonPanel = new JPanel();
         buttonPanel.setLayout (new FlowLayout());

         addButton = new JButton ("Add");
         addButton.addActionListener (
            new ActionListener()
            {
               public void actionPerformed (ActionEvent e)
               {
                  setListModel.addElement (deferredEventsComboBox.getSelectedItem());
               }
            });

         buttonPanel.add (addButton);

         removeButton = new JButton ("Remove");
         removeButton.setEnabled (false);
         removeButton.addActionListener (
            new ActionListener()
            {
               public void actionPerformed (ActionEvent e)
               {
                  setListModel.removeElement (deferredEventsList.getSelectedValue());
               }
            });

         buttonPanel.add (removeButton);
         constraints.weighty = 0.0;
         gridBag.setConstraints (buttonPanel, constraints);
         add (buttonPanel);
      }
   } // constructor


   /**
    * Get the name attribute of the StateActivityPanel object
    *
    * @return   The name value
    */
   public String getName()
   {
      return "State";
   } // getName


   /**
    * Get the responsible attribute of the StateActivityPanel object
    *
    * @return   The responsible value
    */
   public boolean isResponsible()
   {
      return  ( (getAsgElement() instanceof UMLComplexState) ||
          (getAsgElement() instanceof UMLActivityDiagram) ||
          (getAsgElement() instanceof ViewDiagram &&  ((ViewDiagram) getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram));
   } // isResponsible


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      ASGElement asgElement = getAsgElement();

      if (asgElement instanceof UMLActivityDiagram ||
          (asgElement instanceof ViewDiagram &&  ((ViewDiagram) asgElement).getOriginalDiagram() instanceof UMLActivityDiagram))
      {
         // init. the value
         stateNameTextField.setText ("state" + stateCount);
         stateCount++;
      }
      else if (asgElement instanceof UMLComplexState)
      {
         // edit an existing State
         UMLComplexState state = (UMLComplexState) asgElement;
         if (state != null)
         {
            stateNameTextField.setText (state.getName());
            entryEventTextField.setText (state.getEntryAction());
            doEventTextField.setText (state.getDoAction());
            exitEventTextField.setText (state.getExitAction());

            Iterator iter = state.iteratorOfDeferredEvents();
            while (iter.hasNext())
            {
               setListModel.addElement (iter.next());
            }
         }
      }

      fillDeferredEventsComboBox();
   } // unparse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public UMLActivity parse()
   {
      ASGElement asgElement = getAsgElement();
      UMLComplexState complexState = null;

      if (asgElement instanceof UMLActivityDiagram ||
          (asgElement instanceof ViewDiagram &&  ((ViewDiagram) asgElement).getOriginalDiagram() instanceof UMLActivityDiagram))
      {
         UMLDiagram diag = (UMLDiagram) asgElement;

         // diag must be a UMLActivityDiagram
         if (! (diag instanceof UMLActivityDiagram))
         {
            return null;
         }
         else if (diag instanceof ViewDiagram)
         {
            ViewDiagram viewDiag = (ViewDiagram) diag;
            if (viewDiag.getOriginalDiagram() instanceof UMLActivityDiagram)
            {
               return null;
            }
         }

         // create a new UMLComplexState
         complexState = new UMLComplexState();
         UMLActivityDiagram subDiag = new UMLActivityDiagram();
         writeAttributesToState (complexState);
         diag.addToElements (complexState);
         complexState.addToContains (subDiag);
      }
      if (asgElement instanceof UMLComplexState)
      {
         complexState = (UMLComplexState) asgElement;
         writeAttributesToState (complexState);
      }
      return complexState;
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param state  No description provided
    */
   private void writeAttributesToState (UMLComplexState state)
   {
      state.setName (stateNameTextField.getText());

      // Forward name to contained diagrams.
      Iterator containsIter = state.iteratorOfContains();
      while (containsIter.hasNext())
      {
          ((UMLActivityDiagram) containsIter.next())
            .setName (stateNameTextField.getText());
      }

      state.setEntryAction (entryEventTextField.getText());
      state.setDoAction (doEventTextField.getText());
      state.setExitAction (exitEventTextField.getText());

      state.removeAllFromDeferredEvents();
      for (int i = 0; i < setListModel.getSize(); i++)
      {
         state.addToDeferredEvents ((String) setListModel.getElementAt (i));
      }
   } // writeAttributesToState


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void fillDeferredEventsComboBox()
   {
      ASGElement asgElement = getAsgElement();
      UMLActivityDiagram activityDiagram = null;

      if (asgElement instanceof UMLActivityDiagram)
      {
         activityDiagram = (UMLActivityDiagram) asgElement;
      }
      else if (asgElement instanceof UMLComplexState)
      {
         activityDiagram =  ((UMLComplexState) asgElement).getActivityDiagram();
      }
      else if (asgElement instanceof ViewDiagram &&  ((ViewDiagram) asgElement).getOriginalDiagram() instanceof UMLActivityDiagram)
      {
         activityDiagram = (UMLActivityDiagram)  ((ViewDiagram) asgElement).getOriginalDiagram();
      }

      if (activityDiagram != null)
      {
         UMLActivityDiagram tmpActDiagram = activityDiagram.findActivityDiagramOfMasterState();
         if (tmpActDiagram != null)
         {
            UMLStartActivity umlStartActivity = tmpActDiagram.getStartActivity();
            if (umlStartActivity != null)
            {
               UMLClass umlClass = umlStartActivity.getRevStartOfStateChart();
               if (umlClass != null)
               {
                  UMLMethod umlMethod;
                  Iterator iter = umlClass.iteratorOfMethods();
                  while (iter.hasNext())
                  {
                     umlMethod = (UMLMethod) iter.next();
                     if (umlMethod.isSignal())
                     {
                        deferredEventsComboBox.addItem (umlMethod.getName());
                     }
                  }
               }
            }
         }
      }
   } // fillDeferredEventsComboBox


   // -------------------------------- some inner classes ---------------------------------

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.33 $
    */
   private class SetListModel extends AbstractListModel
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Vector elements;


      /**
       * Constructor for class SetListModel
       */
      public SetListModel()
      {
         elements = new Vector();
      }


      /**
       * Constructor for class SetListModel
       *
       * @param set  No description provided
       */
      public SetListModel (Set set)
      {
         elements = new Vector();
         if (set != null)
         {
            elements.addAll (set);
         }
      }


      /**
       * Get the elementAt attribute of the SetListModel object
       *
       * @param index  No description provided
       * @return       The elementAt value
       */
      public Object getElementAt (int index)
      {
         return elements.elementAt (index);
      } // getElementAt


      /**
       * Get the size attribute of the SetListModel object
       *
       * @return   The size value
       */
      public int getSize()
      {
         return elements.size();
      } // getSize


      /**
       * Access method for an one to n association.
       *
       * @param object  The object added.
       */
      public void addElement (Object object)
      {
         if (!elements.contains (object))
         {
            elements.addElement (object);
            fireContentsChanged (this, elements.size() - 1, elements.size());
         }
         deferredEventsList.clearSelection();
      } // addElement


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param object  No description provided
       */
      public void removeElement (Object object)
      {
         elements.remove (object);
         fireContentsChanged (this, 0, elements.size());
         deferredEventsList.clearSelection();
      } // removeElement

   } // SetListModel

}

/*
 * $Log: StateActivityPanel.java,v $
 * Revision 1.33  2005/01/27 15:44:47  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
