/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui.comp;

import javax.swing.*;

import de.uni_paderborn.fujaba.metamodel.FDeclaration;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class VisibilityComboBox extends JComboBox
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String PRIVATE = "private";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String PUBLIC = "public";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String PROTECTED = "protected";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String PACKAGE = "package";


   /**
    * Constructor for class VisibilityComboBox
    */
   public VisibilityComboBox()
   {
      this.addItem (PRIVATE);
      this.addItem (PUBLIC);
      this.addItem (PROTECTED);
      this.addItem (PACKAGE);
   }


   /**
    * @return   the UML-constant of the currently selected item (UMLIncrement.PRIVATE, UMLIncrement.PUBLIC,
    *      UMLIncrement.PROTECTED, UMLIncrement.PACKAGE)
    */
   public int getUmlSelectedIndex()
   {
      Object selectedItem = this.getSelectedItem();

      if (selectedItem == PUBLIC)
      {
         return FDeclaration.PUBLIC;
      }
      else if (selectedItem == PROTECTED)
      {
         return FDeclaration.PROTECTED;
      }
      else if (selectedItem == PACKAGE)
      {
         return FDeclaration.PACKAGE;
      }
      return FDeclaration.PRIVATE;
   }


   /**
    * @param index
    */
   public void setUmlSelectedIndex (int index)
   {
      switch (index)
      {
         case FDeclaration.PUBLIC:
            this.setSelectedItem (PUBLIC);
            break;
         case FDeclaration.PROTECTED:
            this.setSelectedItem (PROTECTED);
            break;
         case FDeclaration.PACKAGE:
            this.setSelectedItem (PACKAGE);
            break;
         default:
            this.setSelectedItem (PRIVATE);
            break;
      }
   }
}

/*
 * $Log: VisibilityComboBox.java,v $
 * Revision 1.11  2004/10/20 19:51:21  schneider
 * fixed doubled constants - UMLDeclarationInterface deprecated
 *
 */
