/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.io.*;

import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.18.2.1 $
 */
public class GXLHandler extends DefaultHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (GXLHandler.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DTD_DIR = "DTDs";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param publicId       No description provided
    * @param systemId       No description provided
    * @return               No description provided
    * @throws SAXException  Exception description not provided
    */
   public InputSource resolveEntity (String publicId, String systemId) throws SAXException
   {
      String baseWWW1 = "http://www.upb.de/cs/fujaba/DTDs";
      String baseWWW2 = "http://www.uni-paderborn.de/cs/fujaba/DTDs";
      if (log.isInfoEnabled())
      {
         log.info ("resolve " + publicId + ":" + systemId);
      }
      if (systemId.startsWith (baseWWW1))
      {
         try
         {
            String base = systemId.substring (baseWWW1.length());
            InputStream stylesheetStream = UPBClassLoader.get().getResourceAsStream (DTD_DIR + base);
            BufferedReader br = new BufferedReader (new InputStreamReader (stylesheetStream));
            return new InputSource (br);
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
      }
      else if (systemId.startsWith (baseWWW2))
      {
         try
         {
            String base = systemId.substring (baseWWW2.length());
            InputStream stylesheetStream = UPBClassLoader.get().getResourceAsStream (DTD_DIR + base);
            BufferedReader br = new BufferedReader (new InputStreamReader (stylesheetStream));
            return new InputSource (br);
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
      }

      try
      {
         return super.resolveEntity (publicId, systemId);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         return null;
      }
   }
}

/*
 * $Log: GXLHandler.java,v $
 * Revision 1.18.2.1  2005/09/30 18:57:22  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
