/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.util.Iterator;

import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.uml.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.8 $
 */
public class UMLActivityDiagramFilter extends Filter
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   public boolean verifyObject (BasicIncrement vObject)
   {
      if (vObject instanceof UMLActivityDiagram)
      {
         return verifyUMLActivityDiagram ((UMLActivityDiagram) vObject);
      }
      else
      {
         if (vObject instanceof UMLAttrExprPair)
         {
            return verifyUMLAttrExprPair ((UMLAttrExprPair) vObject);
         }
         else
         {
            if (vObject instanceof UMLClass)
            {
               return verifyUMLClass ((UMLClass) vObject);
            }
            else
            {
               if (vObject instanceof UMLComplexState)
               {
                  return verifyUMLComplexState ((UMLComplexState) vObject);
               }
               else
               {
                  if (vObject instanceof UMLLink)
                  {
                     return verifyUMLLink ((UMLLink) vObject);
                  }
                  else
                  {
                     if (vObject instanceof UMLMethod)
                     {
                        return verifyUMLMethod ((UMLMethod) vObject);
                     }
                     else
                     {
                        if (vObject instanceof UMLObject)
                        {
                           return verifyUMLObject ((UMLObject) vObject);
                        }
                        else
                        {
                           if (vObject instanceof UMLParam)
                           {
                              return verifyUMLParam ((UMLParam) vObject);
                           }
                           else
                           {
                              if (vObject instanceof UMLProject)
                              {
                                 return verifyUMLProject ((UMLProject) vObject);
                              }
                              else
                              {
                                 if (vObject instanceof UMLStartActivity)
                                 {
                                    return verifyUMLStartActivity ((UMLStartActivity) vObject);
                                 }
                                 else
                                 {
                                    if (vObject instanceof UMLStatement)
                                    {
                                       return verifyUMLStatement ((UMLStatement) vObject);
                                    }
                                    else
                                    {
                                       if (vObject instanceof UMLStoryPattern)
                                       {
                                          return verifyUMLStoryPattern ((UMLStoryPattern) vObject);
                                       }
                                       else
                                       {
                                          if (vObject instanceof UMLStoryActivity)
                                          {
                                             return verifyUMLStoryActivity ((UMLStoryActivity) vObject);
                                          }
                                          else
                                          {
                                             if (vObject instanceof UMLTransition)
                                             {
                                                return verifyUMLTransition ((UMLTransition) vObject);
                                             }
                                             else
                                             {
                                                if (vObject instanceof UMLTransitionGuard)
                                                {
                                                   return verifyUMLTransitionGuard ((UMLTransitionGuard) vObject);
                                                }
                                                else
                                                {
                                                   if (vObject instanceof UMLType)
                                                   {
                                                      return verifyUMLType ((UMLType) vObject);
                                                   }
                                                   else
                                                   {
                                                      if (vObject instanceof UMLDiagramItem)
                                                      {
                                                         return verifyUMLDiagramItem ((UMLDiagramItem) vObject);
                                                      }

                                                   }
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLActivityDiagram (UMLActivityDiagram vObject)
   {
      if (vObject.equals (GXLFilter.root))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLProject (UMLProject vObject)
   {
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLType (UMLType vObject)
   {
      Iterator iter = vObject.iteratorOfRevResultType();

      while (iter.hasNext())
      {
         UMLMethod tmpMethod =  ((UMLMethod) iter.next());
         UMLDiagramItem rootItem = tmpMethod.getRevSpec();

         if (GXLFilter.hasInItems (rootItem))
         {
            return true;
         }

         Iterator iter2 = vObject.iteratorOfRevParamType();

         while (iter2.hasNext())
         {
            UMLParam tmpParam = (UMLParam) iter2.next();
            tmpMethod = tmpParam.getRevParam();
            rootItem = tmpMethod.getRevSpec();

            if (GXLFilter.hasInItems (rootItem))
            {
               return true;
            }
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLStartActivity (UMLStartActivity vObject)
   {
      if (GXLFilter.hasInItems (vObject))
      {
         UMLClass tmpClass = vObject.getSpecClass();
         Iterator iter = tmpClass.iteratorOfDiagrams();

         while (iter.hasNext())
         {
            Object tmpObject = iter.next();
            if (tmpObject != GXLFilter.getRoot())
            {
               if (GXLFilter.getInclude() && GXLFilter.getFirstSelected() && !GXLFilter.hasInAddDiagrams ((UMLDiagram) tmpObject) && !GXLFilter.hasInSavedDiagrams ((UMLDiagram) tmpObject))
               {
                  GXLFilter.addToAddDiagrams ((UMLDiagram) tmpObject);
               }
            }
         }
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLTransition (UMLTransition vObject)
   {
      UMLDiagramItem rootItem = vObject.getRevEntry();

      if (rootItem != null)
      {
         if (GXLFilter.hasInItems (rootItem))
         {
            return true;
         }
      }
      else
      {
         rootItem = vObject.getRevExit();
         if (rootItem != null)
         {
            if (!GXLFilter.hasInItems (rootItem))
            {
               return true;
            }
         }
      }

      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLMethod (UMLMethod vObject)
   {
      UMLDiagramItem rootItem = vObject.getRevSpec();

      if (GXLFilter.hasInItems (rootItem))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLClass (UMLClass vObject)
   {
      UMLDiagramItem rootItem = vObject.getStartOfStateChart();

      if (GXLFilter.hasInItems (rootItem))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLObject (UMLObject vObject)
   {
      UMLDiagramItem rootItem = vObject.getRevReturnParam();
      if (GXLFilter.hasInItems (rootItem))
      {
         return true;
      }

      Iterator iter = vObject.iteratorOfDiagrams();
      while (iter.hasNext())
      {
         UMLDiagram tmpDiagram = (UMLDiagram) iter.next();
         if (tmpDiagram instanceof UMLStoryPattern)
         {
            UMLStoryActivity tmpActivity =  ((UMLStoryPattern) tmpDiagram).getRevStoryPattern();
            if (GXLFilter.hasInItems (tmpActivity))
            {
               return true;
            }
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLStatement (UMLStatement vObject)
   {
      UMLDiagramItem rootItem = vObject.getActivity();

      if (GXLFilter.hasInItems (rootItem))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLTransitionGuard (UMLTransitionGuard vObject)
   {
      UMLDiagramItem rootItem = vObject.getRevGuard().getRevEntry();
      if (GXLFilter.hasInItems (rootItem))
      {
         return true;
      }

      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLComplexState (UMLComplexState vObject)
   {
      if (GXLFilter.hasInItems (vObject))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLStoryActivity (UMLStoryActivity vObject)
   {
      if (GXLFilter.hasInItems (vObject))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLLink (UMLLink vObject)
   {
      Iterator iter = vObject.iteratorOfDiagrams();
      while (iter.hasNext())
      {
         UMLDiagram tmpDiagram = (UMLDiagram) iter.next();
         if (tmpDiagram instanceof UMLStoryPattern)
         {
            UMLStoryActivity tmpActivity =  ((UMLStoryPattern) tmpDiagram).getRevStoryPattern();
            if (GXLFilter.hasInItems (tmpActivity))
            {
               return true;
            }
         }

      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLAttrExprPair (UMLAttrExprPair vObject)
   {
      UMLObject tmpObject = vObject.getRevAttrs();

      UMLDiagramItem rootItem = tmpObject.getRevReturnParam();
      if (GXLFilter.hasInItems (rootItem))
      {
         return true;
      }

      Iterator iter = tmpObject.iteratorOfDiagrams();

      while (iter.hasNext())
      {
         UMLDiagram tmpDiagram = (UMLDiagram) iter.next();

         if (tmpDiagram instanceof UMLStoryPattern)
         {
            UMLStoryActivity tmpActivity =  ((UMLStoryPattern) tmpDiagram).getRevStoryPattern();
            if (GXLFilter.hasInItems (tmpActivity))
            {
               return true;
            }
         }
      }

      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLDiagramItem (UMLDiagramItem vObject)
   {
      if (GXLFilter.hasInItems (vObject))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLParam (UMLParam vObject)
   {
      UMLDiagramItem rootItem = vObject.getRevParam().getRevSpec();
      if (GXLFilter.hasInItems (rootItem))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param vObject  No description provided
    * @return         No description provided
    */
   private boolean verifyUMLStoryPattern (UMLStoryPattern vObject)
   {
      UMLStoryActivity tmpActivity = vObject.getRevStoryPattern();
      if (GXLFilter.hasInItems (tmpActivity))
      {
         return true;
      }
      return false;
   }

}

/*
 * $Log: UMLActivityDiagramFilter.java,v $
 * Revision 1.8  2004/10/22 16:41:39  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
