/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.layout.options;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.layout.MrLayout;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;


/**
 * Options panel for the environment dialog.
 *
 *
 * @author    $Author: joerg $
 * @version   $Revision: 1.9 $
 */
public class LayoutPreferencesPanel extends PreferencesPanel
{
   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JCheckBox collapseClassesCheckBox;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JCheckBox showRoleNamesCheckBox;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JComboBox defaultLayoutComboBox;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JComboBox activityDiagramComboBox;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JTextField horizontalDistanceTextField;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JTextField verticalDistanceTextField;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JTextField iterationsTextField;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JTextField stretchFactorTextField;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   private JTextField minimumWidthTextField;


   /**
    * Constructor for class LayoutPreferencesPanel
    */
   public LayoutPreferencesPanel()
   {
      setLayout (new BorderLayout());

      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (gridBagLayout);

      // add display panel
      JPanel displayPanel = createDisplayPanel();
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.weightx = 1;
      mainPanel.add (displayPanel, constraints);

      // add parameter panel
      JPanel algorithmPanel = createAlgorithmPanel();
      mainPanel.add (algorithmPanel, constraints);

      // add parameter panel
      JPanel parameterPanel = createParameterPanel();
      mainPanel.add (parameterPanel, constraints);

      add (mainPanel, BorderLayout.NORTH);
   } // constructor


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    *
    * @return   No description provided
    */
   private JPanel createDisplayPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("UML Class Diagram"));
      panel.setLayout (gridBagLayout);

      // Collapse classes initially
      collapseClassesCheckBox = new JCheckBox (
         "Collapse Attributes and Methods Compartments of UML Classes Initially");
      collapseClassesCheckBox.setToolTipText ("Classes will be displayed with hidden attributes and methods.");
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (3, 3, 3, 3);
      panel.add (collapseClassesCheckBox, constraints);

      showRoleNamesCheckBox = new JCheckBox ("Show Association Role Names");
      showRoleNamesCheckBox.setToolTipText ("For this setting to take effect the current project must be reloaded!");
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.weightx = 1.0;
      panel.add (showRoleNamesCheckBox, constraints);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    *
    * @return   No description provided
    */
   private JPanel createAlgorithmPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Algorithms"));
      panel.setLayout (gridBagLayout);

      // default layout algorithm
      JLabel defaultLayoutLabel = new JLabel ("Default Layout:");
      constraints.fill = GridBagConstraints.NONE;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.gridwidth = 1;
      panel.add (defaultLayoutLabel, constraints);

      defaultLayoutComboBox = new JComboBox();
      defaultLayoutComboBox.setToolTipText ("The default layout algorithm for diagrams.");
      constraints.fill = GridBagConstraints.BOTH;
      constraints.insets = new Insets (3, 0, 3, 3);
      panel.add (defaultLayoutComboBox, constraints);

      // dummy element
      JLabel dummyLabel = new JLabel();
      constraints.fill = GridBagConstraints.BOTH;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.weightx = 1;
      panel.add (dummyLabel, constraints);

      // activity diagram layout algorithm
      JLabel activityDiagramLayoutLabel = new JLabel ("Activity Diagram Layout:");
      constraints.fill = GridBagConstraints.NONE;
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.gridwidth = 1;
      constraints.weightx = 0;
      panel.add (activityDiagramLayoutLabel, constraints);

      activityDiagramComboBox = new JComboBox();
      activityDiagramComboBox.setToolTipText ("The layout algorithm for activity diagrams.");
      constraints.fill = GridBagConstraints.BOTH;
      constraints.insets = new Insets (0, 0, 3, 3);
      panel.add (activityDiagramComboBox, constraints);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    *
    * @return   No description provided
    */
   private JPanel createParameterPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Parameter"));
      panel.setLayout (gridBagLayout);

      // horizontal distance
      JLabel horizontalDistanceLabel = new JLabel ("Horizontal Distance:");
      constraints.fill = GridBagConstraints.NONE;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (3, 3, 3, 3);
      panel.add (horizontalDistanceLabel, constraints);

      horizontalDistanceTextField = new JTextField (10);
      horizontalDistanceTextField.setToolTipText ("Horizontal distance between layout elements.");
      horizontalDistanceTextField.setInputVerifier (new IntegerInputVerifier());
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.insets = new Insets (3, 0, 3, 3);
      constraints.weightx = 1;
      panel.add (horizontalDistanceTextField, constraints);

      // vertical distance
      JLabel verticalDistanceLabel = new JLabel ("Vertical Distance:");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.gridwidth = 1;
      constraints.weightx = 0;
      panel.add (verticalDistanceLabel, constraints);

      verticalDistanceTextField = new JTextField (10);
      verticalDistanceTextField.setToolTipText ("Vertical distance between layout elements.");
      verticalDistanceTextField.setInputVerifier (new IntegerInputVerifier());
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.insets = new Insets (0, 0, 3, 3);
      constraints.weightx = 1;
      panel.add (verticalDistanceTextField, constraints);

      // minimum width [ak]
      JLabel minimumWidthLabel = new JLabel ("Minimum Width:");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.gridwidth = 1;
      constraints.weightx = 0;
      panel.add (minimumWidthLabel, constraints);

      minimumWidthTextField = new JTextField (10);
      minimumWidthTextField.setToolTipText ("Minimum width of classes and objects.");
      minimumWidthTextField.setInputVerifier (new IntegerInputVerifier());
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.insets = new Insets (0, 0, 3, 3);
      constraints.weightx = 1;
      panel.add (minimumWidthTextField, constraints);

      // iterations
      JLabel iterationsLabel = new JLabel ("Iterations for Spring Embedder:");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.gridwidth = 1;
      constraints.weightx = 0;
      panel.add (iterationsLabel, constraints);

      iterationsTextField = new JTextField (10);
      iterationsTextField.setToolTipText ("Iterations for the spring embedder layout.");
      iterationsTextField.setInputVerifier (new IntegerInputVerifier());
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.insets = new Insets (0, 0, 3, 3);
      constraints.weightx = 1;
      panel.add (iterationsTextField, constraints);

      // stretch factor
      JLabel stretchFactorLabel = new JLabel ("Stretch Factor for Spring Embedder:");
      constraints.fill = GridBagConstraints.NONE;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.gridwidth = 1;
      constraints.weightx = 0;
      panel.add (stretchFactorLabel, constraints);

      stretchFactorTextField = new JTextField (10);
      stretchFactorTextField.setToolTipText ("Stretch factor for spring embedder layout.");
      stretchFactorTextField.setInputVerifier (new DoubleInputVerifier());
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.insets = new Insets (0, 0, 3, 3);
      constraints.weightx = 1;
      panel.add (stretchFactorTextField, constraints);

      return panel;
   }


   /**
    * Returns the preferred name of a tab for this panel
    *
    *
    * @return   The preferredTabName value
    */
   public String getPreferredTabName()
   {
      return  ("Diagram Layout");
   } // getPreferredTabName


   /**
    * Set all options to default values.
    */
   public void setDefaults()
   {
      LayoutPreferences.get().setDefaults();
      setPreferences();
   } // setDefaults


   /**
    * Set the options in the panel, because the options can have changed
    * elsewhere.
    */
   public void setPreferences()
   {
      LayoutPreferences options = LayoutPreferences.get();

      collapseClassesCheckBox.setSelected (options.isCollapseClasses());
      showRoleNamesCheckBox.setSelected (options.isShowRoleNames());

      defaultLayoutComboBox.addItem ("TreeLayout");
      defaultLayoutComboBox.addItem ("Spring Embedder");
      defaultLayoutComboBox.addItem ("Class Diagram Layout");

      activityDiagramComboBox.addItem ("TreeLayout");
      activityDiagramComboBox.addItem ("Spring Embedder");
      activityDiagramComboBox.addItem ("ControlFlowLayout");

      int index = options.getWhichLayout();

      if (index == MrLayout.CLASS_DIAGRAM_LAYOUT)
      {
         defaultLayoutComboBox.setSelectedIndex (2);
      }
      else
      {
         defaultLayoutComboBox.setSelectedIndex (index);
      }
      activityDiagramComboBox.setSelectedIndex (options.getWhichActivityDiagramLayout());

      horizontalDistanceTextField.setText (String.valueOf (options.getHorizDist()));
      verticalDistanceTextField.setText (String.valueOf (options.getVertDist()));
      minimumWidthTextField.setText (String.valueOf (options.getMinimumWidth()));
      iterationsTextField.setText (String.valueOf (options.getNumberIterations()));
      stretchFactorTextField.setText (String.valueOf (options.getStretchFactor()));
   } // setOptions


   /**
    * Get all the options from the panel and set the real options.
    */
   public void okPressed()
   {
      LayoutPreferences options = LayoutPreferences.get();

      options.setCollapseClasses (collapseClassesCheckBox.isSelected());
      options.setShowRoleNames (showRoleNamesCheckBox.isSelected());

      int index = defaultLayoutComboBox.getSelectedIndex();
      if (index == 2)
      {
         options.setWhichLayout (MrLayout.CLASS_DIAGRAM_LAYOUT);
      }
      else
      {
         options.setWhichLayout (index);
      }
      options.setWhichActivityDiagramLayout (activityDiagramComboBox.getSelectedIndex());

      options.setHorizDist (horizontalDistanceTextField.getText());
      options.setVertDist (verticalDistanceTextField.getText());
      options.setMinimumWidth (minimumWidthTextField.getText());
      options.setNumberIterations (iterationsTextField.getText());
      options.setStretchFactor (stretchFactorTextField.getText());
   } // okPressed


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    *
    * @author    $Author: joerg $
    * @version   $Revision: 1.9 $
    */
   private class IntegerInputVerifier extends InputVerifier
   {
      /**
       * @param component             No description provided
       * @return           No description provided
       * @see              javax.swing.InputVerifier#verify(javax.swing.JComponent)
       */
      public boolean verify (JComponent component)
      {
         boolean result = false;
         JTextField textField = (JTextField) component;

         try
         {
            Integer.valueOf (textField.getText());
            result = true;
         }
         catch (NumberFormatException e)
         {
         }

         return result;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    *
    * @author    $Author: joerg $
    * @version   $Revision: 1.9 $
    */
   private class DoubleInputVerifier extends InputVerifier
   {
      /**
       * @param component             No description provided
       * @return           No description provided
       * @see              javax.swing.InputVerifier#verify(javax.swing.JComponent)
       */
      public boolean verify (JComponent component)
      {
         boolean result = false;
         JTextField textField = (JTextField) component;

         try
         {
            Double.valueOf (textField.getText());
            result = true;
         }
         catch (NumberFormatException e)
         {
         }

         return result;
      }
   }
}

/*
 * $Log: LayoutPreferencesPanel.java,v $
 * Revision 1.9  2005/01/24 12:30:51  joerg
 * started new layout algoritm for class diagrams
 *
 */
