/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $ $Date: 2004/10/22 16:41:45 $
 */
public interface FAttr extends FDeclaration
{
   // --- Property static ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STATIC_PROPERTY = "static";


   /**
    * Get the static attribute of the FAttr object
    *
    * @return   The static value
    */
   public abstract boolean isStatic();


   /**
    * Set the static attribute of the FAttr object
    *
    * @param value  The new static value
    */
   public abstract void setStatic (boolean value);

   // --- Property initialValue ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INITIAL_VALUE_PROPERTY = "initialValue";


   /**
    * Get the initialValue attribute of the FAttr object
    *
    * @return   The initialValue value
    */
   public abstract String getInitialValue();


   /**
    * Sets the initialValue attribute of the FAttr object
    *
    * @param initialValue  The new initialValue value
    */
   public abstract void setInitialValue (String initialValue);

   // --- Property parent ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PARENT_PROPERTY = "parent";


   /**
    * Sets the parent attribute of the FAttr object
    *
    * @param obj  The new parent value
    * @return     No description provided
    */
   public abstract boolean setParent (FClass obj);


   /**
    * Get the parent attribute of the FAttr object
    *
    * @return   The parent value
    */
   public abstract FClass getFParent();

   // --- Property revQualifiedAttr ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_QUALIFIED_ATTR = "revQualifiedAttr";


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInRevQualifiedAttr (FQualifier value);


   /**
    * @return   No description provided
    */
   public abstract Iterator iteratorOfRevQualifiedAttr();


   /**
    * @return   No description provided
    */
   public abstract int sizeOfRevQualifiedAttr();


   /**
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToRevQualifiedAttr (FQualifier value);


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromRevQualifiedAttr (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromRevQualifiedAttr();

   // --- Property attrType ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ATTR_TYPE_PROPERTY = "attrType";


   /**
    * Get the attrType attribute of the FAttr object
    *
    * @return   The attrType value
    */
   public abstract FType getFAttrType();


   /**
    * Sets the attrType attribute of the FAttr object
    *
    * @param attrType  The new attrType value
    */
   public abstract void setAttrType (FType attrType);

   // --- Deprecated methods ---
   /**
    * @return       The needsAccessMethods value
    * @deprecated
    */
   public abstract boolean isNeedsAccessMethods();


   /**
    * @return       The final value
    * @deprecated   Use stereotype <<final>>
    */
   public abstract boolean isFinal();


   /**
    * @param value  The new final value
    * @deprecated   Use stereotype <<final>>
    */
   public abstract void setFinal (boolean value);


   /**
    * @return       The transient value
    * @deprecated   Use stereotype <
    *      <transient>
    *        >
    */
   public abstract boolean isTransient();


   /**
    * @param value  The new transient value
    * @deprecated   Use stereotype <
    *      <transient>
    *        >
    */
   public abstract void setTransient (boolean value);


   /**
    * @return       The fImplementingAssocRole value
    * @deprecated
    */
   public abstract FRole getFImplementingAssocRole();


   /**
    * @param role   The new implementingAssocRole value
    * @return       No description provided
    * @deprecated
    */
   public abstract boolean setImplementingAssocRole (FRole role);


   /**
    * @return       No description provided
    * @deprecated
    */
   public abstract Iterator iteratorOfAccessMethods();
}

/*
 * $Log: FAttr.java,v $
 * Revision 1.2  2004/10/22 16:41:45  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
