/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $ $Date: 2004/10/22 16:41:45 $
 */
public interface FConnection extends FDiagramItem
{

   // --- Deprecated methods ---
   /**
    * access method for the source object of the edge
    *
    * @param item   the new source object
    * @return       true if the source object was changed, false otherwise
    * @deprecated
    */
   public abstract boolean setSourceConnector (FDiagramItem item);


   /**
    * access method for the source object of the edge
    *
    * @return       the source object of the edge
    * @deprecated
    */
   public abstract FDiagramItem getFSourceConnector();


   /**
    * access method for the target object of the edge
    *
    * @param item   the new target object
    * @return       true if the target object was changed, false otherwise
    * @deprecated
    */
   public abstract boolean setTargetConnector (FDiagramItem item);


   /**
    * access method for the target object of the edge
    *
    * @return       the target object of the edge
    * @deprecated
    */
   public abstract FDiagramItem getFTargetConnector();


   /**
    * Gets the partner of the item<p>
    *
    * That is sourceConnector if item is targetConnector or targetConnector if the item is
    * sourceConnector<p>
    *
    * If item is none of these an Exception is thrown.
    *
    * @param item                                 No description provided
    * @return                                     the partner of the item
    * @throws java.lang.IllegalArgumentException  if item is not one of sourceConnector or
    *      targetConnector
    * @see                                        #setPartner
    * @deprecated
    */
   public abstract FDiagramItem getFPartner (FDiagramItem item);


   /**
    * Sets the partner of the item<p>
    *
    * That is sourceConnector if item is targetConnector or targetConnector if the item is
    * sourceConnector<p>
    *
    * If item is none of these an Exception is thrown.
    *
    * @param item                                 The new partner value
    * @param partner                              The new partner value
    * @return                                     true if the partner was changed
    * @throws java.lang.IllegalArgumentException  if item is not one of sourceConnector or
    *      targetConnector
    * @see                                        #setSourceConnector(de.uni_paderborn.fujaba.metamodel.FDiagramItem)
    * @see                                        #setTargetConnector(de.uni_paderborn.fujaba.metamodel.FDiagramItem)
    * @deprecated
    */
   public abstract boolean setPartner (FDiagramItem item, FDiagramItem partner);
}

/*
 * $Log: FConnection.java,v $
 * Revision 1.2  2004/10/22 16:41:45  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
