/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.4 $ $Date: 2004/11/13 20:45:58 $
 */
public interface FDeclaration extends FDiagramItem, Cloneable
{

   // Declaration interface constants
   /**
    * indicates a declaration element as internal used element. It is not shown as default.
    */
   public final static int CODE_DISPLAY_LEVEL = 0;

   /**
    * indicates a declaration element as user element. It is shown as default.
    */
   public final static int DESIGN_DISPLAY_LEVEL = FDeclaration.CODE_DISPLAY_LEVEL + 1;

   /**
    * indicates a declaration element as a private element.
    */
   public final static int PRIVATE = 0;

   /**
    * indicates a declaration element as a public element.
    */
   public final static int PUBLIC = FDeclaration.PRIVATE + 1;

   /**
    * indicates a declaration element as a protected element.
    */
   public final static int PROTECTED = FDeclaration.PUBLIC + 1;

   /**
    * indicates a declaration element as a package element.
    */
   public final static int PACKAGE = FDeclaration.PROTECTED + 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int USERDEFINED = FDeclaration.PACKAGE + 1;

   /**
    * declares the visibility characters.
    */
   public final static char[] VISIBILITY_CHAR = new char[]
      {'-', '+', '#', '@', '!'};

   /**
    * declares the visibility strings.
    */
   public final static String[] VISIBILITY_STRING = new String[]
      {"private", "public", "protected", "/*package*/", "/*user*/"};

   // --- Property visibility ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String VISIBILITY_PROPERTY = "visibility";


   /**
    * Get the visibility attribute of the FDeclaration object
    *
    * @return   The visibility value
    */
   public abstract int getVisibility();


   /**
    * Sets the visibility attribute of the FDeclaration object
    *
    * @param visibility  The new visibility value
    */
   public abstract void setVisibility (int visibility);


   // --- Deprecated methods ---
   /**
    * returns the display level of the declaration element.
    *
    * @return   the display level.
    */
   public abstract int getDisplayLevel();


   /**
    * sets the display level of the declaration element.
    *
    * @param newDisplayLevel  the new display level.
    */
   public abstract void setDisplayLevel (int newDisplayLevel);


   /**
    * returns the type of the declaration element.
    *
    * @return       the type of the element.
    * @deprecated   Use getAttrType, getParamType, or getResultType instead
    */
   public abstract FType getFType();


   /**
    * Get the parsed attribute of the FDeclaration object
    *
    * @return   The parsed value
    */
   boolean isParsed();
}

/*
 * $Log: FDeclaration.java,v $
 * Revision 1.4  2004/11/13 20:45:58  lowende
 * PTNodes removed.
 * Old Parser will not work any more.
 * Please download new one (2.0 beta version) from plugin server.
 *
 */
