/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;

import de.uni_paderborn.fujaba.uml.ASTRootNode;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.5 $ $Date: 2005/03/04 16:05:30 $
 */
public interface FMethod extends FDeclaration
{

   // --- Property static ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STATIC_PROPERTY = "static";


   /**
    * Get the static attribute of the FMethod object
    *
    * @return   The static value
    */
   public abstract boolean isStatic();


   /**
    * Sets the static attribute of the FMethod object
    *
    * @param fStatic  The new static value
    */
   public abstract void setStatic (boolean fStatic);


   // --- Property abstract ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ABSTRACT_PROPERTY = "abstract";


   /**
    * Sets the abstract attribute of the FMethod object
    *
    * @param fAbstract  The new abstract value
    */
   public abstract void setAbstract (boolean fAbstract);


   /**
    * Get the abstract attribute of the FMethod object
    *
    * @return   The abstract value
    */
   public abstract boolean isAbstract();


   // --- Property parent ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PARENT_PROPERTY = "parent";


   /**
    * Get the parent attribute of the FMethod object
    *
    * @return   The parent value
    */
   public abstract FClass getFParent();


   /**
    * Sets the parent attribute of the FMethod object
    *
    * @param parent  The new parent value
    */
   public abstract void setParent (FClass parent);


   // --- Property resultType ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String RESULT_TYPE_PROPERTY = "resultType";


   /**
    * Sets the resultType attribute of the FMethod object
    *
    * @param value  The new resultType value
    */
   public abstract void setResultType (FType value);


   /**
    * Get the resultType attribute of the FMethod object
    *
    * @return   The resultType value
    */
   public abstract FType getFResultType();


   // --- Property declares ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DECLARES_PROPERTY = "declares";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean hasInDeclares (FClass obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean hasKeyInDeclares (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfDeclares();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator keysOfDeclares();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator entriesOfDeclares();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfDeclares();


   /**
    * Get the fromDeclares attribute of the FMethod object
    *
    * @param key  No description provided
    * @return     The fromDeclares value
    */
   public abstract FClass getFromFDeclares (String key);


   /**
    * Access method for an one to n association.
    *
    * @param obj  The object added.
    * @return     No description provided
    */
   public abstract boolean addToDeclares (FClass obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean removeFromDeclares (FClass obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean removeKeyFromDeclares (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromDeclares();


   // --- Property param ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PARAM_PROPERTY = "param";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param newParam  No description provided
    * @return          No description provided
    */
   public abstract boolean hasInParam (FParam newParam);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfParam();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfParam();


   /**
    * Access method for an one to n association.
    *
    * @param newParam  The object added.
    */
   public abstract void addToParam (FParam newParam);


   /**
    * Access method for an one to n association.
    *
    * @param index     The object added.
    * @param newParam  The object added.
    */
   public abstract void addToParam (int index, FParam newParam);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param newParam  No description provided
    */
   public abstract void removeFromParam (FParam newParam);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromParam();


   // --- Property storyDiagram
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STORY_DIAGRAM_PROPERTY = "storyDiagram";


   /**
    * Get the storyDiagram attribute of the FMethod object
    *
    * @return   The storyDiagram value
    */
   public abstract FDiagram getFStoryDiagram();

   // --- Derived properties ---

   /**
    * This function assembles the full name of the method out of the name and the signatur.
    * e. g.: getFullMethodName(), setName(String),
    *
    * @return   The fullMethodName value
    */
   public abstract String getFullMethodName();


   /**
    * Is the method a constructor
    *
    * @return   True, if the method is a constructor
    */
   public abstract boolean isConstructor();


   /**
    * Get the signal attribute of the FMethod object
    *
    * @return       The signal value
    * @deprecated   Use stereotype <<signal>>
    */
   public abstract boolean isSignal();


   /**
    * @return       The final value
    * @deprecated   Use stereotype <<final>>
    */
   public abstract boolean isFinal();


   /**
    * @param value  The new final value
    * @deprecated   Use stereotype <<final>>
    */
   public abstract void setFinal (boolean value);


   /**
    * Get the umlNative attribute of the FMethod object
    *
    * @return       The umlNative value
    * @deprecated   Use stereotype <<native>>
    */
   public abstract boolean isUmlNative();


   /**
    * Get the synchronized attribute of the FMethod object
    *
    * @return       The synchronized value
    * @deprecated   Use stereotype <<synchronized>>
    */
   public abstract boolean isSynchronized();


   /**
    * Sets the umlSynchronized attribute of the FMethod object
    *
    * @param newFSynchronized  The new umlSynchronized value
    * @deprecated              Use stereotype <<synchronized>>
    */
   public abstract void setUmlSynchronized (boolean newFSynchronized);


   /**
    * Get the uMLType attribute of the FMethod object
    *
    * @return       The uMLType value
    * @deprecated
    */
   public abstract FType getFType();


   /**
    * Get the value of resultTypeIsPointer.
    *
    * @return       Value of resultTypeIsPointer.
    * @deprecated   Use stereotype <<pointer>
    *
    *      >
    */
   public abstract boolean isResultTypeIsPointer();


   /**
    * Set the value of resultTypeIsPointer.
    *
    * @param resultTypeIsPointer  Value to assign to resultTypeIsPointer.
    * @deprecated                 Use stereotype <<pointer>
    *
    *      >
    */
   public abstract void setResultTypeIsPointer (boolean resultTypeIsPointer);


   /**
    * Get the revSpec attribute of the FMethod object TODO: Make return type a start activity
    *
    * @return       The revSpec value
    * @deprecated
    */
   public abstract FElement getFRevSpec();


   /**
    * @param startActivity  The new revSpec value
    * @deprecated
    */
   public abstract void setRevSpec (FElement startActivity);


   /**
    * Creates a new body of the method with the given text be sure the methods class is set
    * using setParent !
    *
    * @param bodyText   the body text
    * @param generated  true if the body is auto generated (e.g. from the analyzer engines)
    * @deprecated       use setMethodBody (String methodBody) instead
    */
   public abstract void setPatternMethodBody (String bodyText, boolean generated);


   /**
    * Sets the methodBody of the UMLMethod
    *
    * @param methodBody  The new methodBody value
    * @param generated   The new methodBody value
    */
   public void setMethodBody (String methodBody, boolean generated);


   /**
    * Sets the methodBody of the UMLMethod
    *
    * @param methodBody  The new methodBody value
    */
   public void setMethodBody (String methodBody);


   /**
    * Get the methodBody of the UMLMethod
    *
    * @return   The methodBody
    */
   public String getMethodBody();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return       No description provided
    * @deprecated
    */
   public abstract Iterator iteratorOfThrowsTypes();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return       No description provided
    * @deprecated
    */
   public abstract int sizeOfThrowsTypes();


   /**
    * Sets the accessedAttribute attribute of the FMethod object
    *
    * @return       No description provided
    * @deprecated
    */

   /**
    * Get the accessedAttribute attribute of the FMethod object
    *
    * @return       The accessedAttribute value
    * @deprecated
    */
   public abstract FAttr getFAccessedAttribute();


   /**
    * Set the accessedAttribute attribute of the FMethod object
    *
    * @param attr   The new accessedAttribute value
    * @return       No description provided
    * @deprecated
    */
   public abstract boolean setAccessedAttribute (FAttr attr);


   /**
    * Returns the abstract syntax tree (AST) root node of the method
    *
    * @return   The AST root node
    */
   public ASTRootNode getASTRootNode();


   /**
    * Sets the abstract syntax tree (AST) root node of the method
    *
    * @param astRootNode  The new AST root node
    */
   public void setASTRootNode (ASTRootNode astRootNode);
}

/*
 * $Log: FMethod.java,v $
 * Revision 1.5  2005/03/04 16:05:30  lowende
 * New parser interface.
 * Requires a new parser that will be deployed soon (after some tests).
 *
 */
