/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;

import de.uni_paderborn.fujaba.basic.KeyValuePair;


/**
 * @author       $Author: lowende $
 * @version      $Revision: 1.2 $ $Date: 2004/10/22 16:41:46 $
 * @deprecated
 */
public interface FTypeList extends FIncrement
{

   // Property types
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String TYPES_PROPERTY = "types";


   /**
    * Access method for an one to n association.
    *
    * @param obj  The object added.
    * @return     No description provided
    */
   public abstract boolean addToTypes (FType obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean hasInTypes (FType obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean hasKeyInTypes (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfTypes();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator keysOfTypes();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator entriesOfTypes();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfTypes();


   /**
    * Get the fromTypes attribute of the UMLTypeList object
    *
    * @param key  No description provided
    * @return     The fromTypes value
    */
   public abstract FType getFromFTypes (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public abstract boolean removeFromTypes (FType obj);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean removeKeyFromTypes (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromTypes();


   /**
    * Access method for an one to n association.
    *
    * @param pair  The object added.
    */
   public abstract void addToTypes (KeyValuePair pair);


   /**
    * add a key-value-pair to types<br>
    * this method is needed only for loading do not use it in other cases
    *
    * @param key    key for
    * @param value  new value
    */
   public abstract void addToTypes (String key, FType value);

   // --- Other methods ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract FType provideFType (String key);
}

/*
 * $Log: FTypeList.java,v $
 * Revision 1.2  2004/10/22 16:41:46  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
