/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.awt.event.*;
import java.util.ResourceBundle;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
class DirtyDialog extends JDialog implements WindowListener,
   ActionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DocMan docMan;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextFrame textFrame;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton cancel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton save;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton dontSave;


   /**
    * Constructor for class DirtyDialog
    *
    * @param dm       No description provided
    * @param tf       No description provided
    * @param strings  No description provided
    * @param title    No description provided
    * @param file     No description provided
    */
   public DirtyDialog (DocMan dm, TextFrame tf, ResourceBundle strings, String title, String file)
   {
      super (tf, title, true);

      docMan = dm;
      textFrame = tf;

      JPanel north = new JPanel();
      north.add (new Label (strings.getString ("TextDirty")));
      getContentPane().add ("Center", north);

      JPanel south = new JPanel();

      save = new JButton (strings.getString ("ButtonSave"));
      save.addActionListener (this);
      south.add (save);

      dontSave = new JButton (strings.getString ("ButtonDontSave"));
      dontSave.addActionListener (this);
      south.add (dontSave);

      cancel = new JButton (strings.getString ("ButtonCancel"));
      cancel.addActionListener (this);
      south.add (cancel);

      getContentPane().add ("South", south);

      pack();

      Dimension size = getSize();

      setLocation (textFrame.getPlace (size));

      addWindowListener (this);
   }

   // dispose on 'ok'

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      if (event.getSource() == cancel)
      {
         dispose();
      }
      else if (event.getSource() == dontSave)
      {
         docMan.doCloseFrame (textFrame);
         dispose();
      }
      else if (event.getSource() == save)
      {
         if (docMan.fileSave (textFrame))
         {
            docMan.doCloseFrame (textFrame);
         }
         dispose();
      }
   }

   // add the 1.1 WindowListener stuff

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeiconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowIconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowActivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeactivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowOpened (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosed (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosing (WindowEvent event)
   {
      dispose();
   }

}

/*
 * $Log: DirtyDialog.java,v $
 * Revision 1.13  2004/10/20 17:50:00  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
