/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;

import javax.swing.text.Document;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public interface DocInterface
{
   /**
    * Closes this document. If the "bail" flag is true changes will be discarded, otherwise
    * the user will be queried.
    *
    * @param bail  Exit immediately, discarding changes.
    */
   public void closeDoc (boolean bail);


   /**
    * Writes out this document.
    */
   public void saveDoc();


   /**
    * Writes out this document.
    *
    * @param pathname  New document name (full path).
    */
   public void saveAsDoc (String pathname);


   /**
    * Returns the full path to this document.
    *
    * @return   Document name (full path).
    */
   public String getPathname();


   /**
    * Returns the filename (no path) for this document.
    *
    * @return   Document name (no path).
    */
   public String getFilename();


   /**
    * Sets the filename for this document.
    *
    * @param fileName  Document name .
    */
   public void setFilename (String fileName);


   /**
    * Fetch the dirty flag.
    *
    * @return   True if the file has been changed since being written.
    */
   public boolean isDirty();


   /**
    * This sets the dirty flag. Use this method with special care, if the flag is set to false,
    * there will be no question about saving.
    *
    * @param d  The new dirty value
    */

   public void setDirty (boolean d);


   /**
    * Get the line count for a document.
    *
    * @return   The line count.
    */
   public int getLineCount();


   /**
    * Set a TagLine, used to track lines even when lines have been inserted or deleted elsewhere
    * in the document.
    *
    * @param lineNo  No description provided
    * @return        The TagLine for a given line.
    */
   public TagLine tagLine (int lineNo);


   /**
    * Set a TagLine (including a tag color), used to track lines even when lines have been
    * inserted or deleted elsewhere in the document.
    *
    * @param color   The Color to display (pass null to clear).
    * @param lineNo  No description provided
    * @return        The TagLine for a given line.
    */
   public TagLine tagLine (int lineNo, Color color);


   /**
    * Get the current line number for a TagLine.
    *
    * @param tag  No description provided
    * @return     The line for a given tag.
    */
   public int lineFromTag (TagLine tag);


   /**
    * Bring forward any view window and scroll to the desired line.
    *
    * @param tag  The line to display.
    * @return     Success.
    */
   public boolean showLine (TagLine tag);


   /**
    * Get the text for a line.
    *
    * @param tag  The line to get.
    * @return     The text for the line (null if TagLine not found).
    */
   public String getLine (TagLine tag);


   /**
    * Set the text for a line.
    *
    * @param tag   The line to set.
    * @param text  The text to set.
    * @return      Success.
    */
   public boolean setLine (TagLine tag, String text);


   /**
    * Insert a line of text before the TagLine.
    *
    * @param tag   The line to set.
    * @param text  The text to set.
    * @return      Success.
    */
   public boolean addLine (TagLine tag, String text);


   /**
    * Delete a line.
    *
    * @param tag  The line to delete.
    * @return     Success.
    */
   public boolean deleteLine (TagLine tag);


   /**
    * Copies the content of this doc into a swing-Document.
    *
    * @return   The document value
    */

   public Document getDocument();
}

/*
 * $Log: DocInterface.java,v $
 * Revision 1.14  2004/10/20 17:50:00  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
