/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public class Hilite
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   LineMan lines; // data for all lines

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int tabSize; // needed to expand lines

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int highestEver; // highest line scanned

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean inComment; // used in syntax scan

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean inLiteral; // used in syntax scan

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean initialComment; // used in syntax scan - initial comment state

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean initialLiteral; // used in syntax scan - initial literal state

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean inactive; // disable everything.

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean raise; // raise case before comparing keywords

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   char keys[][]; // array of keyword strings

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int keyCt; // temp buffers

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int keyStarts[] = new int[100];
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int keyEnds[] = new int[100];
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   byte keyTypes[] = new byte[100];

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   char buffer[]; //buffers a complete line, all tab char '\t' are replaced with blanks

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte PLAIN = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte KEYWORD = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte COMMENT = 2;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte QUOTE = 3;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static byte HIDE = 100; //for hide tags



   /**
    * Constructor for class Hilite
    *
    * @param l  No description provided
    * @param t  No description provided
    * @param a  No description provided
    */
   public Hilite (LineMan l, int t, boolean a)
   {
      lines = l;
      inactive = a;
      highestEver = -1;
      raise = false;
      initialComment = false;

      if (t > 0)
      {
         tabSize = t;
      }
      else
      {
         tabSize = 4;
      } // saftey

   }


   /**
    * Scans all lines in LineMan up to highest for syntax highlighting
    *
    * @param highest  No description provided
    */

   public void scan (int highest)
   {
      //if (inactive) removed to wipe out all hightlighting in LineInfo
      //   return;

      highestEver = -1;
      inComment = initialComment;
      inLiteral = initialLiteral;

      for (int i = 0; i <= highest; i++)
      {
         scanLine (i);
      }

      highestEver = highest;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param highest  No description provided
    */
   public void extendScan (int highest)
   {
      if ( (highest <= highestEver))
      { // || inactive) removed to wipe out all highlighting in LineInfo
         return;
      }

      if (highestEver >= 0)
      {
         LineInfo hi;
         hi = lines.getLineInfo (highestEver);
         inComment = hi.inComment;
         inLiteral = hi.inLiteral;
      }
      else
      {
         inComment = initialComment;
         inLiteral = initialLiteral;
      }

      for (int i = highestEver + 1; i <= highest; i++)
      {
         scanLine (i);
      }

      highestEver = highest;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param first    No description provided
    * @param last     No description provided
    * @param highest  No description provided
    * @return         No description provided
    */
   public int update (int first, int last, int highest)
   {
      int i;
      boolean oldComment = false;
      boolean oldLiteral = false;
      LineInfo hi;

      if (inactive)
      {
         return last;
      }

      if (first > 0)
      {
         hi = lines.getLineInfo (first - 1);
         inComment = hi.inComment;
         inLiteral = hi.inLiteral;
      }
      else
      {
         inComment = initialComment;
         inLiteral = initialLiteral;
      }

      i = lines.size() - 1;

      if (last > i)
      {
         last = i;
      }

      for (i = first; i <= last; i++)
      {
         scanLine (i);
      }

      if (highest < highestEver)
      {
         highestEver = highest;
      }

      while (i <= highestEver)
      {
         hi = lines.getLineInfo (i);
         oldComment = hi.inComment;
         oldLiteral = hi.inLiteral;
         scanLine (i++);
         if ( (oldComment == inComment) &&  (oldLiteral == inLiteral))
         {
            break;
         }
      }

      return i - 2; // "i" is two past the last changed line

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param i  No description provided
    */
   protected void scanLine (int i)
   {
      //Wipes all LineInfo out of LineMan except the data String

      LineInfo li = lines.getLineInfo (i);

      li.inComment = false;
      li.inLiteral = false;
      li.keyCt = 0;
      li.keyStarts = null;
      li.keyEnds = null;
      li.keyTypes = null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param i  No description provided
    */
   public void lineRemoved (int i)
   {
      if (i <= highestEver)
      {
         highestEver--;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param start  No description provided
    * @param end    No description provided
    * @return       No description provided
    */
   protected int matchOneKey (int key, int start, int end)
   {
      int i;
      int
         j;
      int
         max;
      char c;
      char
         d;

      char theKey[] = keys[key];

      i = 0;
      j = start;
      max = theKey.length;

      while ( (i < max) &&  (j < end))
      {
         c = theKey[i++];
         d = buffer[j++];

         if (raise &&  (d >= 'a') &&  (d <= 'z'))
         {
            d = (char)  (d + 'A' - 'a');
         }

         if (c > d)
         {
            return -1;
         }

         if (c < d)
         {
            return 1;
         }
      }

      if (i < max)
      {
         return -1;
      }

      if (j < end)
      {
         return 1;
      }

      return 0;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param start  No description provided
    * @param end    No description provided
    * @return       No description provided
    */
   protected boolean matchKeys (int start, int end)
   {
      int i;
      int
         j;
      int
         max;
      int
         diff;
      int
         extra;

      i = j = 0;
      diff = max = keys.length;

      // binary search

      while (0 !=  (diff >>= 1))
      {
         if (j < 0)
         {
            i -= diff;
         }
         else
         {
            i += diff;
         }

         j = matchOneKey (i, start, end);

         if (j == 0)
         {
            return true;
         }
      }

      extra = 4;

      while (extra-- > 0)
      {
         if (j < 0)
         {
            i--;
         }
         else
         {
            i++;
         }

         if ( (i < 0) ||  (i >= max))
         {
            return false;
         }

         j = matchOneKey (i, start, end);

         if (j == 0)
         {
            return true;
         }
      }

      return false;
   }


   /**
    * Fills char[] buffer with line line_no and replaces all tab characters '\t' with blanks
    *
    * @param line_no  line number to fill the buffer with
    * @return         length of buffer
    */
   protected int fillBuffer (int line_no)
   {
      char c;
      int i;
      int
         j;
      int
         tabs;
      int
         max;
      char before[];

      before = lines.getString (line_no).toCharArray();

      max = before.length;
      for (j = i = 0; i < max; i++)
      {
         if (before[i] == '\t')
         {
            j++;
         }
      }

      if (j == 0)
      {
         buffer = before;
         j = max;
      }
      else
      {
         buffer = new char[max +  (j *  (tabSize - 1))];

         for (j = i = 0; i < max; i++)
         {
            c = before[i];
            if (c == '\t')
            {
               tabs = tabSize -  (j % tabSize);
               while (tabs-- > 0)
               {
                  buffer[j++] = ' ';
               }
            }
            else
            {
               buffer[j++] = c;
            }
         }
      }

      return j;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color textColor = new Color (0x000000);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color textXColor = new Color (0xffffff);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color commentColor = new Color (0x009000);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color commentXColor = new Color (0x009000 ^ 0xffffff);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color keywordColor = new Color (0x0000b0);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color keywordXColor = new Color (0x0000b0 ^ 0xffffff);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color quoteColor = new Color (0xa00000);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color quoteXColor = new Color (0xa00000 ^ 0xffffff);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color hideColor = new Color (200, 200, 200); //for HiliteLife
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color hideXColor = new Color (55, 55, 55);

//  Or "really red" if you prefer
   //      protected Color quoteXColor = new Color(0xff0000);
   //      protected Color quoteXColor = new Color(0x00ffff);

   /**
    * Get the textColor attribute of the Hilite object
    *
    * @return   The textColor value
    */
   public Color getTextColor()
   {
      return textColor;
   }


   /**
    * Get the textXColor attribute of the Hilite object
    *
    * @return   The textXColor value
    */
   public Color getTextXColor()
   {
      return textXColor;
   }


   /**
    * Get the commentColor attribute of the Hilite object
    *
    * @return   The commentColor value
    */
   public Color getCommentColor()
   {
      return commentColor;
   }


   /**
    * Get the commentXColor attribute of the Hilite object
    *
    * @return   The commentXColor value
    */
   public Color getCommentXColor()
   {
      return commentXColor;
   }


   /**
    * Get the keywordColor attribute of the Hilite object
    *
    * @return   The keywordColor value
    */
   public Color getKeywordColor()
   {
      return keywordColor;
   }


   /**
    * Get the keywordXColor attribute of the Hilite object
    *
    * @return   The keywordXColor value
    */
   public Color getKeywordXColor()
   {
      return keywordXColor;
   }


   /**
    * Get the quoteColor attribute of the Hilite object
    *
    * @return   The quoteColor value
    */
   public Color getQuoteColor()
   {
      return quoteColor;
   }


   /**
    * Get the quoteXColor attribute of the Hilite object
    *
    * @return   The quoteXColor value
    */
   public Color getQuoteXColor()
   {
      return quoteXColor;
   }


   /**
    * Get the hideColor attribute of the Hilite object
    *
    * @return   The hideColor value
    */
   public Color getHideColor()
   {
      return hideColor;
   }


   /**
    * Get the hideXColor attribute of the Hilite object
    *
    * @return   The hideXColor value
    */
   public Color getHideXColor()
   {
      return hideXColor;
   }

}

/*
 * $Log: Hilite.java,v $
 * Revision 1.14  2004/10/20 17:50:00  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
