/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Hashtable;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
class KeyMapStd extends KeyMap
{
   /**
    * Constructor for class KeyMapStd
    */
   public KeyMapStd()
   {
      keyhash = new Hashtable();

      setKeyAction ("brace-match-backward", Event.ALT_MASK, 219); // '['

      setKeyAction ("brace-match-forward", Event.ALT_MASK, 221); // ']'

      setKeyAction ("buffer-paste", Event.CTRL_MASK, KeyEvent.VK_V);
      setKeyAction ("character-delete-backward", 0, KeyEvent.VK_BACK_SPACE);
      setKeyAction ("character-delete-forward", 0, KeyEvent.VK_DELETE);
      setKeyAction ("cursor-backward", 0, KeyEvent.VK_LEFT);
      setKeyAction ("cursor-document-begin", InputEvent.CTRL_MASK, KeyEvent.VK_PAGE_UP);
      setKeyAction ("cursor-document-end", InputEvent.CTRL_MASK, KeyEvent.VK_PAGE_DOWN);
      setKeyAction ("cursor-down", 0, KeyEvent.VK_DOWN);
      setKeyAction ("cursor-forward", 0, KeyEvent.VK_RIGHT);
      setKeyAction ("cursor-line-begin", 0, KeyEvent.VK_HOME);
      setKeyAction ("cursor-line-end", 0, KeyEvent.VK_END);
      setKeyAction ("cursor-page-begin", InputEvent.CTRL_MASK, KeyEvent.VK_HOME);
      setKeyAction ("cursor-page-end", InputEvent.CTRL_MASK, KeyEvent.VK_END);
      setKeyAction ("cursor-up", 0, KeyEvent.VK_UP);
      setKeyAction ("cursor-word-backward", Event.CTRL_MASK, KeyEvent.VK_LEFT);
      setKeyAction ("cursor-word-forward", Event.CTRL_MASK, KeyEvent.VK_RIGHT);
      setKeyAction ("document-new", Event.CTRL_MASK, KeyEvent.VK_N);
      setKeyAction ("document-open-dialog", Event.CTRL_MASK, KeyEvent.VK_O);
      setKeyAction ("document-print-dialog", Event.ALT_MASK, KeyEvent.VK_P);
      setKeyAction ("document-save", Event.ALT_MASK, KeyEvent.VK_S);
      setKeyAction ("find-dialog", Event.CTRL_MASK, KeyEvent.VK_F);
      setKeyAction ("find-next-backward", Event.ALT_MASK, KeyEvent.VK_UP);
      setKeyAction ("find-next-forward", Event.ALT_MASK, KeyEvent.VK_DOWN);
      setKeyAction ("frame-close", Event.CTRL_MASK, KeyEvent.VK_W);
      setKeyAction ("goto-dialog", Event.CTRL_MASK, KeyEvent.VK_G);
      setKeyAction ("line-break", 0, KeyEvent.VK_ENTER);
      setKeyAction ("line-clone", Event.ALT_MASK, KeyEvent.VK_O);
      setKeyAction ("line-delete", Event.ALT_MASK, KeyEvent.VK_D);
      setKeyAction ("line-swap", Event.ALT_MASK, KeyEvent.VK_S);
      setKeyAction ("mode-autoindent-switch", Event.ALT_MASK, KeyEvent.VK_F3);
      setKeyAction ("page-down", 0, KeyEvent.VK_PAGE_DOWN);
      setKeyAction ("page-up", 0, KeyEvent.VK_PAGE_UP);
      setKeyAction ("redo", Event.CTRL_MASK, KeyEvent.VK_Y);
      setKeyAction ("replace-dialog", Event.CTRL_MASK, KeyEvent.VK_H);
      setKeyAction ("selection-copy", Event.CTRL_MASK, KeyEvent.VK_C);
      setKeyAction ("selection-cut", Event.CTRL_MASK, KeyEvent.VK_X);
      setKeyAction ("undo", Event.CTRL_MASK, KeyEvent.VK_Z);

      // temporary
      setKeyAction ("keytable-save", Event.ALT_MASK, KeyEvent.VK_V);
      setKeyAction ("keytable-load", Event.ALT_MASK, KeyEvent.VK_L);
      setKeyAction ("mode-readonly-switch", Event.ALT_MASK, KeyEvent.VK_R);
   }
}

/*
 * $Log: KeyMapStd.java,v $
 * Revision 1.10  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
