/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;

// Meta Info for a Single Line

/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class LineInfo
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected String data; // one line of text

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected boolean inComment; // true if line ends with continuing comment

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected boolean inLiteral; // true if line ends with continuing literal (possibly by mistake)

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected int keyCt; // # of keywords on line

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected int keyStarts[]; // array of keyword starts

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected int keyEnds[]; // array of keyword lengths

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected byte keyTypes[]; // array of keyword types

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected int tagValue; // unique integer used to identify line

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Color tagColor; // tags may color line backgrounds (or not)


   /**
    * Constructor for class LineInfo
    *
    * @param s  No description provided
    */
   public LineInfo (String s)
   {
      data = s;
   }


   /**
    * this works for columns not char numbers, so not quite working now
    *
    * @param number  No description provided
    * @return        true if character at given place is not in comment nor literal
    */

   public boolean isFreeStanding (int number)
   {
      return true;
      /*
       *  int i;
       *  for ( i =0; i < keyCt; i++)
       *  {
       *  if ( keyStarts[i] > number )
       *  continue;
       *  if ( (keyEnds[i] >= number) &&
       *  ((keyTypes[i] == Hilite.QUOTE) || (keyTypes[i] == Hilite.COMMENT)) )
       *  return false;
       *  }
       *  return true;
       */
   }
}

/*
 * $Log: LineInfo.java,v $
 * Revision 1.11  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
