/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;


/**
 * MpEDIT own swing-like action implementation Can be later changed to swing one, or extended
 * for free-builder
 *
 * @author    Artur Biesiadowski
 * @version   $Revision: 1.11 $ $Date: 2004/10/20 17:50:01 $
 * @see       AbstractMpAction
 */

interface MpAction extends ActionListener
{

   /*
    *  Inherited from ActionListener
    *  Main method, called from various places to execute action
    *  @param evt event which caused the action
    */
   //public void actionPerformed(ActionEvent evt);

   /**
    * Text to be displayed on text button or in menu
    */
   public final static String NAME = "Name";

   /**
    * Verbose description for help, or advanced info
    */
   public final static String LONG_DESCRIPTION = "LongDescription";

   /**
    * Short description to be displayed in tooltips etc
    */
   public final static String SHORT_DESCRIPTION = "ShortDescription";

   /**
    * Key string for returning small (16x16) icon to be displayd on button
    */
   public final static String SMALL_ICON = "SmallIcon";

   /**
    * mpEDIT additon: Small Icon in disabled state
    */

   public final static String SMALL_ICON_DISABLED = "SmallIconDisabled";

   /**
    * mpEDIT addition: provide emacs-like action identifier
    */
   public final static String ID_STRING = "IdString";

   /**
    * Identifier passed to PropertyChangeListeners when enabled flag has changed
    */
   public final static String ENABLED = "enabled";


   /**
    * Returns text for action for specific key
    *
    * @param key  No description provided
    * @return     The text value
    */
   public String getText (String key);


   /**
    * Sets text for action for specific key
    *
    * @param key   The new text value
    * @param text  The new text value
    */
   public void setText (String key, String text);


   /**
    * @return   emacs-like name identifier for action
    */
   public String getIdString();


   /**
    * Get the shortDescription attribute of the MpAction object
    *
    * @return   The shortDescription value
    */
   public String getShortDescription();


   /**
    * Sets the shortDescription attribute of the MpAction object
    *
    * @param txt  The new shortDescription value
    */
   public void setShortDescription (String txt);


   /**
    * Get the name attribute of the MpAction object
    *
    * @return   The name value
    */
   public String getName();


   /**
    * Sets the name attribute of the MpAction object
    *
    * @param txt  The new name value
    */
   public void setName (String txt);



   //public Icon getIcon( String key );
   //public void setIcon( String key , Icon icon);


   /**
    * Is action enabled for its component
    *
    * @return   The enabled value
    */
   public boolean isEnabled();


   /**
    * Enable/disable action for given component
    *
    * @param b  The new enabled value
    */
   public void setEnabled (boolean b);


   /**
    * Add object to be notified of change in any of the values (mainly enabled state)
    *
    * @param listener  The object added.
    */
   public void addPropertyChangeListener (PropertyChangeListener listener);


   /**
    * Add object to be notified of change in any of action's values
    *
    * @param listener  No description provided
    */
   public void removePropertyChangeListener (PropertyChangeListener listener);

}

/*
 * $Log: MpAction.java,v $
 * Revision 1.11  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
