/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.awt.event.*;
import java.util.ResourceBundle;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
class ReplaceDialog extends JDialog implements WindowListener,
   ActionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton fbutton,
      rbutton,
      cbutton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField pattern;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField replace;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextFrame textFrame;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextCanvas textCanvas;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextMenu textMenu;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ResourceBundle strings;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String pat;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String rep;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean foundOnce = false;


   /**
    * Constructor for class ReplaceDialog
    *
    * @param tf     No description provided
    * @param tm     No description provided
    * @param str    No description provided
    * @param title  No description provided
    */
   public ReplaceDialog (TextFrame tf, TextMenu tm, ResourceBundle str, String title)
   {
      super (tf, title, false);

      setBackground (Color.lightGray);

      textMenu = tm;
      strings = str;
      textFrame = tf;
      textCanvas = textFrame.getCanvas();

      String[] searchStrs = textFrame.getCanvas().getSearchPatterns();

      JPanel p1 = new JPanel();

      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();
      p1.setLayout (gridbag);

      JLabel flabel = new JLabel (strings.getString ("PromptFind"));
      constraints.anchor = GridBagConstraints.NORTHWEST;
      gridbag.setConstraints (flabel, constraints);

      pat = searchStrs[searchStrs.length - 2];
      pattern = new JTextField (pat, 20);

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      gridbag.setConstraints (pattern, constraints);

      p1.add (flabel);
      p1.add (pattern);

      JLabel rlabel = new JLabel (strings.getString ("PromptReplace"));
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = 1;
      gridbag.setConstraints (rlabel, constraints);

      rep = searchStrs[searchStrs.length - 1];
      replace = new JTextField (rep, 20);

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      gridbag.setConstraints (replace, constraints);

      p1.add (rlabel);
      p1.add (replace);

      getContentPane().add ("Center", p1);

      JPanel p3 = new JPanel();
      fbutton = new JButton (strings.getString ("ButtonFindNext"));
      fbutton.addActionListener (this);
      p3.add (fbutton);
      rbutton = new JButton (strings.getString ("ButtonReplace"));
      rbutton.addActionListener (this);
      p3.add (rbutton);
      cbutton = new JButton (strings.getString ("ButtonClose"));
      cbutton.addActionListener (this);
      p3.add (cbutton);
      getContentPane().add ("South", p3);

      pack();

      Dimension size = getSize();

      setLocation (textFrame.getPlace (size));

      addWindowListener (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeiconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowIconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowActivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeactivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowOpened (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosed (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosing (WindowEvent event)
   {
      textMenu.CloseReplaceDialog (pattern.getText(), replace.getText());
      dispose();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   public void actionPerformed (ActionEvent evt)
   {
      if (evt.getSource() == cbutton)
      {
         textMenu.CloseReplaceDialog (pattern.getText(), replace.getText());
         dispose();
         return;
      }

      if (evt.getSource() == fbutton)
      {
         foundOnce = textCanvas.find (pattern.getText());
      }
      else if (evt.getSource() == rbutton)
      {
         if (!foundOnce)
         {
            String selection = textCanvas.copy (false, false);
            if (selection != null)
            {
               foundOnce = selection.equals (pattern.getText());
            }
         }

         if (foundOnce)
         {
            textCanvas.paste (replace.getText());
         }

         foundOnce = textCanvas.find (pattern.getText());
      }

      if (!foundOnce)
      {
         NotFoundDialog nf = new NotFoundDialog (textFrame, strings);
         nf.show();
      }
   }

}

/*
 * $Log: ReplaceDialog.java,v $
 * Revision 1.14  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
