/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences;

import java.beans.PropertyChangeListener;
import java.util.Vector;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: burmi $
 * @version   $Revision: 1.12 $
 */
public class JavaPreferences extends AbstractPreferences
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PROPERTY_NAME = "Java.";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INT_VAR_PREFIX = "InternalVariablePrefix";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CODE_GEN_TARGET_NAME = "CodeGenTargetName";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CODE_GEN_TARGET_JAVA = "java";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DEF_INT_VAR_PREFIX = "fujaba__";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static Vector DEF_CODE_GEN_TARGET_NAME = new Vector();

   static
   {
      DEF_CODE_GEN_TARGET_NAME.add (CODE_GEN_TARGET_JAVA);
      DEF_CODE_GEN_TARGET_NAME.add ("dlr");
   }

   /**
    * This is the singleton instance.
    */
   private static JavaPreferences theOptionsJava;


   /**
    * This is a singleton class. Use get() to get an instance from this class.
    */
   private JavaPreferences() { }


   /**
    * @return   the singleton instance
    */
   public static JavaPreferences get()
   {
      if (theOptionsJava == null)
      {
         theOptionsJava = new JavaPreferences();
      }

      return theOptionsJava;
   }


   /**
    * @see   de.uni_paderborn.fujaba.preferences.AbstractPreferences#setDefaults()
    */
   public void setDefaults()
   {
      PreferencesProperties options = PreferencesProperties.get();

      options.putSetting (PROPERTY_NAME + INT_VAR_PREFIX, DEF_INT_VAR_PREFIX);

      options.putSetting (PROPERTY_NAME + CODE_GEN_TARGET_NAME, DEF_CODE_GEN_TARGET_NAME);
   }


   // ----------------------------------------------------------------------------
   // property change support
   // ----------------------------------------------------------------------------

   /**
    * Access method for an one to n association.
    *
    * @param propertyName  The object added.
    * @param listener      The object added.
    */
   public void addPropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().addPropertyChangeListener (propertyName, listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param propertyName  No description provided
    * @param listener      No description provided
    */
   public void removePropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().removePropertyChangeListener (propertyName, listener);
   }


   // ----------------------------------------------------------------------------
   // getter and setter for the properties
   // ----------------------------------------------------------------------------

   /**
    * Get the internalVariablePrefix attribute of the JavaPreferences object
    *
    * @return   The internalVariablePrefix value
    */
   public String getInternalVariablePrefix()
   {
      return PreferencesProperties.get().getSetting (PROPERTY_NAME + INT_VAR_PREFIX, DEF_INT_VAR_PREFIX);
   }


   /**
    * Sets the internalVariablePrefix attribute of the JavaPreferences object
    *
    * @param newPrefix  The new internalVariablePrefix value
    */
   public void setInternalVariablePrefix (String newPrefix)
   {
      PreferencesProperties options = PreferencesProperties.get();

      newPrefix = newPrefix.trim();

      // check if the new prefix has more than 1 character and doesn't contain blancs
      if ( (newPrefix.length() >= 2) ||  (newPrefix.indexOf (" ") == -1))
      {
         if (!options.getSetting (PROPERTY_NAME + INT_VAR_PREFIX, DEF_INT_VAR_PREFIX).equals (newPrefix))
         {
            options.putSetting (PROPERTY_NAME + INT_VAR_PREFIX, newPrefix);
            setModified (true);
         }
      }
   }


   /**
    * Get the codeGenTargetName attribute of the JavaPreferences object
    *
    * @return   The codeGenTargetName value
    */
   public Vector getCodeGenTargetName()
   {
      return PreferencesProperties.get().getVectorSetting (PROPERTY_NAME + CODE_GEN_TARGET_NAME, DEF_CODE_GEN_TARGET_NAME);
   }


   /**
    * Sets the codeGenTargetName attribute of the JavaPreferences object
    *
    * @param newTargetName  The new codeGenTargetName value
    */
   public void setCodeGenTargetName (Vector newTargetName)
   {
      PreferencesProperties options = PreferencesProperties.get();

      if (!options.getVectorSetting (PROPERTY_NAME + CODE_GEN_TARGET_NAME).equals (newTargetName))
      {
         options.putSetting (PROPERTY_NAME + CODE_GEN_TARGET_NAME, newTargetName);
         setModified (true);
      }
   }
}

/*
 * $Log: JavaPreferences.java,v $
 * Revision 1.12  2004/11/28 15:43:20  burmi
 * added codegen panel to preferences in order to chose target language
 *
 */
