/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.awt.*;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.*;

import de.uni_paderborn.fujaba.preferences.ColorsPreferences;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.5 $
 */
public class ColorsPreferencesPanel extends PreferencesPanel
{
   /**
    * List of all colors
    */
   JList colorList;

   /**
    * Display and change current color
    */
   JColorChooser colorChooser;

   /**
    * Stores the names of colors displayed in the JList colors
    */
   private Vector colorData;

   /**
    * Listen to changes of the selection in the color list
    */
   private ListSelectionListener selectionListener =
      new ListSelectionListener()
      {
         /**
          * Called whenever the value of the selection changes.
          *
          * @param e  the event that characterizes the change.
          */
         public void valueChanged (ListSelectionEvent e)
         {
            String name = (String) colorList.getSelectedValue();
            Color clr = ColorsPreferences.get().getColor (name);
            if (clr == null)
            {
               clr = Color.white;
            }
            colorChooser.setColor (clr);
         }
      };

   /**
    * Listen to changes to the currently selected color
    */
   private ChangeListener colorListener =
      new ChangeListener()
      {
         /**
          * Invoked when the target of the listener has changed its state.
          *
          * @param e  a ChangeEvent object
          */
         public void stateChanged (ChangeEvent e)
         {
            String name = (String) colorList.getSelectedValue();
            ColorsPreferences.get().setColor (name, colorChooser.getColor());
         }
      };


   /**
    * Constructor for class ColorsPreferencesPanel
    */
   public ColorsPreferencesPanel()
   {
      setLayout (new BorderLayout());

      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (gridBagLayout);
      mainPanel.setBorder (new TitledBorder ("Color Settings"));

      colorData = new Vector();
      colorList = new JList (colorData);
      colorList.setToolTipText ("Fujaba needs to be restarted for all color changes to take effect.");
      colorList.addListSelectionListener (selectionListener);
      JScrollPane scrollPane = new JScrollPane (colorList);
      constraints.gridwidth = GridBagConstraints.RELATIVE;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.weightx = 0;
      constraints.weighty = 1;
      mainPanel.add (scrollPane, constraints);

      colorChooser = new JColorChooser();
      colorChooser.getSelectionModel().addChangeListener (colorListener);
      constraints.weightx = 1;
      mainPanel.add (colorChooser, constraints);

      add (mainPanel, BorderLayout.NORTH);

      setPreferences();
   }


   /**
    * Returns the preferred name of a tab for this panel
    *
    * @return   The preferredTabName value
    */
   public String getPreferredTabName()
   {
      return "Colors";
   }


   /**
    * Get all the options from the panel and set the real options.
    */
   public void okPressed()
   {
      ColorsPreferences.get().save();
   }


   /**
    * Set all options to default values.
    */
   public void setDefaults()
   {
      ColorsPreferences.get().setDefaults();
      setPreferences();
   }


   /**
    * Set the options in the panel, because the options could have changed elsewhere.
    */
   public void setPreferences()
   {
      colorData.clear();

      Iterator it = ColorsPreferences.get().getColors();
      while (it.hasNext())
      {
         String name = (String) it.next();
         colorData.add (name);
      }

      if (colorData.size() > 0)
      {
         colorList.setSelectedIndex (0);
      }
   }
}

/*
 * $Log: ColorsPreferencesPanel.java,v $
 * Revision 1.5  2004/10/20 17:50:08  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
