/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.preferences.DebugPreferences;


/**
 * Options panel for the debug environment.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class DebugPreferencesPanel extends PreferencesPanel
{
   /**
    * some variable for the FujabaDebug module
    */
   private JCheckBox checkBoxDebug;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox checkBoxSaveGenerated;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JCheckBox[] debugBoxes;


   /**
    * The constructor. It builds a gui interface for the dialog.
    */
   public DebugPreferencesPanel()
   {
      setLayout (new BorderLayout());

      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (gridBagLayout);

      // add folder panel
      JPanel folderPanel = createDebugPanel();
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.weightx = 1;
      mainPanel.add (folderPanel, constraints);

      // add editorPanel
      JPanel editorPanel = createDebugMessagePanel();
      mainPanel.add (editorPanel, constraints);

      add (mainPanel, BorderLayout.NORTH);
   } // OptionsPanelDebug


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createDebugPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Debug Mode"));
      panel.setLayout (gridBagLayout);

      checkBoxDebug = new JCheckBox ("Enable Debug Mode");
      checkBoxDebug.addActionListener (new DebugCheckBoxActionListener());
      checkBoxDebug.setToolTipText ("The debug mode enables actions for debugging Fujaba");
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (3, 3, 0, 3);
      constraints.weightx = 1;
      gridBagLayout.setConstraints (checkBoxDebug, constraints);
      panel.add (checkBoxDebug);

      checkBoxSaveGenerated = new JCheckBox ("Save Generated Increments");
      checkBoxSaveGenerated.setToolTipText ("Generated increments will be saved in project.");
      constraints.insets = new Insets (2, 3, 3, 3);
      gridBagLayout.setConstraints (checkBoxSaveGenerated, constraints);
      panel.add (checkBoxSaveGenerated);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createDebugMessagePanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Debug Level"));
      panel.setLayout (gridBagLayout);

      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (2, 3, 0, 3);

      String[] labelArray =
         {
         "Save/Load", "Code Generation", "Display", "Analyzing", "UML",
         "Parsing", "Gui", "RemoveYou Methods", "Plug-Ins", "Everything else"};

      debugBoxes = new JCheckBox[labelArray.length];

      int rows = labelArray.length / 2;
      for (int i = 0; i < labelArray.length; i++)
      {
         debugBoxes[i] = new JCheckBox (labelArray[i]);

         constraints.weightx = i / rows;
         constraints.gridx = i / rows;
         constraints.gridy = i % rows;

         gridBagLayout.setConstraints (debugBoxes[i], constraints);
         panel.add (debugBoxes[i]);
      }

      return panel;
   }


   /**
    * Returns the preferred name of a tab for this panel
    *
    * @return   The preferredTabName value
    */
   public String getPreferredTabName()
   {
      return  ("Debug");
   } // getPreferredTabName


   /**
    * Set all options to default values.
    */
   public void setDefaults()
   {
      DebugPreferences.get().setDefaults();
      setPreferences();
   } // setDefaults


   /**
    * Set the options in the panel, because the options could have changed elsewhere.
    */
   public void setPreferences()
   {
      DebugPreferences options = DebugPreferences.get();

      checkBoxDebug.setSelected (options.isDebugMode());
      checkBoxSaveGenerated.setSelected (options.isSaveGenerated());
      setDebugBoxes (options.getDebugLevel());

      boolean enabled = checkBoxDebug.isSelected();
      for (int i = 0; i < debugBoxes.length; i++)
      {
         debugBoxes[i].setEnabled (enabled);
      }
   } // setSelected


   /**
    * Get all the options from the panel and set the real options.
    */
   public void okPressed()
   {
      DebugPreferences options = DebugPreferences.get();

      options.setDebugMode (checkBoxDebug.isSelected());
      options.setSaveGenerated (checkBoxSaveGenerated.isSelected());
      options.setDebugLevel (getDebugBoxes());
   } // okPressed


   /**
    * Sets the debugBoxes attribute of the OptionsPanelDebug object
    *
    * @param value  The new debugBoxes value
    */
   private void setDebugBoxes (int value)
   {
      int pow;

      for (int i = 0; i < debugBoxes.length; i++)
      {
         pow = (int) Math.pow (2, i);

         if ( (value & pow) == pow)
         {
            debugBoxes[i].setSelected (true);
         }
      }
   }


   /**
    * Get the debugBoxes attribute of the OptionsPanelDebug object
    *
    * @return   The debugBoxes value
    */
   private int getDebugBoxes()
   {
      int value = 0;

      for (int i = 0; i < debugBoxes.length; i++)
      {
         if (debugBoxes[i].isSelected())
         {
            value += Math.pow (2, i);
         }
      }

      return value;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.8 $
    */
   private class DebugCheckBoxActionListener implements ActionListener
   {

      /**
       * @param event  No description provided
       * @see          java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed (ActionEvent event)
      {
         JCheckBox button = (JCheckBox) event.getSource();
         boolean enabled = button.isSelected();
         for (int i = 0; i < debugBoxes.length; i++)
         {
            debugBoxes[i].setEnabled (enabled);
         }
      }
   }
}

/*
 * $Log: DebugPreferencesPanel.java,v $
 * Revision 1.8  2004/10/20 17:50:08  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
